/**
 * The create* and delete* methods on the table allow authors to construct and modify tables. [HTML 4.01] specifies that only one of each of the CAPTION, THEAD, and TFOOT elements may exist in a table. Therefore, if one exists, and the createTHead() or createTFoot() method is called, the method returns the existing THead or TFoot element. See the TABLE element definition in HTML 4.01.
 */
var HTMLTableElement = {
}
/**
 * Create a table footer row or return an existing one.
 * @syntax hTMLTableElement.createTFoot()
 * @returns {HTMLElement} A footer element (TFOOT).
 */
HTMLTableElement.prototype.createTFoot = function() {};

/**
 * Description about the purpose or structure of a table. See the summary attribute definition in HTML 4.01.
 * @syntax hTMLTableElement.summary
 * @returns {String} 
 */
HTMLTableElement.prototype.summary = new String();

/**
 * Returns the table's TFOOT, or null if none exists. Exceptions on setting DOMException HIERARCHY_REQUEST_ERR: if the element is not a TFOOT.
 * @syntax hTMLTableElement.tFoot
 * @returns {HTMLTableSectionElement} 
 */
HTMLTableElement.prototype.tFoot = new HTMLTableSectionElement();

/**
 * Delete the footer from the table, if one exists.
 * @syntax hTMLTableElement.deleteTFoot()
 * @returns {undefined} 
 */
HTMLTableElement.prototype.deleteTFoot = function() {};

/**
 * Specifies the desired table width. See the width attribute definition in HTML 4.01.
 * @syntax hTMLTableElement.width
 * @returns {String} 
 */
HTMLTableElement.prototype.width = new String();

/**
 * Specifies the table's position with respect to the rest of the document. See the align attribute definition in HTML 4.01. This attribute is deprecated in HTML 4.01.
 * @syntax hTMLTableElement.align
 * @returns {String} 
 */
HTMLTableElement.prototype.align = new String();

/**
 * Specifies the horizontal and vertical separation between cells. See the cellspacing attribute definition in HTML 4.01.
 * @syntax hTMLTableElement.cellSpacing
 * @returns {String} 
 */
HTMLTableElement.prototype.cellSpacing = new String();

/**
 * Delete the table caption, if one exists.
 * @syntax hTMLTableElement.deleteCaption()
 * @returns {undefined} 
 */
HTMLTableElement.prototype.deleteCaption = function() {};

/**
 * Returns the table's CAPTION, or void if none exists. Exceptions on setting DOMException HIERARCHY_REQUEST_ERR: if the element is not a CAPTION.
 * @syntax hTMLTableElement.caption
 * @returns {HTMLTableCaptionElement} 
 */
HTMLTableElement.prototype.caption = new HTMLTableCaptionElement();

/**
 * Returns a collection of the table bodies (including implicit ones).
 * @syntax hTMLTableElement.tBodies
 * @returns {HTMLCollection} 
 */
HTMLTableElement.prototype.tBodies = new HTMLCollection();

/**
 * Delete a table row.
 * @syntax hTMLTableElement.deleteRow(index)
 * @param {Number} index The index of the row to be deleted. This index starts from 0 and is relative to the logical order (not document order) of all the rows contained inside the table. If the index is -1 the last row in the table is deleted.
 * @returns {undefined} 
 */
HTMLTableElement.prototype.deleteRow = function(index) {};

/**
 * Specifies which internal table borders to render. See the rules attribute definition in HTML 4.01.
 * @syntax hTMLTableElement.rules
 * @returns {String} 
 */
HTMLTableElement.prototype.rules = new String();

/**
 * Returns a collection of all the rows in the table, including all in THEAD, TFOOT, all TBODY elements.
 * @syntax hTMLTableElement.rows
 * @returns {HTMLCollection} 
 */
HTMLTableElement.prototype.rows = new HTMLCollection();

/**
 * Specifies the horizontal and vertical space between cell content and cell borders. See the cellpadding attribute definition in HTML 4.01.
 * @syntax hTMLTableElement.cellPadding
 * @returns {String} 
 */
HTMLTableElement.prototype.cellPadding = new String();

/**
 * Cell background color. See the bgcolor attribute definition in HTML 4.01. This attribute is deprecated in HTML 4.01.
 * @syntax hTMLTableElement.bgColor
 * @returns {String} 
 */
HTMLTableElement.prototype.bgColor = new String();

/**
 * Insert a new empty row in the table. The new row is inserted immediately before and in the same section as the current indexth row in the table. If index is -1 or equal to the number of rows, the new row is appended. In addition, when the table is empty the row is inserted into a TBODY which is created and inserted into the table. Note: A table row cannot be empty according to [HTML 4.01].
 * @syntax hTMLTableElement.insertRow(index)
 * @param {Number} index The row number where to insert a new row. This index starts from 0 and is relative to the logical order (not document order) of all the rows contained inside the table.
 * @returns {HTMLElement} The newly created row.
 */
HTMLTableElement.prototype.insertRow = function(index) {};

/**
 * Specifies which external table borders to render. See the frame attribute definition in HTML 4.01.
 * @syntax hTMLTableElement.frame
 * @returns {String} 
 */
HTMLTableElement.prototype.frame = new String();

/**
 * Returns the table's THEAD, or null if none exists. Exceptions on setting DOMException HIERARCHY_REQUEST_ERR: if the element is not a THEAD.
 * @syntax hTMLTableElement.tHead
 * @returns {HTMLTableSectionElement} 
 */
HTMLTableElement.prototype.tHead = new HTMLTableSectionElement();

/**
 * The width of the border around the table. See the border attribute definition in HTML 4.01.
 * @syntax hTMLTableElement.border
 * @returns {String} 
 */
HTMLTableElement.prototype.border = new String();

/**
 * Create a new table caption object or return an existing one.
 * @syntax hTMLTableElement.createCaption()
 * @returns {HTMLElement} A CAPTION element.
 */
HTMLTableElement.prototype.createCaption = function() {};

/**
 * Create a table header row or return an existing one.
 * @syntax hTMLTableElement.createTHead()
 * @returns {HTMLElement} A new table header element (THEAD).
 */
HTMLTableElement.prototype.createTHead = function() {};

/**
 * Delete the header from the table, if one exists.
 * @syntax hTMLTableElement.deleteTHead()
 * @returns {undefined} 
 */
HTMLTableElement.prototype.deleteTHead = function() {};

/**
 * Represents the HTMLTableElement prototype object.
 * @syntax HTMLTableElement.prototype
 * @static
 */
HTMLTableElement.prototype;

