/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.client.auth;

import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.exception.RadiusException;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.util.CHAP;
import net.jradius.util.RadiusRandom;

public class CHAPAuthenticator
extends RadiusAuthenticator {
    public static final String NAME = "chap";

    public String getAuthName() {
        return NAME;
    }

    public void processRequest(RadiusPacket p) throws RadiusException, NoSuchAlgorithmException {
        if (this.password == null) {
            throw new RadiusException("no password given");
        }
        p.removeAttribute(this.password);
        byte[] authChallenge = RadiusRandom.getBytes(16);
        byte[] chapResponse = CHAP.chapResponse((byte)p.getIdentifier(), this.password.getValue().getBytes(), authChallenge);
        RadiusAttribute attr = AttributeFactory.newAttribute("CHAP-Challenge");
        p.addAttribute(attr);
        attr.setValue(authChallenge);
        attr = AttributeFactory.newAttribute("CHAP-Password");
        p.addAttribute(attr);
        attr.setValue(chapResponse);
    }

    public static boolean verifyPassword(byte[] response, byte[] challenge, byte id, byte[] clearText) throws NoSuchAlgorithmException {
        byte[] chapResponse = CHAP.chapResponse(response[0], clearText, challenge);
        return Arrays.equals(response, chapResponse);
    }
}

