/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.nonstop.store;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.cluster.CacheCluster;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.config.NonstopConfiguration;
import net.sf.ehcache.config.TimeoutBehaviorConfiguration;
import net.sf.ehcache.constructs.nonstop.ClusterOperation;
import net.sf.ehcache.constructs.nonstop.NonstopActiveDelegateHolder;
import net.sf.ehcache.constructs.nonstop.concurrency.NonstopSync;
import net.sf.ehcache.constructs.nonstop.store.ExecutorServiceStore;
import net.sf.ehcache.constructs.nonstop.store.NonstopStore;
import net.sf.ehcache.constructs.nonstop.store.NonstopTimeoutBehaviorStoreResolver;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.StoreListener;
import net.sf.ehcache.store.StoreQuery;
import net.sf.ehcache.store.TerracottaStore;
import net.sf.ehcache.writer.CacheWriterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonstopStoreImpl
implements NonstopTimeoutBehaviorStoreResolver,
NonstopStore {
    private final NonstopActiveDelegateHolder nonstopActiveDelegateHolder;
    private final NonstopConfiguration nonstopConfig;
    private final ConcurrentMap<TimeoutBehaviorConfiguration.TimeoutBehaviorType, NonstopStore> timeoutBehaviors;
    private final ExecutorServiceStore executorServiceStore;

    public NonstopStoreImpl(NonstopActiveDelegateHolder nonstopActiveDelegateHolder, CacheCluster cacheCluster, NonstopConfiguration nonstopConfig) {
        this.nonstopActiveDelegateHolder = nonstopActiveDelegateHolder;
        this.nonstopConfig = nonstopConfig;
        this.timeoutBehaviors = new ConcurrentHashMap<TimeoutBehaviorConfiguration.TimeoutBehaviorType, NonstopStore>();
        this.executorServiceStore = new ExecutorServiceStore(nonstopActiveDelegateHolder, nonstopConfig, this, cacheCluster);
    }

    @Override
    public NonstopStore resolveTimeoutBehaviorStore() {
        NonstopStore prev;
        TimeoutBehaviorConfiguration.TimeoutBehaviorType timeoutBehaviorType = this.nonstopConfig.getTimeoutBehavior().getTimeoutBehaviorType();
        NonstopStore timeoutStore = (NonstopStore)this.timeoutBehaviors.get((Object)timeoutBehaviorType);
        if (timeoutStore == null && (prev = this.timeoutBehaviors.putIfAbsent(timeoutBehaviorType, timeoutStore = this.nonstopConfig.getTimeoutBehavior().getNonstopTimeoutBehaviorFactory().createNonstopTimeoutBehaviorStore(this.nonstopActiveDelegateHolder))) != null) {
            timeoutStore = prev;
        }
        return timeoutStore;
    }

    TerracottaStore getUnderlyingStore() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore();
    }

    @Override
    public Object getInternalContext() {
        return this;
    }

    @Override
    public void waitUntilClusterCoherent() throws UnsupportedOperationException {
        this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().waitUntilClusterCoherent();
    }

    @Override
    public boolean bufferFull() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().bufferFull();
    }

    @Override
    public boolean containsKeyOffHeap(Object key) {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().containsKeyOffHeap(key);
    }

    @Override
    public boolean containsKeyOnDisk(Object key) {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().containsKeyOnDisk(key);
    }

    @Override
    public Policy getInMemoryEvictionPolicy() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getInMemoryEvictionPolicy();
    }

    @Override
    public Object getMBean() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getMBean();
    }

    @Override
    public int getOffHeapSize() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getOffHeapSize();
    }

    @Override
    public long getOffHeapSizeInBytes() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getOffHeapSizeInBytes();
    }

    @Override
    public int getOnDiskSize() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getOnDiskSize();
    }

    @Override
    public long getOnDiskSizeInBytes() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getOnDiskSizeInBytes();
    }

    @Override
    public Status getStatus() {
        return this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().getStatus();
    }

    @Override
    public void setInMemoryEvictionPolicy(Policy policy) {
        this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().setInMemoryEvictionPolicy(policy);
    }

    @Override
    public void expireElements() {
        this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().expireElements();
    }

    @Override
    public void addStoreListener(StoreListener listener) {
        this.executorServiceStore.addStoreListener(listener);
    }

    @Override
    public void removeStoreListener(StoreListener listener) {
        this.executorServiceStore.removeStoreListener(listener);
    }

    @Override
    public void setAttributeExtractors(Map<String, AttributeExtractor> extractors) {
        this.executorServiceStore.setAttributeExtractors(extractors);
    }

    @Override
    public boolean isCacheCoherent() {
        return this.executorServiceStore.isCacheCoherent();
    }

    @Override
    public boolean isClusterCoherent() {
        return this.executorServiceStore.isClusterCoherent();
    }

    @Override
    public boolean isNodeCoherent() {
        return this.executorServiceStore.isNodeCoherent();
    }

    @Override
    public void setNodeCoherent(boolean coherent) throws UnsupportedOperationException {
        this.executorServiceStore.setNodeCoherent(coherent);
    }

    @Override
    public void dispose() {
        this.executorServiceStore.dispose();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.executorServiceStore.containsKey(key);
    }

    @Override
    public boolean containsKeyInMemory(Object key) {
        return this.executorServiceStore.containsKeyInMemory(key);
    }

    @Override
    public Results executeQuery(StoreQuery query) {
        return this.executorServiceStore.executeQuery(query);
    }

    @Override
    public <T> Attribute<T> getSearchAttribute(String attributeName) {
        return this.executorServiceStore.getSearchAttribute(attributeName);
    }

    @Override
    public void flush() throws IOException {
        this.executorServiceStore.flush();
    }

    @Override
    public Element get(Object key) {
        return this.executorServiceStore.get(key);
    }

    @Override
    public int getInMemorySize() {
        return this.executorServiceStore.getInMemorySize();
    }

    @Override
    public long getInMemorySizeInBytes() {
        return this.executorServiceStore.getInMemorySizeInBytes();
    }

    @Override
    public List getKeys() {
        return this.executorServiceStore.getKeys();
    }

    @Override
    public Element getQuiet(Object key) {
        return this.executorServiceStore.getQuiet(key);
    }

    @Override
    public int getSize() {
        return this.executorServiceStore.getSize();
    }

    @Override
    public int getTerracottaClusteredSize() {
        return this.executorServiceStore.getTerracottaClusteredSize();
    }

    @Override
    public boolean put(Element element) throws CacheException {
        return this.executorServiceStore.put(element);
    }

    @Override
    public Element putIfAbsent(Element element) throws NullPointerException {
        return this.executorServiceStore.putIfAbsent(element);
    }

    @Override
    public boolean putWithWriter(Element element, CacheWriterManager writerManager) throws CacheException {
        return this.executorServiceStore.putWithWriter(element, writerManager);
    }

    @Override
    public Element remove(Object key) {
        return this.executorServiceStore.remove(key);
    }

    @Override
    public void removeAll() throws CacheException {
        this.executorServiceStore.removeAll();
    }

    @Override
    public Element removeElement(Element element, ElementValueComparator comparator) throws NullPointerException {
        return this.executorServiceStore.removeElement(element, comparator);
    }

    @Override
    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        return this.executorServiceStore.removeWithWriter(key, writerManager);
    }

    @Override
    public boolean replace(Element old, Element element, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        return this.executorServiceStore.replace(old, element, comparator);
    }

    @Override
    public Element replace(Element element) throws NullPointerException {
        return this.executorServiceStore.replace(element);
    }

    @Override
    public Set getLocalKeys() {
        return this.executorServiceStore.getLocalKeys();
    }

    @Override
    public Element unlockedGet(Object key) {
        return this.executorServiceStore.unlockedGet(key);
    }

    @Override
    public Element unlockedGetQuiet(Object key) {
        return this.executorServiceStore.unlockedGetQuiet(key);
    }

    @Override
    public Element unsafeGet(Object key) {
        return this.executorServiceStore.unsafeGet(key);
    }

    @Override
    public Element unsafeGetQuiet(Object key) {
        return this.executorServiceStore.unsafeGetQuiet(key);
    }

    private Sync[] wrapWithNonstopSync(Sync[] syncs) {
        if (syncs == null) {
            return null;
        }
        for (int i = 0; i < syncs.length; ++i) {
            Sync sync = syncs[i];
            syncs[i] = sync == null ? null : new NonstopSync(this, sync);
        }
        return syncs;
    }

    @Override
    public Sync[] getAndWriteLockAllSyncForKeys(long timeout, Object ... keys) throws TimeoutException {
        return this.wrapWithNonstopSync(this.executorServiceStore.getAndWriteLockAllSyncForKeys(timeout, keys));
    }

    @Override
    public Sync[] getAndWriteLockAllSyncForKeys(Object ... keys) {
        return this.wrapWithNonstopSync(this.executorServiceStore.getAndWriteLockAllSyncForKeys(keys));
    }

    @Override
    public Sync getSyncForKey(Object key) {
        Sync sync = this.executorServiceStore.getSyncForKey(key);
        return sync == null ? null : new NonstopSync(this, sync);
    }

    @Override
    public void unlockWriteLockForAllKeys(Object ... keys) {
        this.executorServiceStore.unlockWriteLockForAllKeys(keys);
    }

    @Override
    public <V> V executeClusterOperation(ClusterOperation<V> operation) {
        return this.executorServiceStore.executeClusterOperation(operation);
    }
}

