/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentBinaryContentRevision;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedBinaryFile
implements JDOMExternalizable {
    public String BEFORE_PATH;
    public String AFTER_PATH;
    @Nullable
    public String SHELVED_PATH;

    public ShelvedBinaryFile() {
    }

    public ShelvedBinaryFile(String beforePath, String afterPath, @Nullable String shelvedPath) {
        assert (beforePath != null || afterPath != null);
        this.BEFORE_PATH = beforePath;
        this.AFTER_PATH = afterPath;
        this.SHELVED_PATH = shelvedPath;
        this.convertPathsToSystemIndependent();
    }

    @Nullable
    private static String convertToSystemIndependent(@Nullable String beforePath) {
        return beforePath != null ? FileUtil.toSystemIndependentName((String)beforePath) : null;
    }

    private void convertPathsToSystemIndependent() {
        this.BEFORE_PATH = ShelvedBinaryFile.convertToSystemIndependent(this.BEFORE_PATH);
        this.AFTER_PATH = ShelvedBinaryFile.convertToSystemIndependent(this.AFTER_PATH);
        this.SHELVED_PATH = ShelvedBinaryFile.convertToSystemIndependent(this.SHELVED_PATH);
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.convertPathsToSystemIndependent();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public FileStatus getFileStatus() {
        if (this.BEFORE_PATH == null) {
            return FileStatus.ADDED;
        }
        if (this.SHELVED_PATH == null) {
            return FileStatus.DELETED;
        }
        return FileStatus.MODIFIED;
    }

    public Change createChange(Project project) {
        CurrentBinaryContentRevision before = null;
        ShelvedBinaryContentRevision after2 = null;
        File baseDir = new File(project.getBaseDir().getPath());
        if (this.BEFORE_PATH != null) {
            FilePath file2 = VcsUtil.getFilePath((File)new File(baseDir, this.BEFORE_PATH), (boolean)false);
            before = new CurrentBinaryContentRevision(file2){

                @NotNull
                public VcsRevisionNumber getRevisionNumber() {
                    TextRevisionNumber textRevisionNumber = new TextRevisionNumber(VcsBundle.message((String)"local.version.title", (Object[])new Object[0]));
                    if (textRevisionNumber == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return textRevisionNumber;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedBinaryFile$1", "getRevisionNumber"));
                }
            };
        }
        if (this.AFTER_PATH != null) {
            after2 = this.createBinaryContentRevision(project);
        }
        return new Change(before, (ContentRevision)after2);
    }

    @NotNull
    ShelvedBinaryContentRevision createBinaryContentRevision(@NotNull Project project) {
        if (project == null) {
            ShelvedBinaryFile.$$$reportNull$$$0(0);
        }
        FilePath file2 = VcsUtil.getFilePath((File)new File(project.getBasePath(), this.AFTER_PATH), (boolean)false);
        ShelvedBinaryContentRevision shelvedBinaryContentRevision = new ShelvedBinaryContentRevision(file2, this.SHELVED_PATH);
        if (shelvedBinaryContentRevision == null) {
            ShelvedBinaryFile.$$$reportNull$$$0(1);
        }
        return shelvedBinaryContentRevision;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShelvedBinaryFile that = (ShelvedBinaryFile)o;
        if (this.AFTER_PATH != null ? !this.AFTER_PATH.equals(that.AFTER_PATH) : that.AFTER_PATH != null) {
            return false;
        }
        if (this.BEFORE_PATH != null ? !this.BEFORE_PATH.equals(that.BEFORE_PATH) : that.BEFORE_PATH != null) {
            return false;
        }
        return !(this.SHELVED_PATH != null ? !this.SHELVED_PATH.equals(that.SHELVED_PATH) : that.SHELVED_PATH != null);
    }

    public int hashCode() {
        int result2 = this.BEFORE_PATH != null ? this.BEFORE_PATH.hashCode() : 0;
        result2 = 31 * result2 + (this.AFTER_PATH != null ? this.AFTER_PATH.hashCode() : 0);
        result2 = 31 * result2 + (this.SHELVED_PATH != null ? this.SHELVED_PATH.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return FileUtil.toSystemDependentName((String)(this.BEFORE_PATH == null ? this.AFTER_PATH : this.BEFORE_PATH));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedBinaryFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedBinaryFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinaryContentRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryContentRevision";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

