/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.collapsing.BranchFilterController;
import com.intellij.vcs.log.graph.collapsing.CollapsedController;
import com.intellij.vcs.log.graph.impl.facade.BaseController;
import com.intellij.vcs.log.graph.impl.facade.BekBaseController;
import com.intellij.vcs.log.graph.impl.facade.FilteredController;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.ReachableNodes;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.graph.impl.facade.bek.BekIntMap;
import com.intellij.vcs.log.graph.impl.facade.bek.BekSorter;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutBuilder;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphBuilder;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphImpl;
import com.intellij.vcs.log.graph.linearBek.LinearBekController;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import gnu.trove.TIntHashSet;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermanentGraphImpl<CommitId>
implements PermanentGraph<CommitId>,
PermanentGraphInfo<CommitId> {
    @NotNull
    private final PermanentCommitsInfoImpl<CommitId> myPermanentCommitsInfo;
    @NotNull
    private final PermanentLinearGraphImpl myPermanentLinearGraph;
    @NotNull
    private final GraphLayoutImpl myPermanentGraphLayout;
    @NotNull
    private final Set<Integer> myBranchNodeIds;
    @NotNull
    private final Supplier<BekIntMap> myBekIntMap;
    @NotNull
    private final GraphColorManager<CommitId> myGraphColorManager;
    @NotNull
    private final ReachableNodes myReachableNodes;

    public PermanentGraphImpl(@NotNull PermanentLinearGraphImpl permanentLinearGraph, @NotNull GraphLayoutImpl permanentGraphLayout, @NotNull PermanentCommitsInfoImpl<CommitId> permanentCommitsInfo, @NotNull GraphColorManager<CommitId> graphColorManager, @NotNull Set<CommitId> branchesCommitId) {
        if (permanentLinearGraph == null) {
            PermanentGraphImpl.$$$reportNull$$$0(0);
        }
        if (permanentGraphLayout == null) {
            PermanentGraphImpl.$$$reportNull$$$0(1);
        }
        if (permanentCommitsInfo == null) {
            PermanentGraphImpl.$$$reportNull$$$0(2);
        }
        if (graphColorManager == null) {
            PermanentGraphImpl.$$$reportNull$$$0(3);
        }
        if (branchesCommitId == null) {
            PermanentGraphImpl.$$$reportNull$$$0(4);
        }
        this.myPermanentGraphLayout = permanentGraphLayout;
        this.myPermanentCommitsInfo = permanentCommitsInfo;
        this.myPermanentLinearGraph = permanentLinearGraph;
        this.myGraphColorManager = graphColorManager;
        this.myBranchNodeIds = permanentCommitsInfo.convertToNodeIds(branchesCommitId);
        this.myReachableNodes = new ReachableNodes(LinearGraphUtils.asLiteLinearGraph(permanentLinearGraph));
        this.myBekIntMap = Suppliers.memoize(() -> BekSorter.createBekMap(this.myPermanentLinearGraph, this.myPermanentGraphLayout, this.myPermanentCommitsInfo.getTimestampGetter()));
    }

    @NotNull
    public static <CommitId> PermanentGraphImpl<CommitId> newInstance(@NotNull List<? extends GraphCommit<CommitId>> graphCommits, @NotNull GraphColorManager<CommitId> graphColorManager, @NotNull Set<CommitId> branchesCommitId) {
        if (graphCommits == null) {
            PermanentGraphImpl.$$$reportNull$$$0(5);
        }
        if (graphColorManager == null) {
            PermanentGraphImpl.$$$reportNull$$$0(6);
        }
        if (branchesCommitId == null) {
            PermanentGraphImpl.$$$reportNull$$$0(7);
        }
        PermanentLinearGraphBuilder permanentLinearGraphBuilder = PermanentLinearGraphBuilder.newInstance(graphCommits);
        NotLoadedCommitsIdsGenerator idsGenerator = new NotLoadedCommitsIdsGenerator();
        PermanentLinearGraphImpl linearGraph = permanentLinearGraphBuilder.build(idsGenerator);
        PermanentCommitsInfoImpl commitIdPermanentCommitsInfo = PermanentCommitsInfoImpl.newInstance(graphCommits, idsGenerator.getNotLoadedCommits());
        GraphLayoutImpl permanentGraphLayout = GraphLayoutBuilder.build(linearGraph, (nodeIndex1, nodeIndex2) -> {
            if (graphColorManager == null) {
                PermanentGraphImpl.$$$reportNull$$$0(36);
            }
            Object commitId1 = commitIdPermanentCommitsInfo.getCommitId((int)nodeIndex1);
            Object commitId2 = commitIdPermanentCommitsInfo.getCommitId((int)nodeIndex2);
            return graphColorManager.compareHeads(commitId1, commitId2);
        });
        PermanentGraphImpl permanentGraphImpl = new PermanentGraphImpl(linearGraph, permanentGraphLayout, commitIdPermanentCommitsInfo, graphColorManager, branchesCommitId);
        if (permanentGraphImpl == null) {
            PermanentGraphImpl.$$$reportNull$$$0(8);
        }
        return permanentGraphImpl;
    }

    @NotNull
    private LinearGraphController createBaseController(@NotNull PermanentGraph.SortType sortType) {
        if (sortType == null) {
            PermanentGraphImpl.$$$reportNull$$$0(9);
        }
        if (sortType == PermanentGraph.SortType.Normal) {
            BaseController baseController = new BaseController(this);
            if (baseController == null) {
                PermanentGraphImpl.$$$reportNull$$$0(10);
            }
            return baseController;
        }
        if (sortType == PermanentGraph.SortType.LinearBek) {
            LinearBekController linearBekController = new LinearBekController(new BekBaseController(this, (BekIntMap)this.myBekIntMap.get()), (PermanentGraphInfo)this);
            if (linearBekController == null) {
                PermanentGraphImpl.$$$reportNull$$$0(11);
            }
            return linearBekController;
        }
        BekBaseController bekBaseController = new BekBaseController(this, (BekIntMap)this.myBekIntMap.get());
        if (bekBaseController == null) {
            PermanentGraphImpl.$$$reportNull$$$0(12);
        }
        return bekBaseController;
    }

    @NotNull
    private LinearGraphController createFilteredController(@NotNull LinearGraphController baseController, @NotNull PermanentGraph.SortType sortType, @Nullable Set<CommitId> visibleHeads, @Nullable Set<CommitId> matchingCommits) {
        Set<Integer> visibleHeadsIds;
        if (baseController == null) {
            PermanentGraphImpl.$$$reportNull$$$0(13);
        }
        if (sortType == null) {
            PermanentGraphImpl.$$$reportNull$$$0(14);
        }
        Set<Integer> set = visibleHeadsIds = visibleHeads != null ? this.myPermanentCommitsInfo.convertToNodeIds(visibleHeads, true) : null;
        if (matchingCommits != null) {
            FilteredController filteredController = new FilteredController(baseController, this, this.myPermanentCommitsInfo.convertToNodeIds(matchingCommits), visibleHeadsIds);
            if (filteredController == null) {
                PermanentGraphImpl.$$$reportNull$$$0(15);
            }
            return filteredController;
        }
        if (sortType == PermanentGraph.SortType.LinearBek) {
            if (visibleHeadsIds != null) {
                BranchFilterController branchFilterController = new BranchFilterController(baseController, this, visibleHeadsIds);
                if (branchFilterController == null) {
                    PermanentGraphImpl.$$$reportNull$$$0(16);
                }
                return branchFilterController;
            }
            LinearGraphController linearGraphController = baseController;
            if (linearGraphController == null) {
                PermanentGraphImpl.$$$reportNull$$$0(17);
            }
            return linearGraphController;
        }
        CollapsedController collapsedController = new CollapsedController(baseController, this, visibleHeadsIds);
        if (collapsedController == null) {
            PermanentGraphImpl.$$$reportNull$$$0(18);
        }
        return collapsedController;
    }

    @NotNull
    public VisibleGraph<CommitId> createVisibleGraph(@NotNull PermanentGraph.SortType sortType, @Nullable Set<CommitId> visibleHeads, @Nullable Set<CommitId> matchingCommits, @NotNull BiConsumer<LinearGraphController, PermanentGraphInfo<CommitId>> preprocessor) {
        if (sortType == null) {
            PermanentGraphImpl.$$$reportNull$$$0(19);
        }
        if (preprocessor == null) {
            PermanentGraphImpl.$$$reportNull$$$0(20);
        }
        LinearGraphController controller = this.createFilteredController(this.createBaseController(sortType), sortType, visibleHeads, matchingCommits);
        preprocessor.accept(controller, this);
        VisibleGraphImpl<CommitId> visibleGraphImpl = new VisibleGraphImpl<CommitId>(controller, this, this.myGraphColorManager);
        if (visibleGraphImpl == null) {
            PermanentGraphImpl.$$$reportNull$$$0(21);
        }
        return visibleGraphImpl;
    }

    @NotNull
    public VisibleGraph<CommitId> createVisibleGraph(@NotNull PermanentGraph.SortType sortType, @Nullable Set<CommitId> visibleHeads, @Nullable Set<CommitId> matchingCommits) {
        if (sortType == null) {
            PermanentGraphImpl.$$$reportNull$$$0(22);
        }
        VisibleGraph<CommitId> visibleGraph = this.createVisibleGraph(sortType, visibleHeads, matchingCommits, (controller, info) -> {});
        if (visibleGraph == null) {
            PermanentGraphImpl.$$$reportNull$$$0(23);
        }
        return visibleGraph;
    }

    @NotNull
    public List<GraphCommit<CommitId>> getAllCommits() {
        AbstractList abstractList = new AbstractList<GraphCommit<CommitId>>(){

            @Override
            public GraphCommit<CommitId> get(int index) {
                Object commitId = PermanentGraphImpl.this.myPermanentCommitsInfo.getCommitId(index);
                List<Integer> downNodes = LinearGraphUtils.getDownNodesIncludeNotLoad(PermanentGraphImpl.this.myPermanentLinearGraph, index);
                List parentsCommitIds = PermanentGraphImpl.this.myPermanentCommitsInfo.convertToCommitIdList(downNodes);
                return GraphCommitImpl.createCommit(commitId, parentsCommitIds, PermanentGraphImpl.this.myPermanentCommitsInfo.getTimestamp(index));
            }

            @Override
            public int size() {
                return PermanentGraphImpl.this.myPermanentLinearGraph.nodesCount();
            }
        };
        if (abstractList == null) {
            PermanentGraphImpl.$$$reportNull$$$0(24);
        }
        return abstractList;
    }

    @NotNull
    public List<CommitId> getChildren(@NotNull CommitId commit) {
        if (commit == null) {
            PermanentGraphImpl.$$$reportNull$$$0(25);
        }
        int commitIndex = this.myPermanentCommitsInfo.getNodeId(commit);
        List<CommitId> list2 = this.myPermanentCommitsInfo.convertToCommitIdList(LinearGraphUtils.getUpNodes(this.myPermanentLinearGraph, commitIndex));
        if (list2 == null) {
            PermanentGraphImpl.$$$reportNull$$$0(26);
        }
        return list2;
    }

    @NotNull
    public Set<CommitId> getContainingBranches(@NotNull CommitId commit) {
        if (commit == null) {
            PermanentGraphImpl.$$$reportNull$$$0(27);
        }
        int commitIndex = this.myPermanentCommitsInfo.getNodeId(commit);
        Set<CommitId> set = this.myPermanentCommitsInfo.convertToCommitIdSet(this.myReachableNodes.getContainingBranches(commitIndex, this.myBranchNodeIds));
        if (set == null) {
            PermanentGraphImpl.$$$reportNull$$$0(28);
        }
        return set;
    }

    @NotNull
    public Condition<CommitId> getContainedInBranchCondition(@NotNull Collection<CommitId> heads) {
        if (heads == null) {
            PermanentGraphImpl.$$$reportNull$$$0(29);
        }
        List headIds = ContainerUtil.map(heads, head -> this.myPermanentCommitsInfo.getNodeId(head));
        if (!heads.isEmpty() && ContainerUtil.getFirstItem(heads) instanceof Integer) {
            TIntHashSet branchNodes = new TIntHashSet();
            this.myReachableNodes.walkDown(headIds, (Consumer<Integer>)((Consumer)node -> branchNodes.add(((Integer)this.myPermanentCommitsInfo.getCommitId((int)node)).intValue())));
            IntContainedInBranchCondition intContainedInBranchCondition = new IntContainedInBranchCondition(branchNodes);
            if (intContainedInBranchCondition == null) {
                PermanentGraphImpl.$$$reportNull$$$0(30);
            }
            return intContainedInBranchCondition;
        }
        HashSet branchNodes = ContainerUtil.newHashSet();
        this.myReachableNodes.walkDown(headIds, (Consumer<Integer>)((Consumer)node -> branchNodes.add(this.myPermanentCommitsInfo.getCommitId((int)node))));
        ContainedInBranchCondition containedInBranchCondition = new ContainedInBranchCondition(branchNodes);
        if (containedInBranchCondition == null) {
            PermanentGraphImpl.$$$reportNull$$$0(31);
        }
        return containedInBranchCondition;
    }

    @Override
    @NotNull
    public PermanentCommitsInfoImpl<CommitId> getPermanentCommitsInfo() {
        PermanentCommitsInfoImpl<CommitId> permanentCommitsInfoImpl = this.myPermanentCommitsInfo;
        if (permanentCommitsInfoImpl == null) {
            PermanentGraphImpl.$$$reportNull$$$0(32);
        }
        return permanentCommitsInfoImpl;
    }

    @Override
    @NotNull
    public PermanentLinearGraphImpl getLinearGraph() {
        PermanentLinearGraphImpl permanentLinearGraphImpl = this.myPermanentLinearGraph;
        if (permanentLinearGraphImpl == null) {
            PermanentGraphImpl.$$$reportNull$$$0(33);
        }
        return permanentLinearGraphImpl;
    }

    @Override
    @NotNull
    public GraphLayoutImpl getPermanentGraphLayout() {
        GraphLayoutImpl graphLayoutImpl = this.myPermanentGraphLayout;
        if (graphLayoutImpl == null) {
            PermanentGraphImpl.$$$reportNull$$$0(34);
        }
        return graphLayoutImpl;
    }

    @Override
    @NotNull
    public Set<Integer> getBranchNodeIds() {
        Set<Integer> set = this.myBranchNodeIds;
        if (set == null) {
            PermanentGraphImpl.$$$reportNull$$$0(35);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentLinearGraph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentGraphLayout";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentCommitsInfo";
                break;
            }
            case 3: 
            case 6: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphColorManager";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchesCommitId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphCommits";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl";
                break;
            }
            case 9: 
            case 14: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseController";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preprocessor";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heads";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createBaseController";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilteredController";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisibleGraph";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCommits";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingBranches";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainedInBranchCondition";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermanentCommitsInfo";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinearGraph";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermanentGraphLayout";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchNodeIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createBaseController";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createFilteredController";
                break;
            }
            case 19: 
            case 20: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createVisibleGraph";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getContainingBranches";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getContainedInBranchCondition";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$newInstance$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ContainedInBranchCondition<CommitId>
    implements Condition<CommitId> {
        private final Set<CommitId> myBranchNodes;

        ContainedInBranchCondition(Set<CommitId> branchNodes) {
            this.myBranchNodes = branchNodes;
        }

        public boolean value(CommitId commitId) {
            return this.myBranchNodes.contains(commitId);
        }
    }

    private static class IntContainedInBranchCondition<CommitId>
    implements Condition<CommitId> {
        private final TIntHashSet myBranchNodes;

        IntContainedInBranchCondition(TIntHashSet branchNodes) {
            this.myBranchNodes = branchNodes;
        }

        public boolean value(CommitId commitId) {
            return this.myBranchNodes.contains(((Integer)commitId).intValue());
        }
    }

    private static class NotLoadedCommitsIdsGenerator<CommitId>
    implements NotNullFunction<CommitId, Integer> {
        @NotNull
        private final Map<Integer, CommitId> myNotLoadedCommits = ContainerUtil.newHashMap();

        private NotLoadedCommitsIdsGenerator() {
        }

        @NotNull
        public Integer fun(CommitId dom) {
            int nodeId = -(this.myNotLoadedCommits.size() + 2);
            this.myNotLoadedCommits.put(nodeId, dom);
            Integer n = nodeId;
            if (n == null) {
                NotLoadedCommitsIdsGenerator.$$$reportNull$$$0(0);
            }
            return n;
        }

        @NotNull
        public Map<Integer, CommitId> getNotLoadedCommits() {
            Map<Integer, CommitId> map = this.myNotLoadedCommits;
            if (map == null) {
                NotLoadedCommitsIdsGenerator.$$$reportNull$$$0(1);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl$NotLoadedCommitsIdsGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fun";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotLoadedCommits";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

