/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.lang.IdeLanguageCustomization;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleGroup;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeStyleSettingsProvider {
    public static final ExtensionPointName<CodeStyleSettingsProvider> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.codeStyleSettingsProvider");

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings) {
        return null;
    }

    @Deprecated
    @NotNull
    public Configurable createSettingsPage(CodeStyleSettings settings, CodeStyleSettings modelSettings) {
        if (null == null) {
            CodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettings modelSettings) {
        Configurable configurable;
        if (settings == null) {
            CodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        if (modelSettings == null) {
            CodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if ((configurable = this.createSettingsPage(settings, modelSettings)) instanceof CodeStyleConfigurable) {
            CodeStyleConfigurable codeStyleConfigurable = (CodeStyleConfigurable)configurable;
            if (codeStyleConfigurable == null) {
                CodeStyleSettingsProvider.$$$reportNull$$$0(3);
            }
            return codeStyleConfigurable;
        }
        LegacyConfigurableWrapper legacyConfigurableWrapper = new LegacyConfigurableWrapper(configurable);
        if (legacyConfigurableWrapper == null) {
            CodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        return legacyConfigurableWrapper;
    }

    @Nullable
    public String getConfigurableDisplayName() {
        Language lang = this.getLanguage();
        return lang == null ? null : lang.getDisplayName();
    }

    public boolean hasSettingsPage() {
        return true;
    }

    public DisplayPriority getPriority() {
        List<Language> primaryIdeLanguages = IdeLanguageCustomization.getInstance().getPrimaryIdeLanguages();
        return primaryIdeLanguages.contains((Object)this.getLanguage()) ? DisplayPriority.KEY_LANGUAGE_SETTINGS : DisplayPriority.LANGUAGE_SETTINGS;
    }

    @Nullable
    public Language getLanguage() {
        return null;
    }

    @Nullable
    public CodeStyleGroup getGroup() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/CodeStyleSettingsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsPage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettingsProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LegacyConfigurableWrapper
    implements CodeStyleConfigurable {
        private final Configurable myConfigurable;

        private LegacyConfigurableWrapper(Configurable configurable) {
            this.myConfigurable = configurable;
        }

        @Override
        public void reset(@NotNull CodeStyleSettings settings) {
            if (settings == null) {
                LegacyConfigurableWrapper.$$$reportNull$$$0(0);
            }
            this.myConfigurable.reset();
        }

        @Override
        public void apply(@NotNull CodeStyleSettings settings) throws ConfigurationException {
            if (settings == null) {
                LegacyConfigurableWrapper.$$$reportNull$$$0(1);
            }
            this.myConfigurable.apply();
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Title)
        public String getDisplayName() {
            return this.myConfigurable.getDisplayName();
        }

        @Override
        @Nullable
        public JComponent createComponent() {
            return this.myConfigurable.createComponent();
        }

        @Override
        public boolean isModified() {
            return this.myConfigurable.isModified();
        }

        @Override
        public void apply() throws ConfigurationException {
            this.myConfigurable.apply();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "settings";
            objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettingsProvider$LegacyConfigurableWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reset";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

