/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.ui.ChangesBrowserWithRollback;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class LocalChangesWouldBeOverwrittenHelper {
    @NotNull
    private static String getErrorNotificationDescription() {
        String string = LocalChangesWouldBeOverwrittenHelper.getErrorDescription(true);
        if (string == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static String getErrorDialogDescription() {
        String string = LocalChangesWouldBeOverwrittenHelper.getErrorDescription(false);
        if (string == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static String getErrorDescription(boolean forNotification) {
        String line1 = "Your local changes would be overwritten by merge.";
        String line2 = "Commit, stash or revert them to proceed.";
        if (forNotification) {
            String string = line1 + "<br/>" + line2 + " <a href='view'>View them</a>";
            if (string == null) {
                LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = line1 + "\n" + line2;
        if (string == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static void showErrorNotification(final @NotNull Project project, @NotNull VirtualFile root, final @NotNull String operationName, @NotNull Collection<String> relativeFilePaths) {
        if (project == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(4);
        }
        if (root == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(5);
        }
        if (operationName == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(6);
        }
        if (relativeFilePaths == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(7);
        }
        final Collection<String> absolutePaths = GitUtil.toAbsolute(root, relativeFilePaths);
        final List<Change> changes = GitUtil.findLocalChangesForPaths(project, root, absolutePaths, false);
        String notificationTitle = "Git " + StringUtil.capitalize((String)operationName) + " Failed";
        VcsNotifier.getInstance((Project)project).notifyError(notificationTitle, LocalChangesWouldBeOverwrittenHelper.getErrorNotificationDescription(), (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                LocalChangesWouldBeOverwrittenHelper.showErrorDialog(project, operationName, changes, (Collection<String>)absolutePaths);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "git4idea/util/LocalChangesWouldBeOverwrittenHelper$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Deprecated
    public static void showErrorDialog(@NotNull Project project, @NotNull VirtualFile root, @NotNull String operationName, @NotNull Collection<String> relativeFilePaths) {
        if (project == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(8);
        }
        if (root == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(9);
        }
        if (operationName == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(10);
        }
        if (relativeFilePaths == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(11);
        }
        Collection<String> absolutePaths = GitUtil.toAbsolute(root, relativeFilePaths);
        List<Change> changes = GitUtil.findLocalChangesForPaths(project, root, absolutePaths, false);
        LocalChangesWouldBeOverwrittenHelper.showErrorDialog(project, operationName, changes, absolutePaths);
    }

    private static void showErrorDialog(@NotNull Project project, @NotNull String operationName, @NotNull List<Change> changes, @NotNull Collection<String> absolutePaths) {
        if (project == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(12);
        }
        if (operationName == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(13);
        }
        if (changes == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(14);
        }
        if (absolutePaths == null) {
            LocalChangesWouldBeOverwrittenHelper.$$$reportNull$$$0(15);
        }
        String title = "Local Changes Prevent from " + StringUtil.capitalize((String)operationName);
        String description = LocalChangesWouldBeOverwrittenHelper.getErrorDialogDescription();
        if (changes.isEmpty()) {
            GitUtil.showPathsInDialog(project, absolutePaths, title, description);
        } else {
            ChangesBrowserWithRollback changesViewer = new ChangesBrowserWithRollback(project, changes);
            DialogBuilder builder = new DialogBuilder(project);
            builder.setNorthPanel((JComponent)new MultiLineLabel(description));
            builder.setCenterPanel((JComponent)((Object)changesViewer));
            builder.addDisposable((Disposable)changesViewer);
            builder.addOkAction();
            builder.setTitle(title);
            builder.show();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/util/LocalChangesWouldBeOverwrittenHelper";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationName";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeFilePaths";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorNotificationDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorDialogDescription";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorDescription";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/util/LocalChangesWouldBeOverwrittenHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showErrorNotification";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showErrorDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

