/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.Function;
import com.jetbrains.python.console.pydev.AbstractConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.InterpreterResponse;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PythonDebugConsoleCommunication
extends AbstractConsoleCommunication {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.console.pydev.PythonDebugConsoleCommunication");
    private final PyDebugProcess myDebugProcess;
    private boolean myNeedsMore = false;

    public PythonDebugConsoleCommunication(Project project, PyDebugProcess debugProcess) {
        super(project);
        this.myDebugProcess = debugProcess;
    }

    @NotNull
    public List<PydevCompletionVariant> getCompletions(String text2, String actualToken) throws Exception {
        List<PydevCompletionVariant> list = this.myDebugProcess.getCompletions(actualToken);
        if (list == null) {
            PythonDebugConsoleCommunication.$$$reportNull$$$0(0);
        }
        return list;
    }

    public String getDescription(String refExpression) throws Exception {
        return this.myDebugProcess.getDescription(refExpression);
    }

    public boolean isWaitingForInput() {
        return this.waitingForInput;
    }

    public boolean needsMore() {
        return this.myNeedsMore;
    }

    public boolean isExecuting() {
        return false;
    }

    protected void exec(ConsoleCommunication.ConsoleCodeFragment command, final PyDebugCallback<Pair<String, Boolean>> callback) {
        this.myDebugProcess.consoleExec(command.getText(), new PyDebugCallback<String>(){

            public void ok(String value) {
                callback.ok((Object)AbstractConsoleCommunication.parseExecResponseString((String)value));
            }

            public void error(PyDebuggerException exception) {
                callback.error(exception);
            }
        });
    }

    public void execInterpreter(ConsoleCommunication.ConsoleCodeFragment code, final Function<InterpreterResponse, Object> callback) {
        if (this.waitingForInput) {
            OutputStream processInput = this.myDebugProcess.getProcessHandler().getProcessInput();
            if (processInput != null) {
                try {
                    Charset defaultCharset = EncodingProjectManager.getInstance((Project)this.myDebugProcess.getProject()).getDefaultCharset();
                    processInput.write(code.getText().getBytes(defaultCharset));
                    processInput.flush();
                }
                catch (IOException e) {
                    LOG.error(e.getMessage());
                }
            }
            this.myNeedsMore = false;
            this.waitingForInput = false;
            this.notifyCommandExecuted(this.waitingForInput);
        } else {
            this.exec(new ConsoleCommunication.ConsoleCodeFragment(code.getText(), false), new PyDebugCallback<Pair<String, Boolean>>(){

                public void ok(Pair<String, Boolean> executed) {
                    boolean more = (Boolean)executed.second;
                    PythonDebugConsoleCommunication.this.myNeedsMore = more;
                    PythonDebugConsoleCommunication.this.notifyCommandExecuted(more);
                    callback.fun((Object)new InterpreterResponse(more, PythonDebugConsoleCommunication.this.isWaitingForInput()));
                }

                public void error(PyDebuggerException exception) {
                    PythonDebugConsoleCommunication.this.myNeedsMore = false;
                    PythonDebugConsoleCommunication.this.notifyCommandExecuted(false);
                    callback.fun((Object)new InterpreterResponse(false, PythonDebugConsoleCommunication.this.isWaitingForInput()));
                }
            });
        }
    }

    public void notifyInputRequested() {
        this.waitingForInput = true;
        super.notifyInputRequested();
    }

    public void interrupt() {
        throw new UnsupportedOperationException();
    }

    public boolean isSuspended() {
        return this.myDebugProcess.getSession().isSuspended();
    }

    public void resume() {
        this.myDebugProcess.getSession().resume();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/PythonDebugConsoleCommunication", "getCompletions"));
    }
}

