/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyFStringFragment;
import com.jetbrains.python.psi.PyFStringFragmentFormatPart;
import com.jetbrains.python.psi.PyFormattedStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.validation.PyAnnotator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FStringsAnnotator
extends PyAnnotator {
    @Override
    public void visitPyFStringFragment(PyFStringFragment node) {
        boolean topLevel;
        PsiElement typeConversion;
        List enclosingFragments = PsiTreeUtil.collectParents((PsiElement)node, PyFStringFragment.class, (boolean)false, PyStringLiteralExpression.class::isInstance);
        if (enclosingFragments.size() > 1) {
            this.report((PsiElement)node, "Expression fragment inside f-string is nested too deeply");
        }
        if ((typeConversion = node.getTypeConversion()) != null) {
            String conversionChar = typeConversion.getText().substring(1);
            if (conversionChar.isEmpty()) {
                this.report(typeConversion, "Conversion character is expected: should be one of 's', 'r', 'a'");
            } else if (conversionChar.length() > 1 || "sra".indexOf(conversionChar.charAt(0)) < 0) {
                this.report(typeConversion, "Illegal conversion character '" + conversionChar + "': should be one of 's', 'r', 'a'");
            }
        }
        boolean bl = topLevel = PsiTreeUtil.getParentOfType((PsiElement)node, PyFStringFragment.class, (boolean)true) == null;
        if (topLevel) {
            ArrayList fragments = Lists.newArrayList((Object[])new PyFStringFragment[]{node});
            PyFStringFragmentFormatPart formatPart = node.getFormatPart();
            if (formatPart != null) {
                fragments.addAll(formatPart.getFragments());
            }
            for (PyFStringFragment fragment : fragments) {
                String wholeNodeText = fragment.getText();
                TextRange range = fragment.getExpressionContentRange();
                for (int i = range.getStartOffset(); i < range.getEndOffset(); ++i) {
                    if (wholeNodeText.charAt(i) != '\\') continue;
                    this.reportCharacter((PsiElement)fragment, i, "Expression fragments inside f-strings cannot include backslashes");
                }
            }
        }
    }

    @Override
    public void visitPyFormattedStringElement(PyFormattedStringElement node) {
        String wholeNodeText = node.getText();
        for (TextRange textRange : node.getLiteralPartRanges()) {
            int i = textRange.getStartOffset();
            while (i < textRange.getEndOffset()) {
                int nextOffset = FStringsAnnotator.skipNamedUnicodeEscape(wholeNodeText, i, textRange.getEndOffset());
                if (i != nextOffset) {
                    i = nextOffset;
                    continue;
                }
                char c = wholeNodeText.charAt(i);
                if (c == '}') {
                    if (i + 1 < textRange.getEndOffset() && wholeNodeText.charAt(i + 1) == '}') {
                        i += 2;
                        continue;
                    }
                    this.reportCharacter(node, i, "Single '}' is not allowed inside f-strings");
                }
                ++i;
            }
        }
    }

    private static int skipNamedUnicodeEscape(@NotNull String nodeText, int offset, int endOffset) {
        if (nodeText == null) {
            FStringsAnnotator.$$$reportNull$$$0(0);
        }
        if (StringUtil.startsWith((CharSequence)nodeText, (int)offset, (CharSequence)"\\N{")) {
            int rightBraceOffset = nodeText.indexOf(125, offset + 3);
            return rightBraceOffset < 0 ? endOffset : rightBraceOffset + 1;
        }
        return offset;
    }

    public void visitComment(PsiComment comment) {
        boolean insideFragment;
        boolean bl = insideFragment = PsiTreeUtil.getParentOfType((PsiElement)comment, PyFStringFragment.class) != null;
        if (insideFragment) {
            this.report((PsiElement)comment, "Expression fragments inside f-strings cannot include line comments");
        }
    }

    public void reportCharacter(PsiElement element, int offset, String message) {
        int nodeStartOffset = element.getTextRange().getStartOffset();
        this.getHolder().createErrorAnnotation(TextRange.from((int)offset, (int)1).shiftRight(nodeStartOffset), message);
    }

    public void report(PsiElement element, String error) {
        this.getHolder().createErrorAnnotation(element, error);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeText", "com/jetbrains/python/validation/FStringsAnnotator", "skipNamedUnicodeEscape"));
    }
}

