# an example plugin for pympd that starts mpd when loaded.

import gtk
import os
__name = 'Autostart MPD'
__version = '0.01'
__author = "Natan 'whatah' Zohar"
__blurb = 'Automatically starts mpd when this plugin is loaded. It would be useful if you want mpd to start when pympd starts.'
__class='Autompd'


USECONF='USECONF'
CONFIG_FILE=os.path.expanduser("~/.pympd/autompd.conf")
class Autompd:

    # called when we load the plugin. we get passed the xml, plugin menu
    # item as well as a connection to mpd.
    def _init(self, data, get):
        self.xml, self.pluginMenu, self.pympd, self.base_dir, self.parser = data
        self.data = data
        self.initVars()
        self.readConfig()
        self.initWidgets()
        self.connect_handlers()

    def _conf(self, hasConf=False):
        if hasConf:
            return True
        self.confentry.set_text(self.conf)
        self.musicentry.set_text(self.musicdir)
        self.playentry.set_text(self.playdir)
        self.logentry.set_text(self.log)
        self.errorentry.set_text(self.error)
        self.portentry.set_text(self.port)
        self.confDialog.present()
        return True

    # update plugin, data is of type mpdclient.Status
    def _spin(self, data, songChanged=False):
        return
        
    # called on plugin unloaded
    def _unload(self):
        self.confDialog.destroy()
        self.saveConfig()
        return

    def startMpd(self):
        command = "mpd"
        if self.conf == 'EDIT ME':
            print "autompd configuration required."
            return
        if self.useconf: 
            args = [command, self.port, self.musicdir, self.playdir, self.log, self.error]
        else:
            args = [command, self.conf]
        ret = os.spawnvpe(os.P_WAIT, command, args, os.environ)

    def readConfig(self):
        if os.path.exists(CONFIG_FILE):
            conflines = open(CONFIG_FILE).readlines()
            self.musicdir = conflines[1].strip()
            self.playdir = conflines[2].strip()
            self.log    = conflines[3].strip()
            self.error = conflines[4].strip()
            self.port = conflines[5].strip()
            self.conf= conflines[6].strip()
            if conflines[7].strip() == USECONF:
                self.useconf = True
            else:
                self.useconf = False
            # Start MPD if we have a config.
            self.startMpd()
        else: 
            print "No Config Found, Creating Default Config."
            self.saveConfig()
        return

    def saveConfig(self):
        outfile = open(CONFIG_FILE, 'w')
        if self.useconf:
            useconf = USECONF
        else:
            useconf = 'false'
        tuple = (self.musicdir, self.playdir, self.log, self.error, self.port, self.conf, useconf) 
        outlines = "####DO NOT EDIT BY HAND###\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n"%tuple
        outfile.write(outlines)
        
    def initVars(self):
        self.musicdir = "EDIT ME"
        self.playdir = "EDIT ME"
        self.log    = "EDIT ME"
        self.error = "EDIT ME"
        self.port = "EDIT ME"
        self.conf= "EDIT ME"
        self.useconf = False

    def initWidgets(self):
        self.xml = gtk.glade.XML("%s/glade/autompd.glade" % self.base_dir)
        self.logentry = self.xml.get_widget("logentry")
        self.musicentry = self.xml.get_widget("musicentry")
        self.playentry = self.xml.get_widget("playlistentry")
        self.portentry = self.xml.get_widget("portentry")
        self.errorentry = self.xml.get_widget("errorentry")
        self.confentry = self.xml.get_widget("confentry")
        self.confButton = self.xml.get_widget("radiobutton1")
        self.cliButton = self.xml.get_widget("radiobutton2")
        self.confDialog = self.xml.get_widget("confDialog")

        if self.useconf:
            self.confButton.set_active(True)
        else:
            self.cliButton.set_active(True)

    def connect_handlers(self):
        dic = { 'on_cancel_clicked'     : self.cancel_clicked, 
                'on_ok_clicked'         : self.ok_clicked,
                'on_dialog_closed'      : self.cancel_clicked }
        self.xml.signal_autoconnect(dic)

    def cancel_clicked(self, obj):
        self.confDialog.hide()

    def ok_clicked(self, obj):
        if self.confButton.get_active():
            self.useconf   = True
        else:
            self.useconf = False

        self.musicdir = self.musicentry.get_text()
        self.playdir = self.playentry.get_text()
        self.log    = self.logentry.get_text()
        self.error = self.errorentry.get_text()
        self.port = self.portentry.get_text()
        self.conf= self.confentry.get_text()
        self.confDialog.hide()
        self.saveConfig()
        
