/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.util;

import com.cloudhopper.smpp.tlv.Tlv;
import com.cloudhopper.smpp.tlv.TlvConvertException;
import java.io.UnsupportedEncodingException;

public class TlvUtil {
    public static Tlv createNullTerminatedStringTlv(short tag, String value) throws TlvConvertException {
        return TlvUtil.createNullTerminatedStringTlv(tag, value, "ISO-8859-1");
    }

    public static Tlv createNullTerminatedStringTlv(short tag, String value, String charsetName) throws TlvConvertException {
        try {
            if (value == null) {
                value = "";
            }
            byte[] bytes = value.getBytes(charsetName);
            byte[] bytes0 = new byte[bytes.length + 1];
            System.arraycopy(bytes, 0, bytes0, 0, bytes.length);
            return new Tlv(tag, bytes0);
        }
        catch (UnsupportedEncodingException e) {
            throw new TlvConvertException("String", "unsupported charset " + e.getMessage());
        }
    }

    public static Tlv createFixedLengthStringTlv(short tag, String value, int fixedLength) throws TlvConvertException {
        return TlvUtil.createFixedLengthStringTlv(tag, value, fixedLength, "ISO-8859-1");
    }

    public static Tlv createFixedLengthStringTlv(short tag, String value, int fixedLength, String charsetName) throws TlvConvertException {
        try {
            byte[] bytes;
            if (value == null) {
                value = "";
            }
            if ((bytes = value.getBytes(charsetName)).length > fixedLength) {
                throw new TlvConvertException("String", "length exceeds fixed length [" + fixedLength + "]");
            }
            if (bytes.length < fixedLength) {
                byte[] bytes0 = new byte[fixedLength];
                System.arraycopy(bytes, 0, bytes0, 0, bytes.length);
                bytes = bytes0;
            }
            return new Tlv(tag, bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new TlvConvertException("String", "unsupported charset " + e.getMessage());
        }
    }
}

