/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.pscan.PassiveScanParam;
import org.zaproxy.zap.utils.I18N;

class PassiveScannerOptionsPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private final JCheckBox scanOnlyInScopeCheckBox;

    public PassiveScannerOptionsPanel(I18N messages) {
        this.setName(messages.getString("pscan.options.main.name"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        this.scanOnlyInScopeCheckBox = new JCheckBox();
        JLabel scanOnlyInScopeLabel = new JLabel(messages.getString("pscan.options.main.label.scanOnlyInScope"));
        scanOnlyInScopeLabel.setLabelFor(this.scanOnlyInScopeCheckBox);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(scanOnlyInScopeLabel).addComponent(this.scanOnlyInScopeCheckBox));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(scanOnlyInScopeLabel).addComponent(this.scanOnlyInScopeCheckBox));
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam optionsParam = (OptionsParam)obj;
        PassiveScanParam pscanOptions = optionsParam.getParamSet(PassiveScanParam.class);
        this.scanOnlyInScopeCheckBox.setSelected(pscanOptions.isScanOnlyInScope());
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam optionsParam = (OptionsParam)obj;
        PassiveScanParam pscanOptions = optionsParam.getParamSet(PassiveScanParam.class);
        pscanOptions.setScanOnlyInScope(this.scanOnlyInScopeCheckBox.isSelected());
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.pscan.main";
    }
}

