'''OpenGL extension EXT.convolution

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.convolution to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension defines 1 and 2 dimensional convolution operations
	at a fixed location in the pixel transfer process.  Thus pixel drawing,
	reading, and copying, as well as texture image definition, are all
	candidates for convolution.  The convolution kernels are themselves
	treated as 1 and 2 dimensional images, which can be loaded from
	application memory or from the framebuffer.
	
	This extension is designed to accommodate 3D convolution, but the
	API is left for a future extension.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/convolution.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.EXT.convolution import *
from OpenGL.raw.GL.EXT.convolution import _EXTENSION_NAME

def glInitConvolutionEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glConvolutionFilter1DEXT.image size not checked against 'format,type,width'
glConvolutionFilter1DEXT=wrapper.wrapper(glConvolutionFilter1DEXT).setInputArraySize(
    'image', None
)
# INPUT glConvolutionFilter2DEXT.image size not checked against 'format,type,width,height'
glConvolutionFilter2DEXT=wrapper.wrapper(glConvolutionFilter2DEXT).setInputArraySize(
    'image', None
)
# INPUT glConvolutionParameterfvEXT.params size not checked against 'pname'
glConvolutionParameterfvEXT=wrapper.wrapper(glConvolutionParameterfvEXT).setInputArraySize(
    'params', None
)
# INPUT glConvolutionParameterivEXT.params size not checked against 'pname'
glConvolutionParameterivEXT=wrapper.wrapper(glConvolutionParameterivEXT).setInputArraySize(
    'params', None
)
# OUTPUT glGetConvolutionFilterEXT.image COMPSIZE(target,format,type) 
glGetConvolutionParameterfvEXT=wrapper.wrapper(glGetConvolutionParameterfvEXT).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
glGetConvolutionParameterivEXT=wrapper.wrapper(glGetConvolutionParameterivEXT).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
# OUTPUT glGetSeparableFilterEXT.column COMPSIZE(target,format,type) 
# OUTPUT glGetSeparableFilterEXT.span COMPSIZE(target,format,type) 
# OUTPUT glGetSeparableFilterEXT.row COMPSIZE(target,format,type) 
# INPUT glSeparableFilter2DEXT.column size not checked against 'target,format,type,height'
# INPUT glSeparableFilter2DEXT.row size not checked against 'target,format,type,width'
glSeparableFilter2DEXT=wrapper.wrapper(glSeparableFilter2DEXT).setInputArraySize(
    'column', None
).setInputArraySize(
    'row', None
)
### END AUTOGENERATED SECTION