/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.java.awt.peer.swing.SwingComponent;
import gnu.java.awt.peer.swing.SwingComponentPeer;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.CheckboxPeer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JToggleButton;

public class SwingCheckboxPeer
extends SwingComponentPeer
implements CheckboxPeer {
    public SwingCheckboxPeer(Checkbox checkbox) {
        SwingCheckbox swingCheckbox = new SwingCheckbox(checkbox);
        swingCheckbox.addItemListener(new SwingCheckboxListener(checkbox));
        this.init(checkbox, swingCheckbox);
        this.setLabel(checkbox.getLabel());
        this.setState(checkbox.getState());
    }

    public void setCheckboxGroup(CheckboxGroup group) {
    }

    public void setLabel(String label) {
        ((JToggleButton)((Object)this.swingComponent)).setText(label);
    }

    public void setState(boolean state) {
        ((JToggleButton)((Object)this.swingComponent)).setSelected(state);
    }

    private class SwingCheckbox
    extends JCheckBox
    implements SwingComponent {
        Checkbox checkbox;

        SwingCheckbox(Checkbox checkbox) {
            this.checkbox = checkbox;
        }

        public JComponent getJComponent() {
            return this;
        }

        public void handleMouseEvent(MouseEvent ev) {
            ev.setSource(this);
            this.processMouseEvent(ev);
        }

        public void handleMouseMotionEvent(MouseEvent ev) {
            ev.setSource(this);
            this.processMouseMotionEvent(ev);
        }

        public void handleKeyEvent(KeyEvent ev) {
            ev.setSource(this);
            this.processKeyEvent(ev);
        }

        public void handleFocusEvent(FocusEvent ev) {
            this.processFocusEvent(ev);
        }

        public Point getLocationOnScreen() {
            return SwingCheckboxPeer.this.getLocationOnScreen();
        }

        public boolean isShowing() {
            boolean retVal = false;
            if (this.checkbox != null) {
                retVal = this.checkbox.isShowing();
            }
            return retVal;
        }

        public Image createImage(int w, int h) {
            return SwingCheckboxPeer.this.createImage(w, h);
        }

        public Graphics getGraphics() {
            return SwingCheckboxPeer.this.getGraphics();
        }

        public Container getParent() {
            Container par = null;
            if (this.checkbox != null) {
                par = this.checkbox.getParent();
            }
            return par;
        }

        public void requestFocus() {
            SwingCheckboxPeer.this.requestFocus(SwingCheckboxPeer.this.awtComponent, false, true, 0L);
        }

        public boolean requestFocus(boolean temporary) {
            return SwingCheckboxPeer.this.requestFocus(SwingCheckboxPeer.this.awtComponent, temporary, true, 0L);
        }
    }

    class SwingCheckboxListener
    implements ItemListener {
        Checkbox awtCheckbox;

        SwingCheckboxListener(Checkbox checkbox) {
            this.awtCheckbox = checkbox;
        }

        public void itemStateChanged(ItemEvent event) {
            this.awtCheckbox.setState(event.getStateChange() == 1);
            ItemListener[] l = this.awtCheckbox.getItemListeners();
            if (l.length == 0) {
                return;
            }
            ItemEvent ev = new ItemEvent(this.awtCheckbox, 701, this.awtCheckbox, event.getStateChange());
            int i = 0;
            while (i < l.length) {
                l[i].itemStateChanged(ev);
                ++i;
            }
        }
    }
}

