/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.ByteDecodeLoopHelper;
import gnu.java.nio.charset.ByteEncodeLoopHelper;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class US_ASCII
extends Charset {
    US_ASCII() {
        super("US-ASCII", new String[]{"iso-ir-6", "ANSI_X3.4-1986", "ISO_646.irv:1991", "ASCII", "ISO646-US", "ASCII", "us", "IBM367", "cp367", "csASCII", "ANSI_X3.4-1968", "iso_646.irv:1983", "ascii7", "646", "windows-20127"});
    }

    public boolean contains(Charset cs) {
        return cs instanceof US_ASCII;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static final class Decoder
    extends CharsetDecoder {
        private static final ByteDecodeLoopHelper helper = new ByteDecodeLoopHelper(){

            protected boolean isMappable(byte b) {
                return b >= 0;
            }

            protected char mapToChar(byte b) {
                return (char)b;
            }
        };

        Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            return helper.decodeLoop(in, out);
        }
    }

    private static final class Encoder
    extends CharsetEncoder {
        private static final ByteEncodeLoopHelper helper = new ByteEncodeLoopHelper(){

            protected boolean isMappable(char c) {
                return c <= '\u007f';
            }

            protected byte mapToByte(char c) {
                return (byte)c;
            }
        };

        Encoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        public boolean canEncode(char c) {
            return c <= '\u007f';
        }

        public boolean canEncode(CharSequence cs) {
            int i = 0;
            while (i < cs.length()) {
                if (!this.canEncode(cs.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            return helper.encodeLoop(in, out);
        }
    }
}

