/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGChunk;
import gnu.javax.imageio.png.PNGData;
import gnu.javax.imageio.png.PNGDecoder;
import gnu.javax.imageio.png.PNGEncoder;
import gnu.javax.imageio.png.PNGException;
import gnu.javax.imageio.png.PNGGamma;
import gnu.javax.imageio.png.PNGHeader;
import gnu.javax.imageio.png.PNGICCProfile;
import gnu.javax.imageio.png.PNGPalette;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class PNGFile {
    private static final byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] endChunk;
    private Vector chunks;
    private PNGHeader header;
    private boolean hasPalette;
    private int width;
    private int height;
    private PNGDecoder decoder;
    private PNGEncoder encoder;
    private BufferedImage sourceImage;

    static {
        byte[] byArray = new byte[12];
        byArray[4] = 73;
        byArray[5] = 69;
        byArray[6] = 78;
        byArray[7] = 68;
        byArray[8] = -82;
        byArray[9] = 66;
        byArray[10] = 96;
        byArray[11] = -126;
        endChunk = byArray;
    }

    public PNGFile(InputStream in) throws IOException, PNGException {
        byte[] fileHdr = new byte[8];
        this.chunks = new Vector();
        this.hasPalette = false;
        if (in.read(fileHdr) != 8) {
            throw new IOException("Could not read file header.");
        }
        if (!this.validateHeader(fileHdr)) {
            throw new PNGException("Invalid file header. Not a PNG file.");
        }
        PNGChunk chunk = PNGChunk.readChunk(in, false);
        if (!(chunk instanceof PNGHeader)) {
            throw new PNGException("First chunk not a header chunk.");
        }
        this.header = (PNGHeader)chunk;
        if (!this.header.isValidChunk()) {
            throw new PNGException("First chunk not a valid header.");
        }
        System.out.println(this.header);
        this.decoder = new PNGDecoder(this.header);
        do {
            if ((chunk = PNGChunk.readChunk(in, false)).isValidChunk()) {
                if (chunk instanceof PNGData) {
                    this.decoder.addData((PNGData)chunk);
                    continue;
                }
                if (chunk.getType() == 1229278788) continue;
                this.chunks.add(chunk);
                this.hasPalette |= chunk instanceof PNGPalette;
                continue;
            }
            System.out.println("WARNING: Invalid chunk!");
        } while (chunk.getType() != 1229278788);
        if (this.header.isIndexed() && !this.hasPalette) {
            throw new PNGException("File is indexed color and has no palette.");
        }
        this.width = this.header.getWidth();
        this.height = this.header.getHeight();
    }

    public PNGFile(BufferedImage bi) throws PNGException {
        this.sourceImage = bi;
        this.width = bi.getWidth();
        this.height = bi.getHeight();
        this.chunks = new Vector();
        this.encoder = new PNGEncoder(bi);
        this.header = this.encoder.getHeader();
        if (this.header.isIndexed()) {
            this.chunks.add(this.encoder.getPalette());
        }
        this.chunks.addAll(this.encoder.encodeImage());
    }

    public void writePNG(OutputStream out) throws IOException {
        out.write(signature);
        this.header.writeChunk(out);
        int i = 0;
        while (i < this.chunks.size()) {
            PNGChunk chunk = (PNGChunk)this.chunks.elementAt(i);
            chunk.writeChunk(out);
            ++i;
        }
        out.write(endChunk);
    }

    private boolean validateHeader(byte[] hdr) {
        if (hdr.length != 8) {
            return false;
        }
        int i = 0;
        while (i < 8) {
            if (signature[i] != hdr[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public BufferedImage getBufferedImage() {
        ColorModel cm;
        if (this.decoder == null) {
            return this.sourceImage;
        }
        WritableRaster r = this.decoder.getRaster(this.header);
        if (this.header.isIndexed()) {
            PNGPalette pngp = this.getPalette();
            cm = pngp.getPalette(this.getColorSpace());
        } else {
            cm = this.decoder.getColorModel(this.getColorSpace(), this.header.getColorType(), this.header.getDepth());
        }
        return new BufferedImage(cm, r, false, null);
    }

    private PNGPalette getPalette() {
        int i = 0;
        while (i < this.chunks.size()) {
            if (this.chunks.elementAt(i) instanceof PNGPalette) {
                return (PNGPalette)this.chunks.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    private ColorSpace getColorSpace() {
        PNGICCProfile icc = null;
        int i = 0;
        while (i < this.chunks.size()) {
            if (this.chunks.elementAt(i) instanceof PNGICCProfile) {
                icc = (PNGICCProfile)this.chunks.elementAt(i);
            } else if (this.chunks.elementAt(i) instanceof PNGGamma) {
                PNGGamma cfr_ignored_0 = (PNGGamma)this.chunks.elementAt(i);
            }
            ++i;
        }
        if (icc != null) {
            return icc.getColorSpace();
        }
        return null;
    }
}

