/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.midi.file;

import gnu.javax.sound.midi.file.MidiDataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;

public class MidiFileWriter
extends javax.sound.midi.spi.MidiFileWriter {
    public int[] getMidiFileTypes() {
        int[] nArray = new int[2];
        nArray[1] = 1;
        return nArray;
    }

    public int[] getMidiFileTypes(Sequence sequence) {
        if (sequence.getTracks().length == 1) {
            return new int[1];
        }
        return new int[]{1};
    }

    public int write(Sequence in, int fileType, OutputStream out) throws IOException {
        MidiDataOutputStream dos = new MidiDataOutputStream(out);
        Track[] tracks = in.getTracks();
        dos.writeInt(1297377380);
        dos.writeInt(6);
        dos.writeShort(fileType);
        dos.writeShort(tracks.length);
        float divisionType = in.getDivisionType();
        int resolution = in.getResolution();
        int division = 0;
        if (divisionType == 0.0f) {
            division = resolution & Short.MAX_VALUE;
        }
        dos.writeShort(division);
        int length = 14;
        int i = 0;
        while (i < tracks.length) {
            length += this.writeTrack(tracks[i], dos);
            ++i;
        }
        return length;
    }

    private int computeTrackLength(Track track, MidiDataOutputStream dos) {
        int length = 0;
        int i = 0;
        int eventCount = track.size();
        long ptick = 0L;
        while (i < eventCount) {
            MidiEvent me = track.get(i);
            long tick = me.getTick();
            length += dos.variableLengthIntLength((int)(tick - ptick));
            ptick = tick;
            length += me.getMessage().getLength();
            ++i;
        }
        return length;
    }

    private int writeTrack(Track track, MidiDataOutputStream dos) throws IOException {
        MetaMessage mm;
        int i = 0;
        int elength = track.size();
        MidiEvent pme = null;
        dos.writeInt(1297379947);
        int trackLength = this.computeTrackLength(track, dos);
        dos.writeInt(trackLength);
        while (i < elength) {
            MidiEvent me = track.get(i);
            int dtime = 0;
            if (pme != null) {
                dtime = (int)(me.getTick() - pme.getTick());
            }
            dos.writeVariableLengthInt(dtime);
            byte[] msg = me.getMessage().getMessage();
            dos.write(msg);
            pme = me;
            ++i;
        }
        if (pme != null && pme.getMessage() instanceof MetaMessage && (mm = (MetaMessage)pme.getMessage()).getType() == 47) {
            return trackLength + 8;
        }
        dos.writeVariableLengthInt(0);
        dos.writeByte(255);
        dos.writeByte(47);
        dos.writeVariableLengthInt(0);
        return trackLength + 8 + 4;
    }

    public int write(Sequence in, int fileType, File out) throws IOException {
        FileOutputStream os = new FileOutputStream(out);
        try {
            int n = this.write(in, fileType, os);
            return n;
        }
        finally {
            ((OutputStream)os).close();
        }
    }
}

