/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.ImplementedBy;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.ProvidedBy;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.InjectionRequest;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.ProviderLookup;
import com.google.inject.spi.StaticInjectionRequest;
import com.google.inject.spi.UntargettedBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.sisu.inject.DeferredProvider;
import org.eclipse.sisu.inject.Guice4;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.TypeArguments;
import org.eclipse.sisu.wire.ParameterKeys;

final class DependencyAnalyzer
extends DefaultBindingTargetVisitor<Object, Boolean> {
    private static final Set<Class<?>> RESTRICTED_CLASSES = new HashSet<Class>(Arrays.asList(AbstractModule.class, Binder.class, Binding.class, Injector.class, Key.class, Logger.class, MembersInjector.class, Module.class, Provider.class, Scope.class, TypeLiteral.class));
    private final Map<TypeLiteral<?>, Boolean> analyzedTypes = new HashMap();
    private final Set<Key<?>> requiredKeys = new HashSet();

    DependencyAnalyzer() {
        this.requiredKeys.add(ParameterKeys.PROPERTIES);
    }

    public Set<Key<?>> findMissingKeys(Set<Key<?>> localKeys) {
        HashSet missingKeys = new HashSet();
        while (this.requiredKeys.size() > 0) {
            ArrayList candidateKeys = new ArrayList(this.requiredKeys);
            this.requiredKeys.clear();
            for (Key key2 : candidateKeys) {
                if (localKeys.contains(key2) || !missingKeys.add(key2)) continue;
                this.analyzeImplicitBindings(key2.getTypeLiteral());
            }
        }
        return missingKeys;
    }

    @Override
    public Boolean visit(UntargettedBinding<?> binding2) {
        return this.analyzeImplementation(binding2.getKey().getTypeLiteral(), true);
    }

    @Override
    public Boolean visit(LinkedKeyBinding<?> binding2) {
        Key<?> linkedKey = binding2.getLinkedKey();
        if (linkedKey.getAnnotationType() == null) {
            return this.analyzeImplementation(linkedKey.getTypeLiteral(), true);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ProviderKeyBinding<?> binding2) {
        Key<javax.inject.Provider<?>> providerKey = binding2.getProviderKey();
        if (providerKey.getAnnotationType() == null) {
            return this.analyzeImplementation(providerKey.getTypeLiteral(), true);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ProviderInstanceBinding<?> binding2) {
        javax.inject.Provider<?> provider = Guice4.getProviderInstance(binding2);
        if (provider instanceof DeferredProvider) {
            try {
                Class clazz = ((DeferredProvider)provider).getImplementationClass().load();
                this.analyzeImplementation(TypeLiteral.get(clazz), false);
            }
            catch (TypeNotPresentException typeNotPresentException) {}
            return Boolean.TRUE;
        }
        return this.analyzeDependencies(binding2.getDependencies());
    }

    @Override
    public Boolean visitOther(Binding<?> binding2) {
        if (binding2 instanceof HasDependencies) {
            return this.analyzeDependencies(((HasDependencies)((Object)binding2)).getDependencies());
        }
        return Boolean.TRUE;
    }

    @Override
    public <T> Boolean visit(ProviderLookup<T> lookup) {
        this.requireKey(lookup.getKey());
        return Boolean.TRUE;
    }

    public Boolean visit(StaticInjectionRequest request) {
        return this.analyzeInjectionPoints(request.getInjectionPoints());
    }

    @Override
    public Boolean visit(InjectionRequest<?> request) {
        return this.analyzeInjectionPoints(request.getInjectionPoints());
    }

    private void requireKey(Key<?> key2) {
        if (!this.requiredKeys.contains(key2)) {
            Class<?> clazz = key2.getTypeLiteral().getRawType();
            if (javax.inject.Provider.class == clazz || Provider.class == clazz) {
                this.requireKey(key2.ofType(TypeArguments.get(key2.getTypeLiteral(), 0)));
            } else if (!RESTRICTED_CLASSES.contains(clazz)) {
                this.requiredKeys.add(key2);
            }
        }
    }

    private Boolean analyzeImplementation(TypeLiteral<?> type2, boolean reportErrors) {
        Boolean applyBinding = this.analyzedTypes.get(type2);
        if (applyBinding == null) {
            applyBinding = Boolean.TRUE;
            if (TypeArguments.isConcrete(type2) && !type2.toString().startsWith("java")) {
                try {
                    boolean rhs = this.analyzeInjectionPoints(InjectionPoint.forInstanceMethodsAndFields(type2));
                    if (!this.analyzeDependencies(InjectionPoint.forConstructorOf(type2).getDependencies()) || !rhs) {
                        applyBinding = Boolean.FALSE;
                    }
                }
                catch (RuntimeException e2) {
                    if (reportErrors) {
                        Logs.trace("Potential problem: {}", type2, e2);
                    }
                    applyBinding = Boolean.FALSE;
                }
                catch (LinkageError e3) {
                    if (reportErrors) {
                        Logs.trace("Potential problem: {}", type2, e3);
                    }
                    applyBinding = Boolean.FALSE;
                }
            }
            this.analyzedTypes.put(type2, applyBinding);
        }
        return applyBinding;
    }

    private boolean analyzeInjectionPoints(Set<InjectionPoint> points) {
        boolean applyBinding = true;
        for (InjectionPoint p : points) {
            applyBinding &= this.analyzeDependencies(p.getDependencies());
        }
        return applyBinding;
    }

    private boolean analyzeDependencies(Collection<Dependency<?>> dependencies) {
        boolean applyBinding = true;
        for (Dependency<?> d : dependencies) {
            Key<?> key2 = d.getKey();
            if (key2.hasAttributes() && "Assisted".equals(key2.getAnnotationType().getSimpleName())) {
                applyBinding = false;
                continue;
            }
            this.requireKey(key2);
        }
        return applyBinding;
    }

    private void analyzeImplicitBindings(TypeLiteral<?> type2) {
        if (!this.analyzedTypes.containsKey(type2)) {
            Class<?> clazz = type2.getRawType();
            if (TypeArguments.isConcrete(clazz)) {
                this.analyzeImplementation(type2, false);
            } else {
                this.analyzedTypes.put(type2, Boolean.TRUE);
                ImplementedBy implementedBy = clazz.getAnnotation(ImplementedBy.class);
                if (implementedBy != null) {
                    this.requireKey(Key.get(implementedBy.value()));
                } else {
                    ProvidedBy providedBy = clazz.getAnnotation(ProvidedBy.class);
                    if (providedBy != null) {
                        this.requireKey(Key.get(providedBy.value()));
                    }
                }
            }
        }
    }
}

