/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.expression.ArrayExpression;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.BooleanExpression;
import org.jd.core.v1.model.javasyntax.expression.CastExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.Expressions;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.LengthExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.PostOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.PreOperatorExpression;
import org.jd.core.v1.model.javasyntax.statement.AssertStatement;
import org.jd.core.v1.model.javasyntax.statement.BreakStatement;
import org.jd.core.v1.model.javasyntax.statement.ByteCodeStatement;
import org.jd.core.v1.model.javasyntax.statement.CommentStatement;
import org.jd.core.v1.model.javasyntax.statement.ContinueStatement;
import org.jd.core.v1.model.javasyntax.statement.DoWhileStatement;
import org.jd.core.v1.model.javasyntax.statement.ExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ForEachStatement;
import org.jd.core.v1.model.javasyntax.statement.ForStatement;
import org.jd.core.v1.model.javasyntax.statement.IfElseStatement;
import org.jd.core.v1.model.javasyntax.statement.IfStatement;
import org.jd.core.v1.model.javasyntax.statement.LabelStatement;
import org.jd.core.v1.model.javasyntax.statement.LambdaExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.LocalVariableDeclarationStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.statement.SwitchStatement;
import org.jd.core.v1.model.javasyntax.statement.SynchronizedStatement;
import org.jd.core.v1.model.javasyntax.statement.ThrowStatement;
import org.jd.core.v1.model.javasyntax.statement.TryStatement;
import org.jd.core.v1.model.javasyntax.statement.TypeDeclarationStatement;
import org.jd.core.v1.model.javasyntax.statement.WhileStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.BasicBlock;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileBreakContinueStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileForEachStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileForStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.LocalVariableMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchFirstLineNumberVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchLocalVariableReferenceVisitor;

public class LoopStatementMaker {
    protected static final RemoveLastContinueStatementVisitor REMOVE_LAST_CONTINUE_STATEMENT_VISITOR = new RemoveLastContinueStatementVisitor();

    public static Statement makeLoop(LocalVariableMaker localVariableMaker, BasicBlock loopBasicBlock, Statements<Statement> statements, Expression condition, Statements<Statement> subStatements, Statements jumps) {
        Statement loop = LoopStatementMaker.makeLoop(localVariableMaker, loopBasicBlock, statements, condition, subStatements);
        int continueOffset = loopBasicBlock.getSub1().getFromOffset();
        int breakOffset = loopBasicBlock.getNext().getFromOffset();
        if (breakOffset <= 0) {
            breakOffset = loopBasicBlock.getToOffset();
        }
        return LoopStatementMaker.makeLabels(loopBasicBlock.getIndex(), continueOffset, breakOffset, loop, jumps);
    }

    protected static Statement makeLoop(LocalVariableMaker localVariableMaker, BasicBlock loopBasicBlock, Statements<Statement> statements, Expression condition, Statements<Statement> subStatements) {
        subStatements.accept(REMOVE_LAST_CONTINUE_STATEMENT_VISITOR);
        Statement statement = LoopStatementMaker.makeForEachArray(localVariableMaker, statements, condition, subStatements);
        if (statement != null) {
            return statement;
        }
        statement = LoopStatementMaker.makeForEachList(localVariableMaker, statements, condition, subStatements);
        if (statement != null) {
            return statement;
        }
        int lineNumber = condition == null ? 0 : condition.getLineNumber();
        int subStatementsSize = subStatements.size();
        switch (subStatementsSize) {
            case 0: {
                BaseExpression init;
                if (lineNumber <= 0 || (init = LoopStatementMaker.extractInit(statements, lineNumber)) == null) break;
                return new ClassFileForStatement(loopBasicBlock.getFromOffset(), loopBasicBlock.getToOffset(), init, condition, null, null);
            }
            case 1: {
                if (lineNumber > 0) {
                    Statement subStatement = (Statement)subStatements.getFirst();
                    BaseExpression init = LoopStatementMaker.extractInit(statements, lineNumber);
                    if (subStatement.getClass() == ExpressionStatement.class) {
                        Expression subExpression = ((ExpressionStatement)subStatement).getExpression();
                        if (subExpression.getLineNumber() == lineNumber) {
                            return new ClassFileForStatement(loopBasicBlock.getFromOffset(), loopBasicBlock.getToOffset(), init, condition, subExpression, null);
                        }
                        if (init == null) break;
                        return new ClassFileForStatement(loopBasicBlock.getFromOffset(), loopBasicBlock.getToOffset(), init, condition, null, subStatement);
                    }
                    if (init == null) break;
                    return new ClassFileForStatement(loopBasicBlock.getFromOffset(), loopBasicBlock.getToOffset(), init, condition, null, subStatement);
                }
                return LoopStatementMaker.createForStatementWithoutLineNumber(loopBasicBlock, statements, condition, subStatements);
            }
            default: {
                if (lineNumber > 0) {
                    SearchFirstLineNumberVisitor visitor = new SearchFirstLineNumberVisitor();
                    ((Statement)subStatements.get(0)).accept(visitor);
                    int firstLineNumber = visitor.getLineNumber();
                    Expressions<Expression> update = LoopStatementMaker.extractUpdate(subStatements, firstLineNumber);
                    BaseExpression init = LoopStatementMaker.extractInit(statements, lineNumber);
                    if (init == null && update.size() <= 0) break;
                    return new ClassFileForStatement(loopBasicBlock.getFromOffset(), loopBasicBlock.getToOffset(), init, condition, update, subStatements);
                }
                return LoopStatementMaker.createForStatementWithoutLineNumber(loopBasicBlock, statements, condition, subStatements);
            }
        }
        return new WhileStatement(condition, subStatements);
    }

    public static Statement makeLoop(BasicBlock loopBasicBlock, Statements<Statement> statements, Statements<Statement> subStatements, Statements jumps) {
        subStatements.accept(REMOVE_LAST_CONTINUE_STATEMENT_VISITOR);
        Statement loop = LoopStatementMaker.makeLoop(loopBasicBlock, statements, subStatements);
        int continueOffset = loopBasicBlock.getSub1().getFromOffset();
        int breakOffset = loopBasicBlock.getNext().getFromOffset();
        if (breakOffset <= 0) {
            breakOffset = loopBasicBlock.getToOffset();
        }
        return LoopStatementMaker.makeLabels(loopBasicBlock.getIndex(), continueOffset, breakOffset, loop, jumps);
    }

    protected static Statement makeLoop(BasicBlock loopBasicBlock, Statements<Statement> statements, Statements<Statement> subStatements) {
        int subStatementsSize = subStatements.size();
        if (subStatementsSize > 0 && subStatements.getLast() == ContinueStatement.CONTINUE) {
            subStatements.removeLast();
            --subStatementsSize;
        }
        switch (subStatementsSize) {
            case 0: {
                break;
            }
            case 1: {
                BaseExpression init;
                Expression subExpression;
                int lineNumber;
                Statement subStatement = (Statement)subStatements.getFirst();
                if (subStatement.getClass() != ExpressionStatement.class || (lineNumber = (subExpression = ((ExpressionStatement)subStatement).getExpression()).getLineNumber()) <= 0 || (init = LoopStatementMaker.extractInit(statements, lineNumber)) == null) break;
                return new ClassFileForStatement(loopBasicBlock.getFromOffset(), loopBasicBlock.getToOffset(), init, null, subExpression, null);
            }
            default: {
                SearchFirstLineNumberVisitor visitor = new SearchFirstLineNumberVisitor();
                ((Statement)subStatements.get(0)).accept(visitor);
                int firstLineNumber = visitor.getLineNumber();
                if (firstLineNumber > 0) {
                    Expressions<Expression> update = LoopStatementMaker.extractUpdate(subStatements, firstLineNumber);
                    if (update.size() <= 0) break;
                    BaseExpression init = LoopStatementMaker.extractInit(statements, ((Expression)update.getFirst()).getLineNumber());
                    return new ClassFileForStatement(loopBasicBlock.getFromOffset(), loopBasicBlock.getToOffset(), init, null, update, subStatements);
                }
                Statement statement = LoopStatementMaker.createForStatementWithoutLineNumber(loopBasicBlock, statements, BooleanExpression.TRUE, subStatements);
                if (statement == null) break;
                return statement;
            }
        }
        return new WhileStatement(BooleanExpression.TRUE, subStatements);
    }

    public static Statement makeDoWhileLoop(BasicBlock loopBasicBlock, BasicBlock lastSubBasicBlock, Expression condition, Statements subStatements, Statements jumps) {
        subStatements.accept(REMOVE_LAST_CONTINUE_STATEMENT_VISITOR);
        DoWhileStatement loop = new DoWhileStatement(condition, subStatements);
        int continueOffset = loopBasicBlock.getSub1().getFromOffset();
        int breakOffset = loopBasicBlock.getNext().getFromOffset();
        if (breakOffset <= 0) {
            breakOffset = loopBasicBlock.getToOffset();
        }
        return LoopStatementMaker.makeLabels(loopBasicBlock.getIndex(), continueOffset, breakOffset, loop, jumps);
    }

    protected static BaseExpression extractInit(Statements<Statement> statements, int lineNumber) {
        if (lineNumber > 0) {
            switch (statements.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    Expression expression;
                    Statement statement = (Statement)statements.getFirst();
                    if (statement.getClass() != ExpressionStatement.class || (expression = ((ExpressionStatement)statement).getExpression()).getLineNumber() != lineNumber || expression.getClass() != BinaryOperatorExpression.class || ((BinaryOperatorExpression)expression).getRightExpression().getLineNumber() == 0) break;
                    statements.clear();
                    return expression;
                }
                default: {
                    Expression expression;
                    Statement statement;
                    Expressions<Expression> init = new Expressions<Expression>();
                    ListIterator iterator = statements.listIterator(statements.size());
                    while (iterator.hasPrevious() && (statement = (Statement)iterator.previous()).getClass() == ExpressionStatement.class && (expression = ((ExpressionStatement)statement).getExpression()).getLineNumber() == lineNumber && expression.getClass() == BinaryOperatorExpression.class && ((BinaryOperatorExpression)expression).getRightExpression().getLineNumber() != 0) {
                        init.add(expression);
                        iterator.remove();
                    }
                    if (init.size() <= 0) break;
                    if (init.size() > 1) {
                        Collections.reverse(init);
                    }
                    return init;
                }
            }
        }
        return null;
    }

    protected static Expressions<Expression> extractUpdate(Statements statements, int firstLineNumber) {
        Expression expression;
        Statement statement;
        Expressions<Expression> update = new Expressions<Expression>();
        ListIterator iterator = statements.listIterator(statements.size());
        while (iterator.hasPrevious() && (statement = (Statement)iterator.previous()).getClass() == ExpressionStatement.class && (expression = ((ExpressionStatement)statement).getExpression()).getLineNumber() < firstLineNumber) {
            iterator.remove();
            update.add(expression);
        }
        if (update.size() > 1) {
            Collections.reverse(update);
        }
        return update;
    }

    protected static Statement createForStatementWithoutLineNumber(BasicBlock basicBlock, Statements<Statement> statements, Expression condition, Statements<Statement> subStatements) {
        BinaryOperatorExpression boe;
        Expression init;
        Statement statement;
        if (!statements.isEmpty() && (statement = (Statement)statements.getLast()).getClass() == ExpressionStatement.class && (init = ((ExpressionStatement)statement).getExpression()).getClass() == BinaryOperatorExpression.class && (boe = (BinaryOperatorExpression)init).getLeftExpression().getClass() == ClassFileLocalVariableReferenceExpression.class) {
            AbstractLocalVariable localVariable = ((ClassFileLocalVariableReferenceExpression)boe.getLeftExpression()).getLocalVariable();
            statement = (Statement)subStatements.getLast();
            if (statement.getClass() == ExpressionStatement.class) {
                Expression expression;
                Expression update = ((ExpressionStatement)statement).getExpression();
                Class<?> clazz = update.getClass();
                if (clazz == BinaryOperatorExpression.class) {
                    expression = ((BinaryOperatorExpression)update).getLeftExpression();
                } else if (clazz == PreOperatorExpression.class) {
                    PreOperatorExpression poe = (PreOperatorExpression)update;
                    expression = poe.getExpression();
                    update = new PostOperatorExpression(poe.getLineNumber(), expression, poe.getOperator());
                } else if (clazz == PostOperatorExpression.class) {
                    expression = ((PostOperatorExpression)update).getExpression();
                } else {
                    return new WhileStatement(condition, subStatements);
                }
                if (expression.getClass() == ClassFileLocalVariableReferenceExpression.class && ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable() == localVariable) {
                    statements.removeLast();
                    subStatements.removeLast();
                    if (condition == BooleanExpression.TRUE) {
                        condition = null;
                    }
                    return new ClassFileForStatement(basicBlock.getFromOffset(), basicBlock.getToOffset(), init, condition, update, subStatements);
                }
            }
        }
        return new WhileStatement(condition, subStatements);
    }

    protected static Statement makeForEachArray(LocalVariableMaker localVariableMaker, Statements<Statement> statements, Expression condition, Statements<Statement> subStatements) {
        if (condition == null) {
            return null;
        }
        int statementsSize = statements.size();
        if (statementsSize < 3 || subStatements.size() < 2) {
            return null;
        }
        Statement statement = (Statement)statements.get(statementsSize - 2);
        if (statement.getClass() != ExpressionStatement.class) {
            return null;
        }
        int lineNumber = condition.getLineNumber();
        Expression expression = ((ExpressionStatement)statement).getExpression();
        if (expression.getLineNumber() != lineNumber || expression.getClass() != BinaryOperatorExpression.class) {
            return null;
        }
        BinaryOperatorExpression boe = (BinaryOperatorExpression)expression;
        if (boe.getRightExpression().getClass() != LengthExpression.class || boe.getLeftExpression().getClass() != ClassFileLocalVariableReferenceExpression.class) {
            return null;
        }
        expression = ((LengthExpression)boe.getRightExpression()).getExpression();
        if (expression.getClass() != ClassFileLocalVariableReferenceExpression.class) {
            return null;
        }
        AbstractLocalVariable syntheticArray = ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable();
        AbstractLocalVariable syntheticLength = ((ClassFileLocalVariableReferenceExpression)boe.getLeftExpression()).getLocalVariable();
        if (syntheticArray.getName() != null && syntheticArray.getName().indexOf(36) == -1) {
            return null;
        }
        statement = (Statement)subStatements.getFirst();
        if (statement.getClass() != ExpressionStatement.class) {
            return null;
        }
        expression = ((ExpressionStatement)statement).getExpression();
        if (expression.getClass() != BinaryOperatorExpression.class) {
            return null;
        }
        boe = (BinaryOperatorExpression)expression;
        if (boe.getRightExpression().getClass() != ArrayExpression.class || boe.getLeftExpression().getClass() != ClassFileLocalVariableReferenceExpression.class || boe.getLineNumber() != condition.getLineNumber()) {
            return null;
        }
        ArrayExpression arrayExpression = (ArrayExpression)boe.getRightExpression();
        if (arrayExpression.getExpression().getClass() != ClassFileLocalVariableReferenceExpression.class || arrayExpression.getIndex().getClass() != ClassFileLocalVariableReferenceExpression.class) {
            return null;
        }
        if (((ClassFileLocalVariableReferenceExpression)arrayExpression.getExpression()).getLocalVariable() != syntheticArray) {
            return null;
        }
        AbstractLocalVariable syntheticIndex = ((ClassFileLocalVariableReferenceExpression)arrayExpression.getIndex()).getLocalVariable();
        AbstractLocalVariable item = ((ClassFileLocalVariableReferenceExpression)boe.getLeftExpression()).getLocalVariable();
        if (syntheticIndex.getName() != null && syntheticIndex.getName().indexOf(36) == -1) {
            return null;
        }
        statement = (Statement)statements.get(statementsSize - 3);
        if (statement.getClass() != ExpressionStatement.class) {
            return null;
        }
        expression = ((ExpressionStatement)statement).getExpression();
        if (expression.getClass() != BinaryOperatorExpression.class) {
            return null;
        }
        boe = (BinaryOperatorExpression)expression;
        if (boe.getLeftExpression().getClass() != ClassFileLocalVariableReferenceExpression.class) {
            return null;
        }
        if (((ClassFileLocalVariableReferenceExpression)boe.getLeftExpression()).getLocalVariable() != syntheticArray) {
            return null;
        }
        Expression array = boe.getRightExpression();
        statement = (Statement)statements.get(statementsSize - 1);
        if (statement.getClass() != ExpressionStatement.class) {
            return null;
        }
        expression = ((ExpressionStatement)statement).getExpression();
        if (expression.getClass() != BinaryOperatorExpression.class) {
            return null;
        }
        boe = (BinaryOperatorExpression)expression;
        if (boe.getLineNumber() != lineNumber || boe.getLeftExpression().getClass() != ClassFileLocalVariableReferenceExpression.class || boe.getRightExpression().getClass() != IntegerConstantExpression.class) {
            return null;
        }
        if (((IntegerConstantExpression)boe.getRightExpression()).getValue() != 0 || ((ClassFileLocalVariableReferenceExpression)boe.getLeftExpression()).getLocalVariable() != syntheticIndex) {
            return null;
        }
        if (condition.getClass() != BinaryOperatorExpression.class) {
            return null;
        }
        boe = (BinaryOperatorExpression)condition;
        if (boe.getLeftExpression().getClass() != ClassFileLocalVariableReferenceExpression.class || boe.getRightExpression().getClass() != ClassFileLocalVariableReferenceExpression.class) {
            return null;
        }
        if (((ClassFileLocalVariableReferenceExpression)boe.getLeftExpression()).getLocalVariable() != syntheticIndex || ((ClassFileLocalVariableReferenceExpression)boe.getRightExpression()).getLocalVariable() != syntheticLength) {
            return null;
        }
        statement = (Statement)subStatements.getLast();
        if (statement.getClass() != ExpressionStatement.class) {
            return null;
        }
        expression = ((ExpressionStatement)statement).getExpression();
        if (expression.getLineNumber() != lineNumber || expression.getClass() != PostOperatorExpression.class) {
            return null;
        }
        statements.removeLast();
        statements.removeLast();
        statements.removeLast();
        subStatements.remove(0);
        subStatements.removeLast();
        item.setDeclared(true);
        localVariableMaker.removeLocalVariable(syntheticArray);
        localVariableMaker.removeLocalVariable(syntheticIndex);
        localVariableMaker.removeLocalVariable(syntheticLength);
        return new ClassFileForEachStatement(item, array, subStatements);
    }

    protected static Statement makeForEachList(LocalVariableMaker localVariableMaker, Statements<Statement> statements, Expression condition, Statements<Statement> subStatements) {
        if (condition == null) {
            return null;
        }
        if (statements.size() < 1 || subStatements.size() < 1) {
            return null;
        }
        if (condition.getClass() != MethodInvocationExpression.class) {
            return null;
        }
        MethodInvocationExpression mie = (MethodInvocationExpression)condition;
        if (!mie.getName().equals("hasNext") || !mie.getInternalTypeName().equals("java/util/Iterator") || mie.getExpression().getClass() != ClassFileLocalVariableReferenceExpression.class) {
            return null;
        }
        AbstractLocalVariable syntheticIterator = ((ClassFileLocalVariableReferenceExpression)mie.getExpression()).getLocalVariable();
        if (syntheticIterator.getName() != null && syntheticIterator.getName().indexOf(36) == -1) {
            return null;
        }
        Statement lastStatement = (Statement)statements.getLast();
        if (lastStatement.getClass() != ExpressionStatement.class) {
            return null;
        }
        ExpressionStatement es = (ExpressionStatement)lastStatement;
        if (es.getExpression().getClass() != BinaryOperatorExpression.class) {
            return null;
        }
        BinaryOperatorExpression boe = (BinaryOperatorExpression)es.getExpression();
        if (boe == null || boe.getLeftExpression().getClass() != ClassFileLocalVariableReferenceExpression.class || boe.getRightExpression().getClass() != MethodInvocationExpression.class || boe.getLineNumber() != condition.getLineNumber()) {
            return null;
        }
        mie = (MethodInvocationExpression)boe.getRightExpression();
        if (!mie.getName().equals("iterator") || !mie.getDescriptor().equals("()Ljava/util/Iterator;")) {
            return null;
        }
        if (((ClassFileLocalVariableReferenceExpression)boe.getLeftExpression()).getLocalVariable() != syntheticIterator) {
            return null;
        }
        Expression list = mie.getExpression();
        Statement firstSubStatement = (Statement)subStatements.get(0);
        if (firstSubStatement.getClass() != ExpressionStatement.class) {
            return null;
        }
        es = (ExpressionStatement)firstSubStatement;
        if (es.getExpression().getClass() != BinaryOperatorExpression.class) {
            return null;
        }
        boe = (BinaryOperatorExpression)es.getExpression();
        if (boe.getLeftExpression().getClass() != ClassFileLocalVariableReferenceExpression.class) {
            return null;
        }
        Expression expression = boe.getRightExpression();
        if (boe.getRightExpression().getClass() == CastExpression.class) {
            expression = ((CastExpression)expression).getExpression();
        }
        if (expression.getClass() != MethodInvocationExpression.class) {
            return null;
        }
        mie = (MethodInvocationExpression)expression;
        if (!mie.getName().equals("next") || !mie.getInternalTypeName().equals("java/util/Iterator") || mie.getExpression().getClass() != ClassFileLocalVariableReferenceExpression.class) {
            return null;
        }
        if (((ClassFileLocalVariableReferenceExpression)mie.getExpression()).getLocalVariable() != syntheticIterator) {
            return null;
        }
        SearchLocalVariableReferenceVisitor visitor = new SearchLocalVariableReferenceVisitor(syntheticIterator);
        int len = subStatements.size();
        for (int i = 1; i < len; ++i) {
            ((Statement)subStatements.get(i)).accept(visitor);
        }
        if (visitor.containsReference()) {
            return null;
        }
        AbstractLocalVariable item = ((ClassFileLocalVariableReferenceExpression)boe.getLeftExpression()).getLocalVariable();
        statements.removeLast();
        subStatements.remove(0);
        item.setDeclared(true);
        localVariableMaker.removeLocalVariable(syntheticIterator);
        return new ClassFileForEachStatement(item, list, subStatements);
    }

    protected static Statement makeLabels(int loopIndex, int continueOffset, int breakOffset, Statement loop, Statements jumps) {
        if (!jumps.isEmpty()) {
            Iterator iterator = jumps.iterator();
            String label = "label" + loopIndex;
            boolean createLabel = false;
            while (iterator.hasNext()) {
                ClassFileBreakContinueStatement statement = (ClassFileBreakContinueStatement)iterator.next();
                int offset = statement.getOffset();
                int targetOffset = statement.getTargetOffset();
                if (targetOffset == continueOffset) {
                    statement.setStatement(new ContinueStatement(label));
                    createLabel = true;
                    iterator.remove();
                    continue;
                }
                if (targetOffset == breakOffset) {
                    statement.setStatement(new BreakStatement(label));
                    createLabel = true;
                    iterator.remove();
                    continue;
                }
                if (continueOffset > offset || offset >= breakOffset) continue;
                if (continueOffset <= targetOffset && targetOffset < breakOffset) {
                    if (statement.isContinueLabel()) {
                        statement.setStatement(new ContinueStatement(label));
                        createLabel = true;
                    } else {
                        statement.setStatement(ContinueStatement.CONTINUE);
                    }
                    iterator.remove();
                    continue;
                }
                statement.setContinueLabel(true);
            }
            if (createLabel) {
                return new LabelStatement(label, loop);
            }
        }
        return loop;
    }

    protected static class RemoveLastContinueStatementVisitor
    extends AbstractJavaSyntaxVisitor {
        protected RemoveLastContinueStatementVisitor() {
        }

        @Override
        public void visit(Statements list) {
            if (!list.isEmpty()) {
                Statement last = (Statement)list.getLast();
                if (last.getClass() == ContinueStatement.class) {
                    list.removeLast();
                    this.visit(list);
                } else {
                    last.accept(this);
                }
            }
        }

        @Override
        public void visit(IfElseStatement statement) {
            this.safeAccept(statement.getStatements());
            statement.getElseStatements().accept(this);
        }

        @Override
        public void visit(TryStatement statement) {
            statement.getTryStatements().accept(this);
            this.safeAcceptListStatement(statement.getCatchClauses());
            this.safeAccept(statement.getFinallyStatements());
        }

        @Override
        public void visit(SwitchStatement statement) {
            this.acceptListStatement(statement.getBlocks());
        }

        @Override
        public void visit(SwitchStatement.LabelBlock statement) {
            statement.getStatements().accept(this);
        }

        @Override
        public void visit(SwitchStatement.MultiLabelsBlock statement) {
            statement.getStatements().accept(this);
        }

        @Override
        public void visit(IfStatement statement) {
            this.safeAccept(statement.getStatements());
        }

        @Override
        public void visit(SynchronizedStatement statement) {
            this.safeAccept(statement.getStatements());
        }

        @Override
        public void visit(TryStatement.CatchClause statement) {
            this.safeAccept(statement.getStatements());
        }

        @Override
        public void visit(DoWhileStatement statement) {
        }

        @Override
        public void visit(ForEachStatement statement) {
        }

        @Override
        public void visit(ForStatement statement) {
        }

        @Override
        public void visit(WhileStatement statement) {
        }

        @Override
        public void visit(AssertStatement statement) {
        }

        @Override
        public void visit(BreakStatement statement) {
        }

        @Override
        public void visit(ByteCodeStatement statement) {
        }

        @Override
        public void visit(CommentStatement statement) {
        }

        @Override
        public void visit(ContinueStatement statement) {
        }

        @Override
        public void visit(ExpressionStatement statement) {
        }

        @Override
        public void visit(LabelStatement statement) {
        }

        @Override
        public void visit(LambdaExpressionStatement statement) {
        }

        @Override
        public void visit(LocalVariableDeclarationStatement statement) {
        }

        @Override
        public void visit(ReturnExpressionStatement statement) {
        }

        @Override
        public void visit(ReturnStatement statement) {
        }

        @Override
        public void visit(SwitchStatement.ExpressionLabel statement) {
        }

        @Override
        public void visit(ThrowStatement statement) {
        }

        @Override
        public void visit(TypeDeclarationStatement statement) {
        }

        @Override
        public void visit(TryStatement.Resource statement) {
        }
    }
}

