'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usageMixin = usageMixin;

var _classes = require('./classes');

function usageMixin(kbnServer, server) {
  const collectorSet = new _classes.CollectorSet(server);

  /*
   * expose the collector set object on the server
   * provides factory methods for feature owners to create their own collector objects
   * use collectorSet.register(collector) to register your feature's collector object(s)
   */
  server.decorate('server', 'usage', { collectorSet });
} /*
   * Licensed to Elasticsearch B.V. under one or more contributor
   * license agreements. See the NOTICE file distributed with
   * this work for additional information regarding copyright
   * ownership. Elasticsearch B.V. licenses this file to you under
   * the Apache License, Version 2.0 (the "License"); you may
   * not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *    http://www.apache.org/licenses/LICENSE-2.0
   *
   * Unless required by applicable law or agreed to in writing,
   * software distributed under the License is distributed on an
   * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
   * KIND, either express or implied.  See the License for the
   * specific language governing permissions and limitations
   * under the License.
   */