/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.XMLErrorLogger;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.util.xslt.TransformerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSLTResponseWriter
implements QueryResponseWriter {
    public static final String DEFAULT_CONTENT_TYPE = "application/xml";
    public static final String CONTEXT_TRANSFORMER_KEY = "xsltwriter.transformer";
    private Integer xsltCacheLifetimeSeconds = null;
    public static final int XSLT_CACHE_DEFAULT = 60;
    private static final String XSLT_CACHE_PARAM = "xsltCacheLifetimeSeconds";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final XMLErrorLogger xmllog = new XMLErrorLogger(log);

    @Override
    public void init(NamedList n) {
        SolrParams p = n.toSolrParams();
        this.xsltCacheLifetimeSeconds = p.getInt(XSLT_CACHE_PARAM, 60);
        log.info("xsltCacheLifetimeSeconds=" + this.xsltCacheLifetimeSeconds);
    }

    @Override
    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        Transformer t = null;
        try {
            t = this.getTransformer(request);
        }
        catch (Exception e) {
            throw new RuntimeException("getTransformer fails in getContentType", e);
        }
        String mediaType = t.getOutputProperty("media-type");
        if (mediaType == null || mediaType.length() == 0) {
            mediaType = DEFAULT_CONTENT_TYPE;
        }
        if (!mediaType.contains("charset")) {
            String encoding = t.getOutputProperty("encoding");
            if (encoding == null || encoding.length() == 0) {
                encoding = "UTF-8";
            }
            mediaType = mediaType + "; charset=" + encoding;
        }
        return mediaType;
    }

    @Override
    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        Transformer t = this.getTransformer(request);
        CharArrayWriter w = new CharArrayWriter();
        XMLWriter.writeResponse(w, request, response);
        BufferedReader r = new BufferedReader(new CharArrayReader(w.toCharArray()));
        StreamSource source = new StreamSource(r);
        StreamResult result = new StreamResult(writer);
        try {
            t.transform(source, result);
        }
        catch (TransformerException te) {
            throw new IOException("XSLT transformation error", te);
        }
    }

    protected Transformer getTransformer(SolrQueryRequest request) throws IOException {
        String xslt = request.getParams().get("tr", null);
        if (xslt == null) {
            throw new IOException("'tr' request parameter is required to use the XSLTResponseWriter");
        }
        SolrConfig solrConfig = request.getCore().getSolrConfig();
        Map<Object, Object> ctx = request.getContext();
        Transformer result = (Transformer)ctx.get(CONTEXT_TRANSFORMER_KEY);
        if (result == null) {
            result = TransformerProvider.instance.getTransformer(solrConfig, xslt, this.xsltCacheLifetimeSeconds);
            result.setErrorListener((ErrorListener)xmllog);
            ctx.put(CONTEXT_TRANSFORMER_KEY, result);
        }
        return result;
    }
}

