/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestFieldCapabilitiesAction
extends BaseRestHandler {
    private static final Logger logger = LogManager.getLogger(RestFieldCapabilitiesAction.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);

    public RestFieldCapabilitiesAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_field_caps", this);
        controller.registerHandler(RestRequest.Method.POST, "/_field_caps", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_field_caps", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_field_caps", this);
    }

    @Override
    public String getName() {
        return "field_capabilities_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        FieldCapabilitiesRequest fieldRequest;
        if (request.hasContentOrSourceParam()) {
            deprecationLogger.deprecated("Specifying a request body is deprecated -- the [fields] request parameter should be used instead.", new Object[0]);
            if (request.hasParam("fields")) {
                throw new IllegalArgumentException("can't specify a request body and [fields] request parameter, either specify a request body or the [fields] request parameter");
            }
        }
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        if (request.hasContentOrSourceParam()) {
            try (XContentParser parser = request.contentOrSourceParamParser();){
                fieldRequest = FieldCapabilitiesRequest.parseFields(parser);
            }
        } else {
            fieldRequest = new FieldCapabilitiesRequest();
            fieldRequest.fields(Strings.splitStringByCommaToArray(request.param("fields")));
        }
        fieldRequest.indices(indices);
        fieldRequest.indicesOptions(IndicesOptions.fromRequest(request, fieldRequest.indicesOptions()));
        return channel -> client.fieldCaps(fieldRequest, new RestToXContentListener<FieldCapabilitiesResponse>((RestChannel)channel));
    }
}

