/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.PluginsService;

class RemovePluginCommand
extends EnvironmentAwareCommand {
    static final int PLUGIN_STILL_USED = 11;
    private final OptionSpec<Void> purgeOption;
    private final OptionSpec<String> arguments;

    RemovePluginCommand() {
        super("removes a plugin from Elasticsearch");
        this.purgeOption = this.parser.acceptsAll(Arrays.asList("p", "purge"), "Purge plugin configuration files");
        this.arguments = this.parser.nonOptions("plugin name");
    }

    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        String pluginName = (String)this.arguments.value(options);
        boolean purge = options.has(this.purgeOption);
        this.execute(terminal, env, pluginName, purge);
    }

    void execute(Terminal terminal, Environment env, String pluginName, boolean purge) throws IOException, UserException {
        Stream<Path> paths;
        Path pluginBinDir;
        if (pluginName == null) {
            throw new UserException(64, "plugin name is required");
        }
        ArrayList<String> usedBy = new ArrayList<String>();
        Set bundles = PluginsService.getPluginBundles((Path)env.pluginsFile());
        for (PluginsService.Bundle bundle : bundles) {
            for (String extendedPlugin : bundle.plugin.getExtendedPlugins()) {
                if (!extendedPlugin.equals(pluginName)) continue;
                usedBy.add(bundle.plugin.getName());
            }
        }
        if (!usedBy.isEmpty()) {
            throw new UserException(11, "plugin [" + pluginName + "] cannot be removed because it is extended by other plugins: " + usedBy);
        }
        Path pluginDir = env.pluginsFile().resolve(pluginName);
        Path pluginConfigDir = env.configFile().resolve(pluginName);
        Path removing = env.pluginsFile().resolve(".removing-" + pluginName);
        terminal.println("-> removing [" + pluginName + "]...");
        if (!Files.exists(pluginDir, new LinkOption[0]) && !Files.exists(pluginConfigDir, new LinkOption[0]) && !Files.exists(removing, new LinkOption[0]) || !Files.exists(pluginDir, new LinkOption[0]) && Files.exists(pluginConfigDir, new LinkOption[0]) && !purge) {
            String message = String.format(Locale.ROOT, "plugin [%s] not found; run 'elasticsearch-plugin list' to get list of installed plugins", pluginName);
            throw new UserException(78, message);
        }
        ArrayList<Path> pluginPaths = new ArrayList<Path>();
        if (Files.exists(pluginDir, new LinkOption[0])) {
            try (Stream<Path> paths2 = Files.list(pluginDir);){
                pluginPaths.addAll(paths2.collect(Collectors.toList()));
            }
            terminal.println(Terminal.Verbosity.VERBOSE, "removing [" + pluginDir + "]");
        }
        if (Files.exists(pluginBinDir = env.binFile().resolve(pluginName), new LinkOption[0])) {
            if (!Files.isDirectory(pluginBinDir, new LinkOption[0])) {
                throw new UserException(74, "bin dir for " + pluginName + " is not a directory");
            }
            paths = Files.list(pluginBinDir);
            try {
                pluginPaths.addAll(paths.collect(Collectors.toList()));
            }
            finally {
                if (paths != null) {
                    paths.close();
                }
            }
            pluginPaths.add(pluginBinDir);
            terminal.println(Terminal.Verbosity.VERBOSE, "removing [" + pluginBinDir + "]");
        }
        if (Files.exists(pluginConfigDir, new LinkOption[0])) {
            if (purge) {
                paths = Files.list(pluginConfigDir);
                try {
                    pluginPaths.addAll(paths.collect(Collectors.toList()));
                }
                finally {
                    if (paths != null) {
                        paths.close();
                    }
                }
                pluginPaths.add(pluginConfigDir);
                terminal.println(Terminal.Verbosity.VERBOSE, "removing [" + pluginConfigDir + "]");
            } else {
                String message = String.format(Locale.ROOT, "-> preserving plugin config files [%s] in case of upgrade; use --purge if not needed", pluginConfigDir);
                terminal.println(message);
            }
        }
        try {
            Files.createFile(removing, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            terminal.println(Terminal.Verbosity.VERBOSE, "marker file [" + removing + "] already exists");
        }
        pluginPaths.add(pluginDir);
        pluginPaths.add(removing);
        IOUtils.rm((Path[])pluginPaths.toArray(new Path[pluginPaths.size()]));
    }
}

