/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.XmlDocParser;
import com.adobe.epubcheck.ctc.epubpackage.EpubPackage;
import com.adobe.epubcheck.ctc.epubpackage.ManifestItem;
import com.adobe.epubcheck.ctc.epubpackage.SpineItem;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.util.SearchDictionary;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EpubSVGCheck
implements DocumentValidator {
    private static final String svgNS = "http://www.w3.org/2000/svg";
    private static final String xlinkNS = "http://www.w3.org/1999/xlink";
    private final XmlDocParser docParser;
    private final Report report;
    private final EpubPackage epack;
    private boolean isGlobalFixedFormat;

    public EpubSVGCheck(EpubPackage epack, Report report) {
        this.report = report;
        this.epack = epack;
        this.docParser = new XmlDocParser(epack.getZip(), report);
        this.isGlobalFixedFormat = EpubPackage.isGlobalFixed(epack);
    }

    @Override
    public boolean validate() {
        int i;
        SearchDictionary validTypes = new SearchDictionary(SearchDictionary.DictionaryType.SVG_MEDIA_TYPES);
        boolean isGlobalFixed = EpubPackage.isGlobalFixed(this.epack);
        Hashtable<String, SpineItem> spineItems = new Hashtable<String, SpineItem>();
        for (i = 0; i < this.epack.getSpine().itemsLength(); ++i) {
            SpineItem si = this.epack.getSpine().getItem(i);
            spineItems.put(si.getIdref(), si);
        }
        for (i = 0; i < this.epack.getManifest().itemsLength(); ++i) {
            ManifestItem itemEntry = this.epack.getManifest().getItem(i);
            if (!validTypes.isValidMediaType(itemEntry.getMediaType())) continue;
            String fileToParse = this.epack.getManifestItemFileName(itemEntry);
            ZipEntry entry = this.epack.getZip().getEntry(fileToParse);
            if (entry == null) continue;
            SpineItem si = (SpineItem)spineItems.get(itemEntry.getId());
            boolean itemIsFixedFormat = isGlobalFixed;
            if (si == null) continue;
            String properties = si.getProperties();
            if (properties != null && properties.length() != 0) {
                String[] propertyArray;
                properties = properties.replaceAll("[\\s]+", " ");
                for (String prop : propertyArray = properties.split(" ")) {
                    if (prop.equals("rendition:layout-pre-paginated")) {
                        itemIsFixedFormat = true;
                        continue;
                    }
                    if (!prop.equals("rendition:layout-reflowable")) continue;
                    itemIsFixedFormat = false;
                }
            }
            if (!itemIsFixedFormat) continue;
            this.checkSvgDoc(fileToParse);
        }
        return true;
    }

    void checkSvgDoc(String svgDocEntry) {
        Document doc = this.docParser.parseDocument(svgDocEntry);
        if (doc != null) {
            this.checkImageXlinkHrefInline(svgDocEntry, doc);
        }
    }

    void checkImageXlinkHrefInline(String svgDocEntry, Document doc) {
        NodeList n = doc.getElementsByTagNameNS(svgNS, "image");
        for (int i = 0; i < n.getLength(); ++i) {
            Element svgElement = (Element)n.item(i);
            String href = svgElement.getAttributeNS(xlinkNS, "href");
            if (href == null || href.length() <= 0 || href.startsWith("data:image")) continue;
            this.report.message(MessageId.MED_006, EPUBLocation.create(svgDocEntry, XmlDocParser.getElementLineNumber(svgElement), XmlDocParser.getElementColumnNumber(svgElement)), new Object[0]);
        }
    }

    public boolean isGlobalFixedFormat() {
        return this.isGlobalFixedFormat;
    }
}

