/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.reporting.CheckMessage;
import com.adobe.epubcheck.util.KeyValue;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.util.XmlReportAbstract;
import java.io.PrintWriter;
import java.util.ArrayList;

public class XmlReportImpl
extends XmlReportAbstract {
    public XmlReportImpl(PrintWriter out, String ePubName, String versionEpubCheck) {
        super(out, ePubName, versionEpubCheck);
    }

    @Override
    public int generateReport() {
        if (this.out == null) {
            return 1;
        }
        int returnCode = 1;
        this.generationDate = XmlReportImpl.fromTime(System.currentTimeMillis());
        try {
            Object cs;
            this.setNamespace("http://hul.harvard.edu/ois/xml/ns/jhove");
            this.addPrefixNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            ArrayList<KeyValue<String, String>> attrs = new ArrayList<KeyValue<String, String>>();
            attrs.add(KeyValue.with("name", this.epubCheckName));
            attrs.add(KeyValue.with("release", this.epubCheckVersion));
            attrs.add(KeyValue.with("date", this.epubCheckDate));
            attrs.add(KeyValue.with("xsi:schemaLocation", "http://hul.harvard.edu/ois/xml/ns/jhove http://hul.harvard.edu/ois/xml/xsd/jhove/jhove.xsd"));
            this.startElement("jhove", attrs);
            this.generateElement("date", this.generationDate);
            this.startElement("repInfo", KeyValue.with("uri", this.getEpubFileName()));
            this.generateElement("created", this.creationDate);
            this.generateElement("lastModified", this.lastModifiedDate);
            if (this.formatName == null) {
                this.generateElement("format", "application/octet-stream");
            } else {
                this.generateElement("format", this.formatName);
            }
            this.generateElement("version", this.formatVersion);
            String customMessageFileName = this.getCustomMessageFile();
            if (customMessageFileName != null && !customMessageFileName.isEmpty()) {
                this.generateElement("customMessageFileName", customMessageFileName);
            }
            if (this.fatalErrors.isEmpty() && this.errors.isEmpty()) {
                this.generateElement("status", "Well-formed");
            } else {
                this.generateElement("status", "Not well-formed");
            }
            if (!(this.warns.isEmpty() && this.fatalErrors.isEmpty() && this.errors.isEmpty() && this.hints.isEmpty())) {
                String loc;
                String m;
                this.startElement("messages");
                for (CheckMessage c : this.fatalErrors) {
                    m = c.getID() + ", FATAL, [" + c.getMessage() + "], ";
                    for (EPUBLocation ml : c.getLocations()) {
                        loc = "";
                        if (ml.getLine() > 0 || ml.getColumn() > 0) {
                            loc = " (" + ml.getLine() + "-" + ml.getColumn() + ")";
                        }
                        this.generateElement("message", m + PathUtil.removeWorkingDirectory(ml.getPath()) + loc, KeyValue.with("subMessage", c.getID()), KeyValue.with("severity", "error"));
                    }
                }
                for (CheckMessage c : this.errors) {
                    m = c.getID() + ", ERROR, [" + c.getMessage() + "], ";
                    for (EPUBLocation ml : c.getLocations()) {
                        loc = "";
                        if (ml.getLine() > 0 || ml.getColumn() > 0) {
                            loc = " (" + ml.getLine() + "-" + ml.getColumn() + ")";
                        }
                        this.generateElement("message", m + PathUtil.removeWorkingDirectory(ml.getPath()) + loc, KeyValue.with("subMessage", c.getID()), KeyValue.with("severity", "error"));
                    }
                }
                for (CheckMessage c : this.warns) {
                    m = c.getID() + ", WARN, [" + c.getMessage() + "], ";
                    for (EPUBLocation ml : c.getLocations()) {
                        loc = "";
                        if (ml.getLine() > 0 || ml.getColumn() > 0) {
                            loc = " (" + ml.getLine() + "-" + ml.getColumn() + ")";
                        }
                        this.generateElement("message", m + PathUtil.removeWorkingDirectory(ml.getPath()) + loc, KeyValue.with("subMessage", c.getID()), KeyValue.with("severity", "error"));
                    }
                }
                for (CheckMessage c : this.hints) {
                    m = c.getID() + ", HINT, [" + c.getMessage() + "], ";
                    for (EPUBLocation ml : c.getLocations()) {
                        loc = "";
                        if (ml.getLine() > 0 || ml.getColumn() > 0) {
                            loc = " (" + ml.getLine() + "-" + ml.getColumn() + ")";
                        }
                        this.generateElement("message", m + PathUtil.removeWorkingDirectory(ml.getPath()) + loc, KeyValue.with("subMessage", c.getID()), KeyValue.with("severity", "info"));
                    }
                }
                this.endElement("messages");
            }
            this.generateElement("mimeType", this.formatName);
            this.startElement("properties");
            this.generateProperty("FileName", this.getNameFromPath(this.getEpubFileName()), "String");
            this.generateProperty("PageCount", this.pagesCount);
            this.generateProperty("CharacterCount", this.charsCount);
            this.generateProperty("Language", this.language, "String");
            this.startElement("property");
            this.generateElement("name", "Info");
            this.startElement("values", KeyValue.with("arity", "List"), KeyValue.with("type", "Property"));
            this.generateProperty("Identifier", this.identifier, "String");
            this.generateProperty("CreationDate", this.creationDate, "Date");
            this.generateProperty("ModDate", this.lastModifiedDate, "Date");
            if (!this.titles.isEmpty()) {
                cs = this.titles.toArray(new String[this.titles.size()]);
                this.generateProperty("Title", (String[])cs, "String");
            }
            if (!this.creators.isEmpty()) {
                cs = this.creators.toArray(new String[this.creators.size()]);
                this.generateProperty("Creator", (String[])cs, "String");
            }
            if (!this.contributors.isEmpty()) {
                cs = this.contributors.toArray(new String[this.contributors.size()]);
                this.generateProperty("Contributor", (String[])cs, "String");
            }
            this.generateProperty("Date", this.date, "String");
            this.generateProperty("Publisher", this.publisher, "String");
            if (!this.subjects.isEmpty()) {
                cs = this.subjects.toArray(new String[this.subjects.size()]);
                this.generateProperty("Subject", (String[])cs, "String");
            }
            if (!this.rights.isEmpty()) {
                cs = this.rights.toArray(new String[this.rights.size()]);
                this.generateProperty("Rights", (String[])cs, "String");
            }
            this.endElement("values");
            this.endElement("property");
            if (!this.embeddedFonts.isEmpty() || !this.refFonts.isEmpty()) {
                this.startElement("property");
                this.generateElement("name", "Fonts");
                this.startElement("values", KeyValue.with("arity", "List"), KeyValue.with("type", "Property"));
                for (String f : this.embeddedFonts) {
                    this.startElement("property");
                    this.generateElement("name", "Font");
                    this.startElement("values", KeyValue.with("arity", "List"), KeyValue.with("type", "Property"));
                    this.generateProperty("FontName", this.getNameFromPath(f), "String");
                    this.generateProperty("FontFile", true);
                    this.endElement("values");
                    this.endElement("property");
                }
                for (String f : this.refFonts) {
                    this.startElement("property");
                    this.generateElement("name", "Font");
                    this.startElement("values", KeyValue.with("arity", "List"), KeyValue.with("type", "Property"));
                    this.generateProperty("FontName", this.getNameFromPath(f), "String");
                    this.generateProperty("FontFile", false);
                    this.endElement("values");
                    this.endElement("property");
                }
                this.endElement("values");
                this.endElement("property");
            }
            if (!this.references.isEmpty()) {
                this.startElement("property");
                this.generateElement("name", "References");
                this.startElement("values", KeyValue.with("arity", "List"), KeyValue.with("type", "Property"));
                for (String r : this.references) {
                    this.generateProperty("Reference", r, "String");
                }
                this.endElement("values");
                this.endElement("property");
            }
            if (!this.mediaTypes.isEmpty()) {
                cs = this.mediaTypes.toArray(new String[this.mediaTypes.size()]);
                this.generateProperty("MediaTypes", (String[])cs, "String");
            }
            if (this.hasEncryption) {
                this.generateProperty("hasEncryption", this.hasEncryption);
            }
            if (this.hasSignatures) {
                this.generateProperty("hasSignatures", this.hasSignatures);
            }
            if (this.hasAudio) {
                this.generateProperty("hasAudio", this.hasAudio);
            }
            if (this.hasVideo) {
                this.generateProperty("hasVideo", this.hasVideo);
            }
            if (this.hasFixedLayout) {
                this.generateProperty("hasFixedLayout", this.hasFixedLayout);
            }
            if (this.hasScripts) {
                this.generateProperty("hasScripts", this.hasScripts);
            }
            this.endElement("properties");
            this.endElement("repInfo");
            this.endElement("jhove");
            returnCode = 0;
        }
        catch (Exception e) {
            System.err.println("Exception encountered: " + e.getMessage());
            returnCode = 1;
        }
        return returnCode;
    }

    private void generateProperty(String name, String[] value, String type) {
        if (value == null || value.length == 0) {
            return;
        }
        this.startElement("property");
        this.generateElement("name", name);
        this.startElement("values", KeyValue.with("arity", value.length == 1 ? "Scalar" : "Array"), KeyValue.with("type", type));
        for (String v : value) {
            this.generateElement("value", v);
        }
        this.endElement("values");
        this.endElement("property");
    }

    private void generateProperty(String name, String value, String type) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        this.startElement("property");
        this.generateElement("name", name);
        this.startElement("values", KeyValue.with("arity", "Scalar"), KeyValue.with("type", type));
        this.generateElement("value", value);
        this.endElement("values");
        this.endElement("property");
    }

    private void generateProperty(String name, long value) {
        if (value == 0L) {
            return;
        }
        this.generateProperty(name, Long.toString(value), "Long");
    }

    private void generateProperty(String name, boolean value) {
        this.generateProperty(name, value ? "true" : "false", "Boolean");
    }
}

