/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.renderers.BasicEdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.BasicEdgeRenderer;
import edu.uci.ics.jung.visualization.renderers.BasicVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.BasicVertexRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.util.ConcurrentModificationException;

public class BasicRenderer<V, E>
implements Renderer<V, E> {
    Renderer.Vertex<V, E> vertexRenderer = new BasicVertexRenderer();
    Renderer.VertexLabel<V, E> vertexLabelRenderer = new BasicVertexLabelRenderer();
    Renderer.Edge<V, E> edgeRenderer = new BasicEdgeRenderer();
    Renderer.EdgeLabel<V, E> edgeLabelRenderer = new BasicEdgeLabelRenderer();

    @Override
    public void render(RenderContext<V, E> renderContext, Layout<V, E> layout) {
        try {
            for (Object e : layout.getGraph().getEdges()) {
                this.renderEdge(renderContext, layout, e);
                this.renderEdgeLabel(renderContext, layout, e);
            }
        }
        catch (ConcurrentModificationException cme) {
            renderContext.getScreenDevice().repaint();
        }
        try {
            for (Object v : layout.getGraph().getVertices()) {
                this.renderVertex(renderContext, layout, v);
                this.renderVertexLabel(renderContext, layout, v);
            }
        }
        catch (ConcurrentModificationException cme) {
            renderContext.getScreenDevice().repaint();
        }
    }

    @Override
    public void renderVertex(RenderContext<V, E> rc, Layout<V, E> layout, V v) {
        this.vertexRenderer.paintVertex(rc, layout, v);
    }

    @Override
    public void renderVertexLabel(RenderContext<V, E> rc, Layout<V, E> layout, V v) {
        this.vertexLabelRenderer.labelVertex(rc, layout, v, (String)rc.getVertexLabelTransformer().apply(v));
    }

    @Override
    public void renderEdge(RenderContext<V, E> rc, Layout<V, E> layout, E e) {
        this.edgeRenderer.paintEdge(rc, layout, e);
    }

    @Override
    public void renderEdgeLabel(RenderContext<V, E> rc, Layout<V, E> layout, E e) {
        this.edgeLabelRenderer.labelEdge(rc, layout, e, (String)rc.getEdgeLabelTransformer().apply(e));
    }

    @Override
    public void setVertexRenderer(Renderer.Vertex<V, E> r) {
        this.vertexRenderer = r;
    }

    @Override
    public void setEdgeRenderer(Renderer.Edge<V, E> r) {
        this.edgeRenderer = r;
    }

    @Override
    public Renderer.EdgeLabel<V, E> getEdgeLabelRenderer() {
        return this.edgeLabelRenderer;
    }

    @Override
    public void setEdgeLabelRenderer(Renderer.EdgeLabel<V, E> edgeLabelRenderer) {
        this.edgeLabelRenderer = edgeLabelRenderer;
    }

    @Override
    public Renderer.VertexLabel<V, E> getVertexLabelRenderer() {
        return this.vertexLabelRenderer;
    }

    @Override
    public void setVertexLabelRenderer(Renderer.VertexLabel<V, E> vertexLabelRenderer) {
        this.vertexLabelRenderer = vertexLabelRenderer;
    }

    @Override
    public Renderer.Edge<V, E> getEdgeRenderer() {
        return this.edgeRenderer;
    }

    @Override
    public Renderer.Vertex<V, E> getVertexRenderer() {
        return this.vertexRenderer;
    }
}

