/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.datatypes;

import docking.widgets.MultiLineLabel;
import ghidra.app.merge.datatypes.SourceArchivePanel;
import ghidra.app.merge.util.ConflictCountPanel;
import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.framework.data.DomainObjectMergeManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import resources.ResourceManager;

class SourceArchiveMergePanel
extends JPanel {
    public static final String LATEST_BUTTON_NAME = "Latest";
    public static final String CHECKED_OUT_BUTTON_NAME = "Checked Out";
    public static final String ORIGINAL_BUTTON_NAME = "Original";
    private DomainObjectMergeManager mergeManager;
    private int totalConflicts;
    private ConflictCountPanel countPanel;
    private SourceArchivePanel latestPanel;
    private SourceArchivePanel myPanel;
    private SourceArchivePanel origPanel;
    private JRadioButton latestRB;
    private JRadioButton myRB;
    private JRadioButton originalRB;
    private ButtonGroup buttonGroup;
    private static final String USE_FOR_ALL_CHECKBOX = "UseForAllConflictCheckBox";
    private JCheckBox useForAllCB;

    SourceArchiveMergePanel(DomainObjectMergeManager mergeManager, int totalConflicts) {
        this.mergeManager = mergeManager;
        this.totalConflicts = totalConflicts;
        this.create();
    }

    void setConflictInfo(int conflictIndex, SourceArchive latestSourceArchive, SourceArchive mySourceArchive, SourceArchive origSourceArchive) {
        this.mergeManager.setApplyEnabled(false);
        this.countPanel.updateCount(conflictIndex, this.totalConflicts);
        this.latestPanel.setSourceArchive(latestSourceArchive);
        this.myPanel.setSourceArchive(mySourceArchive);
        this.origPanel.setSourceArchive(origSourceArchive);
        this.buttonGroup.remove(this.latestRB);
        this.buttonGroup.remove(this.myRB);
        this.buttonGroup.remove(this.originalRB);
        this.latestRB.setSelected(false);
        this.myRB.setSelected(false);
        this.originalRB.setSelected(false);
        this.buttonGroup.add(this.latestRB);
        this.buttonGroup.add(this.myRB);
        this.buttonGroup.add(this.originalRB);
    }

    int getSelectedOption() {
        if (this.latestRB.isSelected()) {
            return 0;
        }
        if (this.myRB.isSelected()) {
            return 1;
        }
        if (this.originalRB.isSelected()) {
            return 2;
        }
        return -1;
    }

    private void create() {
        this.buttonGroup = new ButtonGroup();
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SourceArchiveMergePanel.this.mergeManager.clearStatusText();
                    SourceArchiveMergePanel.this.mergeManager.setApplyEnabled(true);
                }
            }
        };
        this.latestRB = new JRadioButton(LATEST_BUTTON_NAME);
        this.latestRB.setName(LATEST_BUTTON_NAME);
        this.latestRB.addItemListener(listener);
        this.myRB = new JRadioButton(CHECKED_OUT_BUTTON_NAME);
        this.myRB.setName(CHECKED_OUT_BUTTON_NAME);
        this.myRB.addItemListener(listener);
        this.originalRB = new JRadioButton(ORIGINAL_BUTTON_NAME);
        this.originalRB.setName(ORIGINAL_BUTTON_NAME);
        this.originalRB.addItemListener(listener);
        this.buttonGroup.add(this.latestRB);
        this.buttonGroup.add(this.myRB);
        this.buttonGroup.add(this.originalRB);
        this.setLayout(new BoxLayout(this, 1));
        this.countPanel = new ConflictCountPanel();
        JPanel dtPanel = new JPanel();
        dtPanel.setLayout(new BoxLayout(dtPanel, 0));
        dtPanel.add(this.createSourceArchivePanel(this.latestRB));
        dtPanel.add(this.createSourceArchivePanel(this.myRB));
        dtPanel.add(this.createSourceArchivePanel(this.originalRB));
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        innerPanel.add(this.createInfoPanel());
        innerPanel.add(dtPanel);
        innerPanel.add(Box.createVerticalStrut(10));
        this.setLayout(new BorderLayout());
        this.add((Component)this.countPanel, "North");
        this.add((Component)innerPanel, "Center");
        this.add((Component)this.createUseForAllCheckBox(), "South");
    }

    private JPanel createSourceArchivePanel(JRadioButton rb) {
        JPanel panel = new JPanel(new BorderLayout());
        SourceArchivePanel archivePanel = new SourceArchivePanel();
        JScrollPane sp = new JScrollPane(archivePanel);
        sp.getViewport().setPreferredSize(new Dimension(300, 400));
        panel.add(sp);
        panel.add((Component)rb, "South");
        if (rb == this.latestRB) {
            this.latestPanel = archivePanel;
        } else if (rb == this.myRB) {
            this.myPanel = archivePanel;
        } else {
            this.origPanel = archivePanel;
        }
        return panel;
    }

    private JPanel createInfoPanel() {
        ImageIcon icon = ResourceManager.loadImage((String)"images/information.png");
        JLabel imageLabel = new JLabel(icon);
        MultiLineLabel label = new MultiLineLabel("A source archive change in your checked out version conflicts with a source archive change in the latest version.\nSelect the source archive you want included in the version that will result from this check-in.");
        JPanel labelPanel = new JPanel();
        labelPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
        BoxLayout bl = new BoxLayout(labelPanel, 0);
        labelPanel.setLayout(bl);
        labelPanel.add(Box.createHorizontalStrut(5));
        labelPanel.add(imageLabel);
        labelPanel.add(Box.createHorizontalStrut(5));
        labelPanel.add((Component)label);
        return labelPanel;
    }

    private JCheckBox createUseForAllCheckBox() {
        this.useForAllCB = new JCheckBox(this.getUseAllString("Source Archive"));
        this.useForAllCB.setName(USE_FOR_ALL_CHECKBOX);
        return this.useForAllCB;
    }

    private String getUseAllString(String conflictType) {
        return "Use the selected option for resolving all remaining '" + conflictType + "' conflicts.";
    }

    void setUseForAll(boolean useForAll) {
        this.useForAllCB.setSelected(useForAll);
    }

    boolean getUseForAll() {
        return this.useForAllCB.isSelected();
    }
}

