/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.archive;

import generic.io.JarReader;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.XmlDataReader;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import utilities.util.FileUtilities;

class ProjectJarReader
extends JarReader {
    private static final String PROJECT_FILE_SUFFIX = ProjectLocator.getProjectExtension();
    private static final String PROJECT_DIR_SUFFIX = ProjectLocator.getProjectDirExtension();
    private static final String XML_FILE_SUFFIX = ".xml";
    private static final String PROPERTIES_FILE_NAME = ".properties";
    private static final String ORIGINAL_PROPERTIES_FILE_NAME = "original.properties";
    private static final int READ_BLOCK_SIZE = 4096;
    private static final Pattern PROJECT_DATA_FILE_PATTERN = Pattern.compile(".+\\.rep/data(/.+)");

    ProjectJarReader(JarInputStream jarIn) {
        super(jarIn);
    }

    private static String filterDataPathsOnly(String path) {
        Matcher matcher = PROJECT_DATA_FILE_PATTERN.matcher(path = path.replace('\\', '/'));
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean createRecursively(XmlDataReader reader, File restoreDir, PluginTool tool, Project project, TaskMonitor monitor) throws IOException {
        boolean succeeded = true;
        StringBuffer errorBuf = new StringBuffer();
        ArrayList<String> xmlFiles = new ArrayList<String>();
        boolean done = false;
        while (!done && succeeded) {
            if (monitor.isCancelled()) {
                return false;
            }
            try {
                JarEntry entry = this.jarIn.getNextJarEntry();
                if (entry == null) {
                    done = true;
                    break;
                }
                String name = entry.getName();
                if (name.endsWith(".prp") || name.endsWith(ORIGINAL_PROPERTIES_FILE_NAME) || (name = ProjectJarReader.filterDataPathsOnly(name)) == null) continue;
                File file = new File(restoreDir, name);
                FileUtilities.mkdirs((File)file.getParentFile());
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(file);
                }
                catch (FileNotFoundException fnfe) {
                    String msg = fnfe.getMessage();
                    if (msg == null) {
                        msg = fnfe.toString();
                    }
                    Msg.showError((Object)((Object)this), null, (String)"Restore Failed", (Object)("Couldn't create file " + file.getAbsolutePath() + "\n" + msg));
                    return false;
                }
                byte[] bytes = new byte[4096];
                int numRead = 0;
                try {
                    while ((numRead = this.jarIn.read(bytes)) != -1) {
                        if (monitor.isCancelled()) {
                            break;
                        }
                        out.write(bytes, 0, numRead);
                    }
                }
                catch (IOException ioe) {
                    succeeded = false;
                    String msg = ioe.getMessage();
                    if (msg == null) {
                        msg = ioe.toString();
                    }
                    errorBuf.append("Couldn't create file " + file.getAbsolutePath() + "\n" + msg + "\n");
                    Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + ioe.getMessage()), (Throwable)ioe);
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException ioe) {
                        Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + ioe.getMessage()), (Throwable)ioe);
                    }
                }
                if (monitor.isCancelled()) {
                    return false;
                }
                if (!name.endsWith(XML_FILE_SUFFIX) || name.endsWith("projectDataTypes.xml")) continue;
                xmlFiles.add(name);
            }
            catch (IOException ioe) {
                succeeded = false;
                String msg = ioe.getMessage();
                if (msg == null) {
                    msg = ioe.toString();
                }
                errorBuf.append("Failed to restore archive entry.\n" + msg + "\n");
                done = true;
                break;
            }
        }
        for (int i = 0; i < xmlFiles.size(); ++i) {
            if (monitor.isCancelled()) {
                return false;
            }
            String relName = (String)xmlFiles.get(i);
            try {
                if (reader.addXMLObject(tool, restoreDir.getAbsolutePath(), relName, true, monitor) || monitor.isCancelled()) continue;
                succeeded = false;
                errorBuf.append("Couldn't restore " + relName + ".\n\n");
                continue;
            }
            catch (Exception e) {
                succeeded = false;
                String msg = e.getMessage();
                if (msg == null) {
                    msg = e.toString();
                }
                errorBuf.append("Couldn't restore " + relName + ".\n" + e.getMessage() + "\n");
            }
        }
        if (monitor.isCancelled()) {
            return false;
        }
        String summary = reader.getSummary();
        if (summary != null) {
            SystemUtilities.runSwingNow(() -> ProjectJarReader.showErrorDialog(null, "Please review the messages below:", summary));
        }
        if (!succeeded) {
            String message = errorBuf.toString();
            String title = "Error Restoring Project Archive";
            project.releaseFiles((Object)tool);
            Msg.showError((Object)((Object)this), null, (String)title, (Object)message);
        }
        return succeeded;
    }

    private static void showErrorDialog(Component parent, String title, String message) {
        if (message.indexOf("\n") >= 0) {
            ProjectJarReader.showMultiLineMessage(parent, title, message, 0);
        } else {
            ProjectJarReader.showSingleLineMessage(parent, title, message, 0);
        }
    }

    private static void showMultiLineMessage(Component parent, String title, String message, int type) {
        JTextArea textArea = new JTextArea(20, 60);
        textArea.setFont(new Font("Monospaced", 1, 12));
        textArea.setEditable(false);
        textArea.setText(message);
        textArea.setOpaque(false);
        JScrollPane scrollPane = new JScrollPane(textArea);
        JOptionPane.showMessageDialog(parent, scrollPane, title, type);
    }

    private static void showSingleLineMessage(Component parent, String title, String message, int type) {
        JLabel textLabel = new JLabel();
        textLabel.setText(message);
        JOptionPane.showMessageDialog(parent, textLabel, title, type);
    }

    private boolean replacePropertyFile(String filepath) {
        if (!((String)filepath).endsWith(ORIGINAL_PROPERTIES_FILE_NAME)) {
            return false;
        }
        File origFile = new File((String)filepath);
        int endOffset = ((String)filepath).length() - ORIGINAL_PROPERTIES_FILE_NAME.length();
        File newFile = new File((String)(filepath = ((String)filepath).substring(0, endOffset) + PROPERTIES_FILE_NAME));
        if (newFile.exists() && !newFile.delete()) {
            return false;
        }
        return origFile.renameTo(newFile);
    }

    private String modifyName(String name, String projectName) {
        if ((name = name.replace("\\", File.separator)).endsWith(PROJECT_FILE_SUFFIX)) {
            int start = name.lastIndexOf(File.separator);
            if (start == -1) {
                return projectName + PROJECT_FILE_SUFFIX;
            }
            String first = name.substring(0, start);
            return first + projectName + PROJECT_FILE_SUFFIX;
        }
        int suffixIndex = name.indexOf(PROJECT_DIR_SUFFIX);
        if (suffixIndex > -1) {
            String prefix = name.substring(0, suffixIndex);
            String suffix = name.substring(suffixIndex);
            int end = prefix.lastIndexOf(File.separator);
            if (end == -1) {
                return projectName + suffix;
            }
            return prefix.substring(0, end) + projectName + suffix;
        }
        return name;
    }
}

