/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.plugin.core.hover.AbstractConfigurableHover;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HTMLUtilities;
import javax.swing.JComponent;

public class ProgramAddressRelationshipListingHover
extends AbstractConfigurableHover
implements ListingHoverService {
    private static final String NAME = "Address Display";
    private static final String DESCRIPTION = "Shows the relationship between the hovered address and the base of memory and the containing memory block. For addresses in functions, the function offset is also shown; for addresses within a complex data (structure, array, etc.), the offset from the base of that data is shown.";
    private static final int PRIORITY = 20;

    public ProgramAddressRelationshipListingHover(PluginTool tool) {
        super(tool, 20);
    }

    @Override
    public void initializeOptions() {
        this.options = this.tool.getOptions("Listing Popups");
        this.options.registerOption(NAME, (Object)true, null, DESCRIPTION);
        this.setOptions((Options)this.options, NAME);
        this.options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    @Override
    public void setOptions(Options options, String optionName) {
        if (optionName.equals(NAME)) {
            this.enabled = options.getBoolean(NAME, true);
        }
    }

    @Override
    public JComponent getHoverComponent(Program program, ProgramLocation programLocation, FieldLocation fieldLocation, Field field) {
        if (!this.enabled || programLocation == null) {
            return null;
        }
        if (!(programLocation instanceof AddressFieldLocation)) {
            return null;
        }
        StringBuilder sb = new StringBuilder("<HTML><table>");
        Address loc = programLocation.getAddress();
        if (this.isInDefaultSpace(program, loc)) {
            long imagebaseOffset = loc.subtract(program.getImageBase());
            ProgramAddressRelationshipListingHover.appendTableRow(sb, "Imagebase Offset", null, imagebaseOffset);
        }
        MemoryBlock block = program.getMemory().getBlock(loc);
        long memblockOffset = loc.subtract(block.getStart());
        ProgramAddressRelationshipListingHover.appendTableRow(sb, "Memory Block Offset", block.getName(), memblockOffset);
        this.addFunctionInfo(program, loc, sb);
        this.addDataInfo(program, loc, sb);
        return this.createTooltipComponent(sb.toString());
    }

    private boolean isInDefaultSpace(Program p, Address a) {
        AddressFactory factory = p.getAddressFactory();
        AddressSpace defaultSpace = factory.getDefaultAddressSpace();
        return a.getAddressSpace().equals(defaultSpace);
    }

    private void addDataInfo(Program program, Address loc, StringBuilder sb) {
        String name;
        Data data = program.getListing().getDataContaining(loc);
        if (data == null) {
            return;
        }
        long dataOffset = loc.subtract(data.getAddress());
        if (dataOffset == 0L) {
            return;
        }
        String dataDescr = "Data Offset";
        if (data.getDataType() instanceof Structure) {
            dataDescr = "Structure Offset";
        }
        if ((name = data.getLabel()) == null) {
            name = data.getDataType().getName();
        }
        if (name == null) {
            name = HTMLUtilities.italic((String)"Unnamed");
        }
        ProgramAddressRelationshipListingHover.appendTableRow(sb, dataDescr, name, dataOffset);
    }

    private void addFunctionInfo(Program program, Address loc, StringBuilder sb) {
        Function function = program.getFunctionManager().getFunctionContaining(loc);
        if (function != null) {
            long functionOffset = loc.subtract(function.getEntryPoint());
            ProgramAddressRelationshipListingHover.appendTableRow(sb, "Function Offset", function.getName(), functionOffset);
        }
    }

    private static void appendTableRow(StringBuilder sb, String title, String reference, long offset) {
        sb.append("<tr><td>").append(HTMLUtilities.bold((String)title)).append("</td>");
        sb.append("<td style=\"text-align: right;\">");
        if (reference != null) {
            sb.append(HTMLUtilities.italic((String)reference)).append("&nbsp;");
        }
        sb.append(ProgramAddressRelationshipListingHover.formatOffset(offset));
        sb.append("</td></tr>");
    }

    private static String formatOffset(long offset) {
        return String.format("+%xh", offset);
    }
}

