/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.console;

import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.console.ConsoleComponentProvider;
import ghidra.app.services.ConsoleService;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="I/O Console", description="Displays an I/O console.", servicesProvided={ConsoleService.class}, eventsConsumed={ProgramLocationPluginEvent.class})
public class ConsolePlugin
extends ProgramPlugin {
    private ConsoleComponentProvider provider;

    public ConsolePlugin(PluginTool tool) {
        super(tool, false, false);
        this.provider = new ConsoleComponentProvider(tool, this.getName());
        this.registerServiceProvided(ConsoleService.class, this.provider);
    }

    protected void init() {
        super.init();
        this.provider.init();
    }

    protected void dispose() {
        super.dispose();
        this.provider.dispose();
    }

    @Override
    protected void programActivated(Program program) {
        this.provider.setCurrentProgram(program);
    }

    @Override
    protected void programDeactivated(Program program) {
        this.provider.setCurrentProgram(null);
    }

    @Override
    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof ProgramLocationPluginEvent) {
            ProgramLocationPluginEvent plpe = (ProgramLocationPluginEvent)event;
            ProgramLocation pl = plpe.getLocation();
            this.provider.setCurrentAddress(pl.getAddress());
        }
    }
}

