/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.editor;

import ghidra.app.plugin.core.compositeeditor.StructureEditorOptionManager;
import ghidra.app.plugin.core.compositeeditor.UnionEditorOptionManager;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.util.HelpLocation;

public class EditorOptionManager
implements OptionsChangeListener,
StructureEditorOptionManager,
UnionEditorOptionManager {
    private static final String STRUCTURE_EDITOR_NAME = "Structure Editor";
    private static final String UNION_EDITOR_NAME = "Union Editor";
    private static final String HEX_STRUCT_NUMBERS_OPTION_NAME = "Structure Editor.Show Numbers In Hex";
    private static final String HEX_UNION_NUMBERS_OPTION_NAME = "Union Editor.Show Numbers In Hex";
    private Plugin plugin;
    private boolean showStructureNumbersInHex = false;
    private boolean showUnionNumbersInHex = false;
    private String HELP_TOPIC = "DataTypeEditors";

    public EditorOptionManager(Plugin plugin) {
        this.plugin = plugin;
        this.initializeOptions();
    }

    private void initializeOptions() {
        HelpLocation help = new HelpLocation(this.HELP_TOPIC, "StructureEditorToolOptions");
        ToolOptions options = this.plugin.getTool().getOptions("Editors");
        options.setOptionsHelpLocation(help);
        options.getOptions(STRUCTURE_EDITOR_NAME).setOptionsHelpLocation(help);
        options.getOptions(UNION_EDITOR_NAME).setOptionsHelpLocation(help);
        options.registerOption(HEX_STRUCT_NUMBERS_OPTION_NAME, (Object)this.showStructureNumbersInHex, help, "Toggle for whether numeric values in the Structure Editor should be displayed in hexadecimal or decimal when you initially begin editing a structure.");
        options.registerOption(HEX_UNION_NUMBERS_OPTION_NAME, (Object)this.showUnionNumbersInHex, help, "Toggle for whether numeric values in the Union Editor should be displayed in hexadecimal or decimal when you initially begin editing a union.");
        this.setOptions((Options)options);
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
        this.setOptions((Options)options);
    }

    private void setOptions(Options options) {
        this.showStructureNumbersInHex = options.getBoolean(HEX_STRUCT_NUMBERS_OPTION_NAME, this.showStructureNumbersInHex);
        this.showUnionNumbersInHex = options.getBoolean(HEX_UNION_NUMBERS_OPTION_NAME, this.showUnionNumbersInHex);
    }

    @Override
    public boolean showStructureNumbersInHex() {
        return this.showStructureNumbersInHex;
    }

    @Override
    public boolean showUnionNumbersInHex() {
        return this.showUnionNumbersInHex;
    }

    public void dispose() {
        ToolOptions options = this.plugin.getTool().getOptions("Editors");
        options.removeOptionsChangeListener((OptionsChangeListener)this);
    }
}

