/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.editor;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.ActionContextProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.options.editor.FontPropertyEditor;
import docking.util.KeyBindingUtils;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.app.plugin.core.editor.TextEditorManagerPlugin;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.datastruct.FixedSizeStack;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.undo.UndoableEdit;
import resources.ResourceManager;

public class TextEditorComponentProvider
extends ComponentProviderAdapter {
    private static final String TITLE = "Text Editor";
    private static final int MAX_UNDO_REDO_SIZE = 50;
    static Font defaultFont = new Font("monospaced", 0, 12);
    private TextEditorManagerPlugin plugin;
    private GhidraFileChooser chooser;
    private File textFile;
    private String textFileName;
    private DockingAction saveAction;
    private DockingAction saveAsAction;
    private DockingAction undoAction;
    private DockingAction redoAction;
    private DockingAction fontAction;
    private JTextArea textarea;
    private JScrollPane scrollpane;
    private boolean isChanged = false;
    private String title;
    private FixedSizeStack<UndoableEdit> undoStack = new FixedSizeStack(50);
    private FixedSizeStack<UndoableEdit> redoStack = new FixedSizeStack(50);

    static void restoreState(SaveState saveState) {
        String name = saveState.getString("DEFAULT_FONT_NAME", "Monospaced");
        int style = saveState.getInt("DEFAULT_FONT_STYLE", 0);
        int size = saveState.getInt("DEFAULT_FONT_SIZE", 12);
        defaultFont = new Font(name, style, size);
    }

    static void saveState(SaveState saveState) {
        saveState.putString("DEFAULT_FONT_NAME", defaultFont.getName());
        saveState.putInt("DEFAULT_FONT_STYLE", defaultFont.getStyle());
        saveState.putInt("DEFAULT_FONT_SIZE", defaultFont.getSize());
    }

    TextEditorComponentProvider(TextEditorManagerPlugin plugin, String textFileName, InputStream inputStream) throws IOException {
        super(plugin.getTool(), TITLE, plugin.getName());
        this.textFileName = textFileName;
        String textContents = this.loadTextFile(inputStream);
        this.initialize(plugin, textContents);
    }

    public String getText() {
        return this.textarea.getText();
    }

    private void initialize(TextEditorManagerPlugin plugin, String textContents) {
        this.plugin = plugin;
        this.setHelpLocation(new HelpLocation(plugin.getName(), plugin.getName()));
        this.title = this.textFileName + (this.isReadOnly() ? " (Read-Only) " : "");
        this.setTitle(this.title);
        this.textarea = new KeyMasterTextArea(textContents);
        this.scrollpane = new JScrollPane(this.textarea);
        this.scrollpane.setPreferredSize(new Dimension(400, 400));
        this.addToTool();
        this.setVisible(true);
        plugin.getTool().setStatusInfo("Press F1 for help.");
        this.createActions();
    }

    private boolean isReadOnly() {
        return this.textFile != null;
    }

    private void clearUndoRedoStack() {
        this.undoStack.clear();
        this.redoStack.clear();
        this.updateUndoRedoAction();
    }

    private void updateUndoRedoAction() {
        this.undoAction.setEnabled(!this.undoStack.isEmpty());
        this.redoAction.setEnabled(!this.redoStack.isEmpty());
    }

    private void undo() {
        UndoableEdit item = (UndoableEdit)this.undoStack.pop();
        this.redoStack.push((Object)item);
        item.undo();
        this.updateUndoRedoAction();
    }

    private void redo() {
        UndoableEdit item = (UndoableEdit)this.redoStack.pop();
        this.undoStack.push((Object)item);
        item.redo();
        this.updateUndoRedoAction();
    }

    boolean isChanged() {
        return this.isChanged;
    }

    private void setChanged(boolean changed) {
        if (this.isChanged == changed) {
            return;
        }
        if (!changed) {
            this.clearUndoRedoStack();
        }
        this.isChanged = changed;
        if (this.saveAction != null && !this.isReadOnly()) {
            this.saveAction.setEnabled(this.isChanged);
        }
        if (this.isChanged) {
            this.setTitle("*" + this.title);
        } else {
            this.setTitle(this.title);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadTextFile(InputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String string = this.loadTextFile(reader);
            return string;
        }
    }

    private String loadTextFile(BufferedReader reader) throws IOException {
        String line;
        StringBuffer buffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
            buffer.append('\n');
        }
        return buffer.toString();
    }

    private void createActions() {
        this.undoAction = new DockingAction("Undo", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                TextEditorComponentProvider.this.undo();
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject == TextEditorComponentProvider.this;
            }
        };
        this.undoAction.setDescription("Undo");
        this.undoAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/undo.png"), "UndoRedo"));
        this.undoAction.setEnabled(false);
        this.plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)this.undoAction);
        this.redoAction = new DockingAction("Redo", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                TextEditorComponentProvider.this.redo();
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject == TextEditorComponentProvider.this;
            }
        };
        this.redoAction.setDescription("Redo");
        this.redoAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/redo.png"), "UndoRedo"));
        this.redoAction.setEnabled(false);
        this.plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)this.redoAction);
        this.saveAction = new DockingAction("Save File", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                TextEditorComponentProvider.this.save();
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject == TextEditorComponentProvider.this;
            }
        };
        this.saveAction.setDescription("Save");
        this.saveAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/disk.png"), "Save"));
        this.saveAction.setEnabled(false);
        this.plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)this.saveAction);
        this.saveAsAction = new DockingAction("Save File As", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                TextEditorComponentProvider.this.saveAs();
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject == TextEditorComponentProvider.this;
            }
        };
        this.saveAsAction.setDescription("Save As...");
        this.saveAsAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/disk_save_as.png"), "Save"));
        this.saveAsAction.setEnabled(true);
        this.plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)this.saveAsAction);
        this.fontAction = new DockingAction("Select Font", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                TextEditorComponentProvider.this.doSelectFont();
            }
        };
        this.fontAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/text_lowercase.png"), "ZZFont"));
        this.fontAction.setDescription("Select Font");
        this.fontAction.setEnabled(true);
        this.plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)this.fontAction);
        ActionContextProvider acp = e -> {
            TextEditorComponentProvider p = this;
            TextEditorComponentProvider context = this;
            return new ActionContext((ComponentProvider)p, (Object)context);
        };
        KeyBindingUtils.registerAction((JComponent)this.textarea, (DockingAction)this.saveAction, (ActionContextProvider)acp);
        KeyBindingUtils.registerAction((JComponent)this.textarea, (DockingAction)this.redoAction, (ActionContextProvider)acp);
        KeyBindingUtils.registerAction((JComponent)this.textarea, (DockingAction)this.undoAction, (ActionContextProvider)acp);
    }

    protected void doSelectFont() {
        FontPropertyEditor editor = new FontPropertyEditor();
        editor.setValue((Object)defaultFont);
        editor.showDialog();
        defaultFont = (Font)editor.getValue();
        List<TextEditorComponentProvider> values = this.plugin.getEditors();
        for (TextEditorComponentProvider editorComponent : values) {
            editorComponent.textarea.setFont(defaultFont);
        }
    }

    private void save() {
        String text = this.textarea.getText();
        if (this.textFile == null) {
            this.saveAs();
        } else {
            try {
                PrintWriter writer = new PrintWriter(new FileWriter(this.textFile));
                writer.print(text);
                writer.close();
                this.setChanged(false);
            }
            catch (IOException e) {
                if (this.textFile.canWrite()) {
                    Msg.showError(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Error saving file", (Object)e.getMessage());
                }
                Msg.showError(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Error Saving File", (Object)"The file is not writable.");
            }
        }
    }

    private void saveAs() {
        int result;
        File saveAsFile;
        if (this.chooser == null) {
            this.chooser = new GhidraFileChooser((Component)this.getComponent());
        }
        if ((saveAsFile = this.chooser.getSelectedFile()) == null) {
            return;
        }
        boolean exists = saveAsFile.exists();
        if (exists && (result = OptionDialog.showYesNoDialog((Component)this.getComponent(), (String)this.getName(), (String)("Do you want to OVERWRITE the following file:\n" + saveAsFile.getName()))) != 1) {
            return;
        }
        try {
            String str = this.textarea.getText();
            PrintWriter writer = new PrintWriter(new FileWriter(saveAsFile));
            writer.print(str);
            writer.close();
            this.saveAction.setEnabled(false);
            this.textFile = saveAsFile;
            this.title = saveAsFile.getName();
            this.setChanged(false);
        }
        catch (IOException e) {
            Msg.showError(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Error Saving File As...", (Object)e.getMessage());
        }
    }

    public void closeComponent() {
        if (this.plugin.removeTextFile(this, this.textFileName)) {
            this.clearUndoRedoStack();
            this.plugin.getTool().removeComponentProvider((ComponentProvider)this);
        }
    }

    public ActionContext getActionContext(MouseEvent event) {
        return new ActionContext((ComponentProvider)this, (Object)this);
    }

    public JComponent getComponent() {
        return this.scrollpane;
    }

    private class KeyMasterTextArea
    extends JTextArea {
        private static final long serialVersionUID = 1L;

        private KeyMasterTextArea(String text) {
            super(text);
            this.setFont(defaultFont);
            this.setName("EDITOR");
            this.setWrapStyleWord(false);
            Document document = this.getDocument();
            document.addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    TextEditorComponentProvider.this.setChanged(true);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    TextEditorComponentProvider.this.setChanged(true);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    TextEditorComponentProvider.this.setChanged(true);
                }
            });
            document.addUndoableEditListener(e -> {
                UndoableEdit item = e.getEdit();
                TextEditorComponentProvider.this.undoStack.push((Object)item);
                TextEditorComponentProvider.this.redoStack.clear();
                TextEditorComponentProvider.this.updateUndoRedoAction();
            });
            this.setCaretPosition(0);
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            InputMap map = this.getInputMap(condition);
            ActionMap am = this.getActionMap();
            if (map != null && am != null && this.isEnabled()) {
                Action action;
                Object binding = map.get(ks);
                Action action2 = action = binding == null ? null : am.get(binding);
                if (action != null) {
                    if (!action.isEnabled()) {
                        e.consume();
                        return true;
                    }
                    return SwingUtilities.notifyAction(action, ks, e, this, e.getModifiers());
                }
            }
            return false;
        }
    }
}

