/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.fallthrough;

import docking.DialogComponentProvider;
import docking.ToolTipManager;
import ghidra.app.plugin.core.fallthrough.FallThroughModel;
import ghidra.app.plugin.core.fallthrough.FallThroughPlugin;
import ghidra.app.util.AddressInput;
import ghidra.program.model.address.Address;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import resources.ResourceManager;

class FallThroughDialog
extends DialogComponentProvider
implements ChangeListener {
    private JLabel addressLabel;
    private JLabel instLabel;
    private JButton homeButton;
    private FallThroughPlugin plugin;
    private FallThroughModel model;
    private AddressInput addrField;
    private JRadioButton defaultRB;
    private JRadioButton userRB;
    private boolean changing;

    FallThroughDialog(FallThroughPlugin plugin, FallThroughModel model) {
        super("Set Fallthrough Address", true);
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Set Fallthrough"));
        this.plugin = plugin;
        this.model = model;
        this.addWorkPanel(this.create());
        this.addOKButton();
        this.addApplyButton();
        this.addCancelButton();
        this.updateState();
        model.setChangeListener(this);
    }

    protected void applyCallback() {
        this.model.execute();
    }

    protected void cancelCallback() {
        this.close();
    }

    protected void okCallback() {
        if (this.model.execute()) {
            this.cancelCallback();
        }
    }

    public void updateState() {
        String msg;
        Address addr = this.model.getAddress();
        if (addr == null) {
            this.cancelCallback();
            return;
        }
        this.changing = true;
        this.addressLabel.setText(addr.toString());
        this.instLabel.setText(this.model.getInstructionRepresentation());
        if (this.model.isDefaultFallthrough()) {
            this.defaultRB.setSelected(true);
        } else if (this.model.isUserDefinedFallthrough()) {
            this.userRB.setSelected(true);
        }
        Address ftAddr = this.model.getCurrentFallthrough();
        if (ftAddr != null) {
            if (!ftAddr.equals((Object)this.addrField.getAddress())) {
                this.addrField.setAddress(ftAddr);
            }
        } else {
            this.addrField.clear();
        }
        boolean enabled = this.model.allowAddressEdits();
        this.addrField.setEnabled(enabled);
        this.changing = false;
        if (this.model.isValidInput()) {
            this.setOkEnabled(true);
            this.setApplyEnabled(true);
        }
        if ((msg = this.model.getMessage()) != null) {
            this.setStatusText(msg);
        }
    }

    private void addressChanged() {
        if (this.changing) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Address addr = FallThroughDialog.this.addrField.getAddress();
                if (addr != null || FallThroughDialog.this.addrField.getValue().length() == 0) {
                    FallThroughDialog.this.model.setCurrentFallthrough(addr);
                } else {
                    FallThroughDialog.this.setStatusText("Invalid Address");
                    FallThroughDialog.this.setOkEnabled(false);
                    FallThroughDialog.this.setApplyEnabled(false);
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    private JPanel create() {
        JPanel panel = new JPanel(new BorderLayout(0, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.addrField = new AddressInput();
        this.addrField.setAddressFactory(this.model.getProgram().getAddressFactory());
        this.addrField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FallThroughDialog.this.addressChanged();
            }
        });
        this.addrField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FallThroughDialog.this.model.setCurrentFallthrough(FallThroughDialog.this.addrField.getAddress());
            }
        });
        panel.add((Component)this.createHomePanel(), "North");
        panel.add((Component)this.createAddressPanel(), "Center");
        return panel;
    }

    private JPanel createAddressPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Fallthrough Address"));
        panel.add((Component)this.addrField, "North");
        panel.add((Component)this.createRadioButtonPanel(), "Center");
        return panel;
    }

    private JPanel createHomePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder("Home"));
        this.addressLabel = new JLabel("01001000");
        Font font = this.addressLabel.getFont();
        Font monoFont = new Font("monospaced", font.getStyle(), font.getSize());
        this.addressLabel.setFont(monoFont);
        this.instLabel = new JLabel("jmp DAT_01001000");
        this.instLabel.setFont(monoFont);
        this.homeButton = this.createButton("images/go-home.png", "Home");
        this.homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FallThroughDialog.this.plugin.goTo(FallThroughDialog.this.model.getAddress());
            }
        });
        JPanel innerPanel = new JPanel();
        BoxLayout bl = new BoxLayout(innerPanel, 0);
        innerPanel.setLayout(bl);
        innerPanel.add(Box.createHorizontalStrut(5));
        innerPanel.add(this.homeButton);
        innerPanel.add(Box.createHorizontalStrut(10));
        innerPanel.add(this.addressLabel);
        innerPanel.add(Box.createHorizontalStrut(20));
        innerPanel.add(this.instLabel);
        innerPanel.add(Box.createHorizontalStrut(10));
        panel.add((Component)innerPanel, "Center");
        return panel;
    }

    private JPanel createRadioButtonPanel() {
        JPanel panel = new JPanel();
        BoxLayout bl = new BoxLayout(panel, 0);
        panel.setLayout(bl);
        ButtonGroup group = new ButtonGroup();
        this.defaultRB = new JRadioButton("Default", true);
        this.defaultRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                FallThroughDialog.this.model.defaultSelected();
            }
        });
        ToolTipManager.setToolTipText((JComponent)this.defaultRB, (String)"Use default fallthrough address");
        this.userRB = new JRadioButton("User", false);
        this.userRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                FallThroughDialog.this.model.userSelected();
            }
        });
        ToolTipManager.setToolTipText((JComponent)this.userRB, (String)"Override default fallthrough address");
        group.add(this.defaultRB);
        group.add(this.userRB);
        panel.add(this.defaultRB);
        panel.add(this.userRB);
        JPanel outerPanel = new JPanel(new FlowLayout(1));
        outerPanel.add(panel);
        return outerPanel;
    }

    private JButton createButton(String filename, String altText) {
        JButton button = new JButton();
        URL imageURL = ResourceManager.getResource((String)filename);
        if (imageURL != null) {
            ImageIcon icon = new ImageIcon(imageURL);
            button = new JButton(icon);
            Insets noInsets = new Insets(0, 0, 0, 0);
            button.setMargin(noInsets);
        } else {
            button = new JButton(altText);
        }
        ToolTipManager.setToolTipText((JComponent)button, (String)"Go back to home address");
        return button;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateState();
    }
}

