/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch.ui;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.instructionsearch.InstructionSearchPlugin;
import ghidra.app.plugin.core.instructionsearch.model.InstructionMetadata;
import ghidra.app.plugin.core.instructionsearch.model.InstructionSearchData;
import ghidra.app.plugin.core.instructionsearch.ui.ControlPanel;
import ghidra.app.plugin.core.instructionsearch.ui.InstructionSearchMainPanel;
import ghidra.app.plugin.core.instructionsearch.ui.InstructionTablePanel;
import ghidra.app.plugin.core.instructionsearch.ui.MessagePanel;
import ghidra.app.plugin.core.instructionsearch.ui.PreviewTablePanel;
import ghidra.app.plugin.core.instructionsearch.ui.SearchAllInstructionsTask;
import ghidra.app.plugin.core.instructionsearch.ui.SearchInstructionsTask;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.services.GoToService;
import ghidra.app.util.query.TableService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.table.AddressArrayTableModel;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class InstructionSearchDialog
extends DialogComponentProvider
implements Observer {
    private InstructionSearchMainPanel tablePanel;
    private ControlPanel controlPanel;
    private MessagePanel messagePanel;
    private InstructionSearchPlugin plugin;
    private JButton searchAllButton;
    protected InstructionSearchData searchData;

    public InstructionSearchDialog(InstructionSearchPlugin plugin, String title, TaskMonitor taskMonitor) {
        super(title, false, true, true, true);
        this.plugin = plugin;
        this.messagePanel = new MessagePanel();
        this.setHelpLocation(new HelpLocation("Search", "Instruction_Pattern_Search"));
        this.searchData = new InstructionSearchData();
        this.searchData.addObserver(this);
        try {
            this.revalidate();
            this.loadInstructions(plugin);
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)("Error loading instructions: " + e));
        }
    }

    public InstructionSearchData getSearchData() {
        return this.searchData;
    }

    public void loadInstructions(InstructionSearchPlugin plugin) throws InvalidInputException {
        this.loadInstructions(plugin.getProgramSelection(), plugin);
    }

    public void loadInstructions(ProgramSelection selection, InstructionSearchPlugin plugin) throws InvalidInputException {
        if (selection == null && this.getMessagePanel() != null) {
            this.getMessagePanel().setMessageText("Select instructions from the listing (and hit reload) to populate the table.", Color.BLUE);
        }
        if (selection != null && plugin.isSelectionValid(selection, this)) {
            if (this.getControlPanel() != null) {
                this.getControlPanel().getRangeWidget().updateSearchRangeBySelection();
            }
            this.populateSearchData(plugin.getCurrentProgram(), selection);
        }
    }

    public void populateSearchData(Program currentProgram, ProgramSelection selection) {
        if (selection == null || currentProgram == null) {
            return;
        }
        try {
            this.getSearchData().load(currentProgram, selection.getFirstRange());
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)"Error loading new search data", (Throwable)e);
        }
    }

    public ControlPanel getControlPanel() {
        return this.controlPanel;
    }

    public MessagePanel getMessagePanel() {
        return this.messagePanel;
    }

    public InstructionTablePanel getTablePanel() {
        if (this.tablePanel != null) {
            return this.tablePanel.getInstructionTablePanel();
        }
        return null;
    }

    public PreviewTablePanel getPreviewTablePanel() {
        if (this.tablePanel != null) {
            return this.tablePanel.getPreviewTablePanel();
        }
        return null;
    }

    public void showDialog(ComponentProvider provider) {
        this.clearStatusText();
        PluginTool tool = this.plugin.getTool();
        tool.showDialog((DialogComponentProvider)this, provider);
    }

    public void loadBytes(String bytes) {
        this.tablePanel.getInstructionTable().getInsertBytesWidget().loadBytes(bytes);
    }

    public void loadBytes(AddressSet addrSet) {
        ProgramSelection selection = new ProgramSelection(addrSet.getMinAddress(), addrSet.getMaxAddress());
        this.plugin.firePluginEvent(new ProgramSelectionPluginEvent(this.plugin.getName(), selection, this.plugin.getCurrentProgram()));
        SwingUtilities.invokeLater(() -> {
            this.goToLocation(selection.getMinAddress());
            try {
                this.loadInstructions(selection, this.plugin);
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)"Error loading instructions", (Throwable)e);
            }
        });
    }

    public void clearMessage() {
        if (this.messagePanel == null) {
            return;
        }
        this.messagePanel.clear();
    }

    public void clear() {
        this.getSearchData().clearAndReload();
    }

    public void displayMessage(String message, Color status) {
        if (this.messagePanel == null) {
            return;
        }
        this.messagePanel.setMessageText(message, status);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof InstructionSearchData.UpdateType) {
            InstructionSearchData.UpdateType type = (InstructionSearchData.UpdateType)((Object)arg);
            switch (type) {
                case RELOAD: {
                    try {
                        this.revalidate();
                    }
                    catch (InvalidInputException e) {
                        Msg.error((Object)this, (Object)"Error loading instructions", (Throwable)e);
                    }
                    break;
                }
                case UPDATE: {
                    try {
                        this.tablePanel.buildPreview();
                        break;
                    }
                    catch (InvalidInputException e) {
                        Msg.error((Object)this, (Object)"Error updating instructions", (Throwable)e);
                    }
                }
            }
        }
    }

    protected void revalidate() throws InvalidInputException {
        this.removeExistingGuiComponents();
        this.createGuiComponents();
    }

    protected void applyCallback() {
        this.searchButtonActionPerformed();
    }

    protected JPanel createWorkPanel() throws InvalidInputException {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        this.tablePanel = new InstructionSearchMainPanel(this.plugin, this);
        mainPanel.add((Component)this.tablePanel, "Center");
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new BoxLayout(lowerPanel, 1));
        if (this.controlPanel == null) {
            this.controlPanel = new ControlPanel(this.plugin, this);
        }
        lowerPanel.add(this.controlPanel);
        lowerPanel.add(this.messagePanel);
        mainPanel.add((Component)lowerPanel, "South");
        return mainPanel;
    }

    private void createGuiComponents() throws InvalidInputException {
        this.addWorkPanel(this.createWorkPanel());
        this.createButtons();
        if (this.tablePanel == null) {
            return;
        }
        this.tablePanel.buildPreview();
        this.tablePanel.revalidate();
        if (this.applyButton == null || this.searchAllButton == null) {
            return;
        }
        this.applyButton.setEnabled(this.tablePanel.getPreviewTable().getRowCount() > 0);
        this.searchAllButton.setEnabled(this.tablePanel.getPreviewTable().getRowCount() > 0);
    }

    private void removeExistingGuiComponents() {
        this.removeWorkPanel();
        if (this.applyButton != null) {
            this.removeButton(this.applyButton);
        }
        if (this.cancelButton != null) {
            this.removeButton(this.cancelButton);
        }
        if (this.searchAllButton != null) {
            this.removeButton(this.searchAllButton);
        }
    }

    private void createButtons() {
        this.addApplyButton();
        this.applyButton.setText("Search");
        this.searchAllButton = new JButton("Search All");
        this.searchAllButton.addActionListener(ev -> this.searchAllButtonActionPerformed());
        this.searchAllButton.setName("Search All");
        this.addButton(this.searchAllButton);
        this.addCancelButton();
    }

    private void searchButtonActionPerformed() {
        this.messagePanel.clear();
        SearchInstructionsTask searchTask = new SearchInstructionsTask(this, this.plugin);
        new TaskLauncher((Task)searchTask, this.getFocusComponent());
    }

    private void searchAllButtonActionPerformed() {
        if (this.messagePanel == null || this.tablePanel == null || this.plugin == null) {
            return;
        }
        this.messagePanel.clear();
        this.searchData.applyMasks(this.tablePanel.getInstructionTable());
        SearchAllInstructionsTask searchTask = new SearchAllInstructionsTask(this, this.plugin);
        new TaskLauncher((Task)searchTask, this.getFocusComponent());
    }

    public void displaySearchResults(List<InstructionMetadata> searchResults) {
        Address[] tableArray = new Address[searchResults.size()];
        for (int x = 0; x < searchResults.size(); ++x) {
            tableArray[x] = searchResults.get(x).getAddr();
        }
        TableService ts = (TableService)this.plugin.getTool().getService(TableService.class);
        if (ts == null) {
            Msg.error(null, (Object)"Unable to show addresses, no table service available");
        } else {
            int matchSize = 1;
            if (this.searchData.getValueString().length() % 8 == 0) {
                matchSize = this.searchData.getValueString().length() / 8;
            }
            this.show("Addresses", ts, tableArray, matchSize);
        }
    }

    private void show(String title, TableService table, Address[] addresses, int matchSize) {
        Runnable runnable = () -> {
            AddressArrayTableModel model = new AddressArrayTableModel("Instruction Pattern Search", (ServiceProvider)this.plugin.getTool(), this.plugin.getCurrentProgram(), addresses);
            model.setSelectionSize(matchSize);
            TableComponentProvider<Address> tableProvider = table.showTableWithMarkers(title + " " + model.getName(), "InstructionSearch", model, Color.GREEN, null, "Instruction Search Results", null);
            tableProvider.installRemoveItemsAction();
        };
        SystemUtilities.runSwingLater((Runnable)runnable);
    }

    private void goToLocation(Address addr) {
        GoToService gs = (GoToService)this.plugin.getTool().getService(GoToService.class);
        gs.goTo(addr);
    }
}

