/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.memory;

import docking.DialogComponentProvider;
import docking.widgets.combobox.GhidraComboBox;
import ghidra.app.plugin.core.memory.AddBlockModel;
import ghidra.app.plugin.core.misc.RegisterField;
import ghidra.app.util.AddressInput;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.util.HelpLocation;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class AddBlockDialog
extends DialogComponentProvider
implements ChangeListener {
    private JTextField nameField;
    private AddressInput addrField;
    private RegisterField lengthField;
    private JTextField commentField;
    private JPanel viewPanel;
    private CardLayout cardLayout;
    private JPanel initializedPanel;
    private JPanel bottomPanel;
    private JRadioButton initializedRB;
    private JRadioButton uninitializedRB;
    private JCheckBox readCB;
    private JCheckBox writeCB;
    private JCheckBox executeCB;
    private JCheckBox volatileCB;
    private RegisterField initialValueField;
    private JLabel initialValueLabel;
    private AddressFactory addrFactory;
    private AddressInput baseAddrField;
    private Address baseAddress;
    private AddBlockModel model;
    private GhidraComboBox<MemoryBlockType> comboBox;
    private boolean updatingInitializedRB;
    private static final String MAPPED = "Mapped";
    private static final String OTHER = "Other";

    AddBlockDialog(AddBlockModel model) {
        super("Add Memory Block", true, true, true, false);
        this.init(model);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setStatusText(this.model.getMessage());
        this.setOkEnabled(this.model.isValidInfo());
        this.readCB.setEnabled(this.model.isReadEnabled());
        this.writeCB.setEnabled(this.model.isWriteEnabled());
        this.executeCB.setEnabled(this.model.isExecuteEnabled());
        this.volatileCB.setEnabled(this.model.isVolatileEnabled());
        if (this.initializedRB != null) {
            this.updatingInitializedRB = true;
            try {
                this.initializedRB.setSelected(this.model.getInitializedState());
            }
            finally {
                this.updatingInitializedRB = false;
            }
        }
    }

    private void init(AddBlockModel blockModel) {
        this.model = blockModel;
        blockModel.setChangeListener(this);
        this.create();
        this.setHelpLocation(new HelpLocation("MemoryMapPlugin", "Add Block"));
    }

    private void create() {
        this.cardLayout = new CardLayout();
        this.viewPanel = new JPanel(this.cardLayout);
        this.nameField = new JTextField();
        this.nameField.setName("Block Name");
        this.addrField = new AddressInput();
        this.addrField.setName("Start Addr");
        this.lengthField = new RegisterField(32, null, false);
        this.lengthField.setName("Length");
        this.commentField = new JTextField();
        this.commentField.setName("Comment");
        this.addrFactory = this.model.getProgram().getAddressFactory();
        this.addrField.setAddressFactory(this.addrFactory, true);
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddBlockDialog.this.nameChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddBlockDialog.this.nameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddBlockDialog.this.nameChanged();
            }
        });
        this.lengthField.setChangeListener(e -> this.lengthChanged());
        this.addrField.addChangeListener(ev -> this.addrChanged());
        JLabel readLabel = new JLabel("Read");
        this.readCB = new JCheckBox();
        this.readCB.setName("Read");
        JLabel writeLabel = new JLabel("Write");
        this.writeCB = new JCheckBox();
        this.writeCB.setName("Write");
        JLabel executeLabel = new JLabel("Execute");
        this.executeCB = new JCheckBox();
        this.executeCB.setName("Execute");
        JLabel volatileLabel = new JLabel("Volatile");
        this.volatileCB = new JCheckBox();
        this.volatileCB.setName("Volatile");
        JPanel topPanel = new JPanel((LayoutManager)new PairLayout(4, 10, 150));
        topPanel.setBorder(BorderFactory.createEmptyBorder(5, 7, 4, 5));
        topPanel.add(new JLabel("Block Name:", 4));
        topPanel.add(this.nameField);
        topPanel.add(new JLabel("Start Addr:", 4));
        topPanel.add(this.addrField);
        topPanel.add(new JLabel("Length:", 4));
        topPanel.add(this.lengthField);
        topPanel.add(new JLabel("Comment:", 4));
        topPanel.add(this.commentField);
        JPanel execPanel = new JPanel();
        BoxLayout bl = new BoxLayout(execPanel, 0);
        execPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        execPanel.setLayout(bl);
        execPanel.add(Box.createHorizontalStrut(10));
        execPanel.add(readLabel);
        execPanel.add(this.readCB);
        execPanel.add(Box.createHorizontalStrut(10));
        execPanel.add(writeLabel);
        execPanel.add(this.writeCB);
        execPanel.add(Box.createHorizontalStrut(10));
        execPanel.add(executeLabel);
        execPanel.add(this.executeCB);
        execPanel.add(Box.createHorizontalStrut(10));
        execPanel.add(volatileLabel);
        execPanel.add(this.volatileCB);
        JPanel panel = new JPanel();
        panel.add(execPanel);
        JPanel outerTopPanel = new JPanel(new BorderLayout());
        outerTopPanel.add((Component)topPanel, "North");
        outerTopPanel.add((Component)panel, "Center");
        this.bottomPanel = new JPanel();
        BoxLayout layout = new BoxLayout(this.bottomPanel, 1);
        this.bottomPanel.setLayout(layout);
        this.bottomPanel.setBorder(BorderFactory.createEmptyBorder(0, 7, 4, 5));
        this.bottomPanel.add(this.createComboBoxPanel());
        this.bottomPanel.add(this.viewPanel);
        JPanel mainPanel = new JPanel();
        layout = new BoxLayout(mainPanel, 1);
        mainPanel.setLayout(layout);
        mainPanel.add(outerTopPanel);
        mainPanel.add(this.bottomPanel);
        mainPanel.validate();
        JPanel mainPanel2 = new JPanel(new BorderLayout());
        mainPanel2.add((Component)mainPanel, "North");
        mainPanel2.add((Component)new JPanel(), "Center");
        this.createCardPanels();
        this.addWorkPanel(mainPanel2);
        this.addOKButton();
        this.addCancelButton();
    }

    void showDialog(PluginTool tool) {
        this.nameField.setText("");
        this.addrField.setAddress(this.model.getStartAddress());
        this.lengthField.setValue(new Long(0L));
        this.model.setLength(0);
        this.commentField.setText("");
        this.readCB.setSelected(true);
        this.writeCB.setSelected(true);
        this.executeCB.setSelected(false);
        this.volatileCB.setSelected(false);
        this.initialValueField.setValue(new Long(0L));
        this.model.setBlockType(MemoryBlockType.DEFAULT);
        this.model.setIsInitialized(this.initializedRB.isSelected());
        this.model.setInitialValue(0);
        this.setOkEnabled(false);
        tool.showDialog((DialogComponentProvider)this, tool.getComponentProvider("Memory Map"));
    }

    public void dispose() {
        this.close();
        this.model.dispose();
    }

    protected void okCallback() {
        if (this.model.execute(this.commentField.getText(), this.readCB.isSelected(), this.writeCB.isSelected(), this.executeCB.isSelected(), this.volatileCB.isSelected())) {
            this.close();
        } else {
            this.setStatusText(this.model.getMessage());
            this.setOkEnabled(false);
        }
    }

    private void initializeRBChanged() {
        if (this.updatingInitializedRB) {
            return;
        }
        boolean selected = this.initializedRB.isSelected();
        this.model.setIsInitialized(selected);
        this.initialValueField.setEnabled(selected);
        this.initialValueLabel.setEnabled(selected);
        if (!selected) {
            this.initialValueField.setValue(new Long(0L));
            this.model.setInitialValue(0);
        }
    }

    private void uninitializedRBChanged() {
        if (this.updatingInitializedRB) {
            return;
        }
        boolean selected = this.uninitializedRB.isSelected();
        this.model.setIsInitialized(!selected);
        this.initialValueField.setEnabled(!selected);
        this.initialValueLabel.setEnabled(!selected);
        if (!selected) {
            this.initialValueField.setValue(new Long(0L));
            this.model.setInitialValue(0);
        }
    }

    private void initialValueChanged() {
        int initialValue = -1;
        Long val = this.initialValueField.getValue();
        if (val != null) {
            initialValue = val.intValue();
        }
        this.model.setInitialValue(initialValue);
    }

    private void nameChanged() {
        String name = this.nameField.getText().trim();
        this.model.setBlockName(name);
    }

    private void lengthChanged() {
        int length = 0;
        Long val = this.lengthField.getValue();
        if (val != null) {
            length = val.intValue();
        }
        this.model.setLength(length);
    }

    private void addrChanged() {
        Address addr = null;
        try {
            addr = this.addrField.getAddress();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.model.setStartAddress(addr);
    }

    private void baseAddressChanged() {
        this.baseAddress = this.baseAddrField.getAddress();
        this.model.setBaseAddress(this.baseAddress);
    }

    private JPanel createComboBoxPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Block Types"));
        Object[] items = new MemoryBlockType[]{MemoryBlockType.DEFAULT, MemoryBlockType.OVERLAY, MemoryBlockType.BIT_MAPPED, MemoryBlockType.BYTE_MAPPED};
        this.comboBox = new GhidraComboBox(items);
        this.comboBox.addItemListener(e -> this.blockTypeSelected());
        panel.add((Component)this.comboBox);
        return panel;
    }

    private void blockTypeSelected() {
        MemoryBlockType blockType = (MemoryBlockType)this.comboBox.getSelectedItem();
        this.model.setBlockType(blockType);
        if (blockType == MemoryBlockType.DEFAULT) {
            this.cardLayout.show(this.viewPanel, OTHER);
        } else if (blockType == MemoryBlockType.OVERLAY) {
            this.cardLayout.show(this.viewPanel, OTHER);
        } else if (blockType == MemoryBlockType.BIT_MAPPED) {
            this.cardLayout.show(this.viewPanel, MAPPED);
        } else {
            this.cardLayout.show(this.viewPanel, MAPPED);
        }
    }

    private JPanel createRadioPanel() {
        JPanel panel = new JPanel();
        BoxLayout bl = new BoxLayout(panel, 0);
        panel.setLayout(bl);
        ButtonGroup radioGroup = new ButtonGroup();
        this.initializedRB = new JRadioButton("Initialized", false);
        this.initializedRB.setName(this.initializedRB.getText());
        this.initializedRB.addActionListener(ev -> this.initializeRBChanged());
        this.uninitializedRB = new JRadioButton("Uninitialized", true);
        this.uninitializedRB.setName(this.uninitializedRB.getText());
        this.uninitializedRB.addActionListener(ev -> this.uninitializedRBChanged());
        radioGroup.add(this.initializedRB);
        radioGroup.add(this.uninitializedRB);
        panel.add(this.initializedRB);
        panel.add(this.uninitializedRB);
        JPanel outerPanel = new JPanel();
        BoxLayout bl2 = new BoxLayout(outerPanel, 1);
        outerPanel.setLayout(bl2);
        outerPanel.add(panel);
        this.createInitializedPanel();
        outerPanel.add(this.initializedPanel);
        outerPanel.setBorder(BorderFactory.createEtchedBorder());
        return outerPanel;
    }

    private void createCardPanels() {
        this.viewPanel.add((Component)this.createAddressPanel(), MAPPED);
        this.viewPanel.add((Component)this.createRadioPanel(), OTHER);
        this.cardLayout.show(this.viewPanel, OTHER);
    }

    private void createInitializedPanel() {
        this.initialValueLabel = new JLabel("Initial Value");
        this.initialValueField = new RegisterField(8, null, false);
        this.initialValueField.setName("Initial Value");
        this.initialValueField.setEnabled(false);
        this.initialValueField.setChangeListener(e -> this.initialValueChanged());
        this.initializedPanel = new JPanel((LayoutManager)new PairLayout(4, 10));
        this.initializedPanel.setBorder(BorderFactory.createEmptyBorder(5, 7, 4, 5));
        this.initializedPanel.add(this.initialValueLabel);
        this.initializedPanel.add(this.initialValueField);
    }

    private JPanel createAddressPanel() {
        JPanel addressPanel = new JPanel((LayoutManager)new PairLayout());
        JLabel addrToAddLabel = new JLabel("Source Addr:");
        this.baseAddrField = new AddressInput();
        this.baseAddrField.setAddressFactory(this.addrFactory);
        this.baseAddrField.setName("Source Addr");
        this.baseAddrField.addChangeListener(ev -> this.baseAddressChanged());
        Program program = this.model.getProgram();
        Address minAddr = program.getMinAddress();
        if (minAddr == null) {
            minAddr = program.getAddressFactory().getDefaultAddressSpace().getAddress(0L);
        }
        this.baseAddrField.setAddress(minAddr);
        this.model.setBaseAddress(minAddr);
        addressPanel.add(addrToAddLabel);
        addressPanel.add(this.baseAddrField);
        addressPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        return addressPanel;
    }
}

