/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import docking.ActionContext;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.context.ProgramContextAction;
import ghidra.app.services.GoToService;
import ghidra.app.services.NavigationHistoryService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class UndoAction
extends ProgramContextAction {
    private final PluginTool tool;

    public UndoAction(PluginTool tool, String owner) {
        super("Undo", owner);
        this.tool = tool;
        this.setHelpLocation(new HelpLocation("Tool", "Undo"));
        String[] menuPath = new String[]{"&Edit", "&Undo"};
        ImageIcon icon = ResourceManager.loadImage((String)"images/undo.png");
        MenuData menuData = new MenuData(menuPath, (Icon)icon, "Undo");
        menuData.setMenuSubGroup("1Undo");
        this.setMenuBarData(menuData);
        this.setToolBarData(new ToolBarData((Icon)icon, "Undo"));
        this.setDescription("Undo");
        this.setKeyBindingData(new KeyBindingData('Z', 2));
    }

    @Override
    protected void actionPerformed(ProgramActionContext programContext) {
        Program program = programContext.getProgram();
        try {
            this.saveCurrentLocationToHistory();
            program.undo();
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, null, null, (Throwable)e);
        }
    }

    private void saveCurrentLocationToHistory() {
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        NavigationHistoryService historyService = (NavigationHistoryService)this.tool.getService(NavigationHistoryService.class);
        if (goToService != null && historyService != null) {
            historyService.addNewLocation(goToService.getDefaultNavigatable());
        }
    }

    @Override
    protected boolean isEnabledForContext(ProgramActionContext context) {
        Program program = context.getProgram();
        if (program.canUndo()) {
            String programName = program.getDomainFile().getName();
            this.getMenuBarData().setMenuItemName("Undo " + programName);
            String tip = HTMLUtilities.toWrappedHTML((String)("Undo " + program.getUndoName()));
            this.setDescription(tip);
            return true;
        }
        return false;
    }

    @Override
    public boolean isEnabledForContext(ActionContext actionContext) {
        if (!super.isEnabledForContext(actionContext)) {
            this.setDescription("Undo");
            this.getMenuBarData().setMenuItemName("Undo");
            return false;
        }
        return true;
    }
}

