/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import docking.DialogComponentProvider;
import ghidra.app.util.AddressInput;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.util.HelpLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.layout.PairLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OffsetTableDialog
extends DialogComponentProvider {
    private AddressInput addrInput;
    private AddressFactory addrFactory;
    private JComboBox<String> comboBox;
    private Address defaultAddress;
    private JCheckBox signedCheckBox;
    boolean canceled = false;

    OffsetTableDialog(Address defaultAddress, AddressFactory addrFactory) {
        super("Create Offset References", true);
        this.defaultAddress = defaultAddress;
        this.addrFactory = addrFactory;
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setHelpLocation(new HelpLocation("ReferencesPlugin", "Create_Offset_References"));
    }

    protected void cancelCallback() {
        this.canceled = true;
        this.close();
    }

    protected void okCallback() {
        if (this.addrInput.getAddress() != null) {
            this.close();
        } else {
            this.setStatusText("Please enter a valid address");
        }
    }

    void setSelectedSize(int size) {
        this.comboBox.setSelectedItem(Integer.toString(size));
    }

    void showDialog(PluginTool tool) throws CancelledException {
        this.canceled = false;
        tool.showDialog((DialogComponentProvider)this);
        if (this.canceled) {
            throw new CancelledException();
        }
    }

    int getSelectedSize() {
        String sel = (String)this.comboBox.getSelectedItem();
        return Integer.parseInt(sel);
    }

    public Address getBaseAddress() {
        return this.addrInput.getAddress();
    }

    public void setBaseAddress(Address address) {
        this.addrInput.setAddress(address);
    }

    boolean isSigned() {
        return this.signedCheckBox.isSelected();
    }

    void setSigned(boolean isSigned) {
        this.signedCheckBox.setSelected(isSigned);
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(10, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 10, 20));
        this.addrInput = new AddressInput();
        this.addrInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OffsetTableDialog.this.okCallback();
            }
        });
        this.addrInput.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OffsetTableDialog.this.clearStatusText();
            }
        });
        this.addrInput.setAddressFactory(this.addrFactory);
        this.addrInput.setAddress(this.defaultAddress);
        JLabel label = new JLabel("Enter Base Address:", 4);
        panel.add(label);
        panel.add(this.addrInput);
        JLabel sizeLabel = new JLabel("Select Data Size (Bytes):", 4);
        this.comboBox = new JComboBox<String>(new String[]{"1", "2", "4", "8"});
        int pointerSize = this.defaultAddress.getPointerSize();
        this.comboBox.setSelectedItem(Integer.toString(pointerSize));
        panel.add(sizeLabel);
        panel.add(this.comboBox);
        this.signedCheckBox = new JCheckBox("Signed Data Value(s)", true);
        panel.add(this.signedCheckBox);
        return panel;
    }
}

