/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchtext.databasesearcher;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.util.ProgramLocation;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class ProgramDatabaseFieldSearcher {
    protected final Pattern pattern;
    protected final boolean forward;
    private Address currentAddress;
    private ProgramLocation startLocation;
    private List<ProgramLocation> matchesForCurrentAddress = new LinkedList<ProgramLocation>();

    protected ProgramDatabaseFieldSearcher(Pattern pattern, boolean forward, ProgramLocation startLoc, AddressSetView set) {
        this.pattern = pattern;
        this.forward = forward;
        this.startLocation = startLoc;
        if (forward && set != null && !set.isEmpty() && startLoc != null && !set.getMinAddress().equals((Object)startLoc.getAddress())) {
            throw new IllegalArgumentException("Start location and addressSet are inconsistent!");
        }
        if (!(forward || set == null || set.isEmpty() || startLoc == null || set.getMaxAddress().equals((Object)startLoc.getAddress()))) {
            throw new IllegalArgumentException("Start location and addressSet are inconsistent!");
        }
    }

    private void initialize() {
        this.currentAddress = this.doAdvance(this.matchesForCurrentAddress);
        this.trimMatchesForStartLocation();
    }

    private Address doAdvance(List<ProgramLocation> currentMatches) {
        Address address = this.advance(this.matchesForCurrentAddress);
        if (!this.forward) {
            Collections.reverse(this.matchesForCurrentAddress);
        }
        return address;
    }

    protected abstract Address advance(List<ProgramLocation> var1);

    public Address getNextSignificantAddress(Address address) {
        if (address == null) {
            this.initialize();
            return this.currentAddress;
        }
        if (this.currentAddress == null) {
            return null;
        }
        if (this.currentAddress.equals((Object)address)) {
            this.currentAddress = this.doAdvance(this.matchesForCurrentAddress);
        }
        return this.currentAddress;
    }

    public ProgramLocation getMatch() {
        return this.matchesForCurrentAddress.remove(0);
    }

    public boolean hasMatch(Address address) {
        if (!address.equals((Object)this.currentAddress)) {
            return false;
        }
        return !this.matchesForCurrentAddress.isEmpty();
    }

    private void trimMatchesForStartLocation() {
        if (this.startLocation == null) {
            return;
        }
        if (!this.startLocation.getAddress().equals((Object)this.currentAddress)) {
            return;
        }
        Iterator<ProgramLocation> it = this.matchesForCurrentAddress.iterator();
        while (it.hasNext()) {
            ProgramLocation programLoc = it.next();
            int compareVal = this.startLocation.compareTo(programLoc);
            if ((!this.forward || compareVal < 0) && (this.forward || compareVal > 0)) continue;
            it.remove();
        }
    }
}

