/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import docking.ActionContext;
import docking.ComponentProvider;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.context.ProgramSymbolActionContext;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.symtable.NewSymbolFilter;
import ghidra.app.plugin.core.symtable.SymbolFilter;
import ghidra.app.plugin.core.symtable.SymbolPanel;
import ghidra.app.plugin.core.symtable.SymbolRenderer;
import ghidra.app.plugin.core.symtable.SymbolRowObject;
import ghidra.app.plugin.core.symtable.SymbolTableModel;
import ghidra.app.plugin.core.symtable.SymbolTablePlugin;
import ghidra.app.util.SymbolInspector;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

class SymbolProvider
extends ComponentProviderAdapter {
    private SymbolTablePlugin plugin;
    private SymbolRenderer renderer;
    private SymbolTableModel symbolKeyModel;
    private SymbolPanel symbolPanel;

    SymbolProvider(SymbolTablePlugin plugin) {
        super(plugin.getTool(), "Symbol Table", plugin.getName(), ProgramActionContext.class);
        this.plugin = plugin;
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Symbol_Table"));
        this.setWindowGroup("symbolTable");
        this.renderer = new SymbolRenderer();
        this.symbolKeyModel = new SymbolTableModel(this, plugin.getTool());
        this.symbolPanel = new SymbolPanel(this, this.symbolKeyModel, this.renderer, plugin.getTool(), plugin.getGoToService());
    }

    void updateTitle() {
        this.setSubTitle(this.generateSubTitle());
    }

    public ActionContext getActionContext(MouseEvent event) {
        Program program = this.plugin.getProgram();
        if (program == null) {
            return null;
        }
        List<SymbolRowObject> rowObjects = this.symbolPanel.getSelectedSymbolKeys();
        long[] symbolIDs = new long[rowObjects.size()];
        int index = 0;
        for (SymbolRowObject obj : rowObjects) {
            symbolIDs[index++] = obj.getKey();
        }
        return new ProgramSymbolActionContext((ComponentProvider)this, program, symbolIDs);
    }

    void deleteSymbols() {
        List<SymbolRowObject> rowObjects = this.symbolPanel.getSelectedSymbolKeys();
        this.symbolKeyModel.delete(rowObjects);
    }

    void makeSelection() {
        ProgramSelection selection = this.symbolPanel.getProgramSelection();
        ProgramSelectionPluginEvent event = new ProgramSelectionPluginEvent(this.plugin.getName(), selection, this.plugin.getProgram());
        this.plugin.firePluginEvent(event);
    }

    void setFilter() {
        this.symbolPanel.setFilter();
    }

    Symbol getCurrentSymbol() {
        List<SymbolRowObject> rowObjects = this.symbolPanel.getSelectedSymbolKeys();
        if (rowObjects != null && rowObjects.size() >= 1) {
            return this.symbolKeyModel.getSymbol(rowObjects.get(0).getKey());
        }
        return null;
    }

    void setCurrentSymbol(Symbol symbol) {
        this.plugin.getReferenceProvider().setCurrentSymbol(symbol);
    }

    Symbol getSymbol(long id) {
        return this.symbolKeyModel.getSymbol(id);
    }

    void dispose() {
        this.symbolKeyModel.dispose();
        this.symbolPanel.dispose();
        this.plugin = null;
    }

    void reload() {
        if (this.isVisible()) {
            this.symbolKeyModel.reload();
        }
    }

    void symbolAdded(Symbol s) {
        if (this.isVisible()) {
            this.symbolKeyModel.symbolAdded(s);
        }
    }

    void symbolRemoved(long symbolID) {
        if (this.isVisible()) {
            this.symbolKeyModel.symbolRemoved(symbolID);
        }
    }

    void symbolChanged(Symbol s) {
        if (this.isVisible()) {
            this.symbolKeyModel.symbolChanged(s);
        }
    }

    void setProgram(Program program, SymbolInspector inspector) {
        this.renderer.setSymbolInspector(inspector);
        if (this.isVisible()) {
            this.symbolKeyModel.reload(program);
        }
    }

    GhidraTable getTable() {
        return this.symbolPanel.getTable();
    }

    NewSymbolFilter getFilter() {
        return this.symbolPanel.getFilter();
    }

    private String generateSubTitle() {
        int unfilteredCount;
        SymbolFilter filter = this.symbolKeyModel.getFilter();
        int rowCount = this.symbolKeyModel.getRowCount();
        if (rowCount != (unfilteredCount = this.symbolKeyModel.getUnfilteredCount())) {
            return " (Text filter matched " + rowCount + " of " + unfilteredCount + " symbols)";
        }
        if (filter.acceptsAll()) {
            return "(" + this.symbolPanel.getActualSymbolCount() + " Symbols)";
        }
        return "(Filter settings matched " + this.symbolPanel.getActualSymbolCount() + " Symbols)";
    }

    public ImageIcon getIcon() {
        return SymbolTablePlugin.SYM_GIF;
    }

    void open() {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    public void componentHidden() {
        this.symbolKeyModel.reload(null);
        if (this.plugin != null) {
            this.plugin.closeReferenceProvider();
        }
    }

    public void componentShown() {
        this.symbolKeyModel.reload(this.plugin.getProgram());
    }

    public JComponent getComponent() {
        return this.symbolPanel;
    }

    void readConfigState(SaveState saveState) {
        this.symbolPanel.readConfigState(saveState);
    }

    void writeConfigState(SaveState saveState) {
        this.symbolPanel.writeConfigState(saveState);
    }
}

