/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame;

import ghidra.app.cmd.comments.SetCommentsCmd;
import ghidra.app.plugin.exceptionhandlers.gcc.GccAnalysisUtils;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;

public class DwarfCallFrameOpcodeParser {
    private static final int WHOLE_BYTE_MASK = 255;
    private static final int HIGH_2_BITS_MASK = 192;
    private static final int LOW_6_BITS_MASK = 63;
    private static final int DW_CFA_nop = 0;
    private static final int DW_CFA_advance_loc = 64;
    private static final int DW_CFA_offset = 128;
    private static final int DW_CFA_restore = 192;
    private static final int DW_CFA_set_loc = 1;
    private static final int DW_CFA_advance_loc1 = 2;
    private static final int DW_CFA_advance_loc2 = 3;
    private static final int DW_CFA_advance_loc4 = 4;
    private static final int DW_CFA_offset_extended = 5;
    private static final int DW_CFA_restore_extended = 6;
    private static final int DW_CFA_undefined = 7;
    private static final int DW_CFA_same_value = 8;
    private static final int DW_CFA_register = 9;
    private static final int DW_CFA_remember_state = 10;
    private static final int DW_CFA_restore_state = 11;
    private static final int DW_CFA_def_cfa = 12;
    private static final int DW_CFA_def_cfa_register = 13;
    private static final int DW_CFA_def_cfa_offset = 14;
    private static final int DW_CFA_def_cfa_expression = 15;
    private static final int DW_CFA_expression = 16;
    private static final int DW_CFA_offset_extended_sf = 17;
    private static final int DW_CFA_def_cfa_sf = 18;
    private static final int DW_CFA_def_cfa_offset_sf = 19;
    private static final int DW_CFA_val_offset = 20;
    private static final int DW_CFA_val_offset_sf = 21;
    private static final int DW_CFA_val_expression = 22;
    private static final int DW_CFA_MIPS_advance_loc8 = 29;
    private static final int DW_CFA_GNU_window_save = 45;
    private static final int DW_CFA_GNU_args_size = 46;
    private static final int DW_CFA_lo_user = 28;
    private static final int DW_CFA_hi_user = 63;
    private Program program;
    private Address address;
    private int length;

    public DwarfCallFrameOpcodeParser(Program program, Address address, int length) {
        this.program = program;
        this.address = address;
        this.length = length;
    }

    void parse() throws MemoryAccessException {
        Address curr = this.address;
        Address limit = this.address.add((long)this.length);
        while (curr.compareTo((Object)limit) < 0) {
            int operand1Len;
            long operand1;
            StringBuilder sb = new StringBuilder();
            Address instrAddr = curr;
            int opbyte = GccAnalysisUtils.readByte(this.program, curr) & 0xFF;
            int opcode = opbyte & 0xC0;
            int exOpcodeOrParam = opbyte & 0x3F;
            boolean primaryOpcode = opcode != 0;
            curr = curr.add(1L);
            if (primaryOpcode) {
                switch (opcode) {
                    case 64: {
                        primaryOpcode = true;
                        sb.append("DW_CFA_advance_loc delta[" + exOpcodeOrParam + "]");
                        break;
                    }
                    case 128: {
                        primaryOpcode = true;
                        operand1 = GccAnalysisUtils.readULEB128(this.program, curr);
                        operand1Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand1Len);
                        sb.append("DW_CFA_offset reg[" + exOpcodeOrParam + "] " + operand1);
                        break;
                    }
                    case 192: {
                        primaryOpcode = true;
                        sb.append("DW_CFA_restore reg[" + exOpcodeOrParam + "]");
                    }
                }
            } else {
                switch (exOpcodeOrParam) {
                    case 0: {
                        primaryOpcode = true;
                        sb.append("DW_CFA_nop");
                        break;
                    }
                    case 1: {
                        operand1 = GccAnalysisUtils.readDWord(this.program, curr) & 0xFFFFFFFFFFFFFFFFL;
                        curr = curr.add(4L);
                        sb.append("DW_CFA_set_loc addr[" + operand1 + "]");
                        break;
                    }
                    case 2: {
                        operand1 = GccAnalysisUtils.readByte(this.program, curr) & 0xFF;
                        curr = curr.add(1L);
                        sb.append("DW_CFA_advance_loc1 delta[" + operand1 + "]");
                        break;
                    }
                    case 3: {
                        operand1 = GccAnalysisUtils.readWord(this.program, curr) & 0xFFFF;
                        curr = curr.add(2L);
                        sb.append("DW_CFA_advance_loc2 delta[" + operand1 + "]");
                        break;
                    }
                    case 4: {
                        operand1 = GccAnalysisUtils.readDWord(this.program, curr) & 0xFFFFFFFFFFFFFFFFL;
                        curr = curr.add(4L);
                        sb.append("DW_CFA_advance_loc4 delta[" + operand1 + "]");
                        break;
                    }
                    case 5: {
                        operand1 = GccAnalysisUtils.readULEB128(this.program, curr);
                        operand1Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand1Len);
                        long operand2 = GccAnalysisUtils.readULEB128(this.program, curr);
                        int operand2Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand2Len);
                        sb.append("DW_CFA_offset_extended reg[" + operand1 + "] reg[" + operand2 + "]");
                        break;
                    }
                    case 6: {
                        operand1 = GccAnalysisUtils.readULEB128(this.program, curr);
                        operand1Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand1Len);
                        sb.append("DW_CFA_restore_extended reg[" + operand1 + "]");
                        break;
                    }
                    case 7: {
                        operand1 = GccAnalysisUtils.readULEB128(this.program, curr);
                        operand1Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand1Len);
                        sb.append("DW_CFA_undefined reg[" + operand1 + "]");
                        break;
                    }
                    case 8: {
                        operand1 = GccAnalysisUtils.readULEB128(this.program, curr);
                        operand1Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand1Len);
                        sb.append("DW_CFA_same_value reg[" + operand1 + "]");
                        break;
                    }
                    case 9: {
                        operand1 = GccAnalysisUtils.readULEB128(this.program, curr);
                        operand1Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand1Len);
                        long operand2 = GccAnalysisUtils.readULEB128(this.program, curr);
                        int operand2Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand2Len);
                        sb.append("DW_CFA_register reg[" + operand1 + "] reg[" + operand2 + "]");
                        break;
                    }
                    case 10: {
                        sb.append("DW_CFA_remember_state");
                        break;
                    }
                    case 11: {
                        sb.append("DW_CFA_restore_state");
                        break;
                    }
                    case 12: {
                        operand1 = GccAnalysisUtils.readULEB128(this.program, curr);
                        operand1Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand1Len);
                        long operand2 = GccAnalysisUtils.readULEB128(this.program, curr);
                        int operand2Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand2Len);
                        sb.append("DW_CFA_def_cfa reg[" + operand1 + "] offs[" + operand2 + "]");
                        break;
                    }
                    case 13: {
                        operand1 = GccAnalysisUtils.readULEB128(this.program, curr);
                        operand1Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand1Len);
                        sb.append("DW_CFA_def_cfa_register reg[" + operand1 + "]");
                        break;
                    }
                    case 14: {
                        operand1 = GccAnalysisUtils.readULEB128(this.program, curr);
                        operand1Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand1Len);
                        sb.append("DW_CFA_def_cfa_offset offs[" + operand1 + "]");
                        break;
                    }
                    case 15: {
                        sb.append("DW_CFA_def_cfa_expression BLOCK");
                        break;
                    }
                    case 16: {
                        operand1 = GccAnalysisUtils.readULEB128(this.program, curr);
                        operand1Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand1Len);
                        sb.append("DW_CFA_expression reg[" + operand1 + "] BLOCK");
                        break;
                    }
                    case 17: {
                        operand1 = GccAnalysisUtils.readULEB128(this.program, curr);
                        operand1Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand1Len);
                        long operand2 = GccAnalysisUtils.readULEB128(this.program, curr);
                        int operand2Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand2Len);
                        sb.append("DW_CFA_offset_extended_sf reg[" + operand1 + "] offs[" + operand2 + "]");
                        break;
                    }
                    case 18: {
                        operand1 = GccAnalysisUtils.readULEB128(this.program, curr);
                        operand1Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand1Len);
                        long operand2 = GccAnalysisUtils.readULEB128(this.program, curr);
                        int operand2Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand2Len);
                        sb.append("DW_CFA_def_cfa_sf reg[" + operand1 + "] offs[" + operand2 + "]");
                        break;
                    }
                    case 19: {
                        operand1 = GccAnalysisUtils.readULEB128(this.program, curr);
                        operand1Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand1Len);
                        sb.append("DW_CFA_def_cfa_offset_sf offs[" + operand1 + "]");
                        break;
                    }
                    case 20: {
                        operand1 = GccAnalysisUtils.readULEB128(this.program, curr);
                        operand1Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand1Len);
                        long operand2 = GccAnalysisUtils.readULEB128(this.program, curr);
                        int operand2Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand2Len);
                        sb.append("DW_CFA_val_offset [" + operand1 + "] [" + operand2 + "]");
                        break;
                    }
                    case 21: {
                        operand1 = GccAnalysisUtils.readULEB128(this.program, curr);
                        operand1Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand1Len);
                        long operand2 = GccAnalysisUtils.readULEB128(this.program, curr);
                        int operand2Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand2Len);
                        sb.append("DW_CFA_val_offset_sf [" + operand1 + "] [" + operand2 + "]");
                        break;
                    }
                    case 22: {
                        operand1 = GccAnalysisUtils.readULEB128(this.program, curr);
                        operand1Len = GccAnalysisUtils.getULEB128Length(this.program, curr);
                        curr = curr.add((long)operand1Len);
                        sb.append("DW_CFA_val_expression [" + operand1 + "] BLOCK");
                        break;
                    }
                    case 29: {
                        operand1 = GccAnalysisUtils.readQWord(this.program, curr) & 0xFFFFL;
                        curr = curr.add(8L);
                        sb.append("DW_CFA_MIPS_advance_loc8 + " + operand1);
                        break;
                    }
                    case 45: {
                        sb.append("DW_CFA_GNU_window_save");
                        break;
                    }
                    case 46: {
                        operand1 = GccAnalysisUtils.readByte(this.program, curr);
                        curr = curr.add(1L);
                        sb.append("DW_CFA_GNU_args_size [" + operand1 + "]");
                        break;
                    }
                    case 28: {
                        sb.append("DW_CFA_lo_user");
                        break;
                    }
                    case 63: {
                        sb.append("DW_CFA_hi_user");
                    }
                }
            }
            this.setComment(instrAddr, sb.toString(), 0);
            Msg.info((Object)this, (Object)sb.toString());
        }
    }

    private void setComment(Address addr, String comment, int commentType) {
        SetCommentsCmd commentCmd = null;
        switch (commentType) {
            case 1: {
                commentCmd = new SetCommentsCmd(addr, comment, null, null, null, null);
                break;
            }
            case 2: {
                commentCmd = new SetCommentsCmd(addr, null, comment, null, null, null);
                break;
            }
            case 0: {
                commentCmd = new SetCommentsCmd(addr, null, null, comment, null, null);
                break;
            }
            case 3: {
                commentCmd = new SetCommentsCmd(addr, null, null, null, comment, null);
                break;
            }
            case 4: {
                commentCmd = new SetCommentsCmd(addr, null, null, null, null, comment);
                break;
            }
            default: {
                commentCmd = new SetCommentsCmd(addr, null, null, comment, null, null);
            }
        }
        commentCmd.applyTo((DomainObject)this.program);
    }
}

