/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.prototype.match;

import generic.stl.Pair;
import ghidra.app.plugin.prototype.match.FunctionHasher;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;

public abstract class AbstractFunctionHasher
implements FunctionHasher {
    @Override
    public final long hash(Function function, TaskMonitor monitor) throws CancelledException {
        Program program = function.getProgram();
        Pair<Integer, ArrayList<CodeUnit>> pair = this.getAllCodeUnits(monitor, program, (AddressSetView)new AddressSet(function.getBody()));
        try {
            return this.hash(monitor, (ArrayList)pair.second, (Integer)pair.first);
        }
        catch (MemoryAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected final Pair<Integer, ArrayList<CodeUnit>> getAllCodeUnits(TaskMonitor monitor, Program prog, AddressSetView set) {
        int totalLength = 0;
        ArrayList<CodeUnit> arr = new ArrayList<CodeUnit>();
        CodeUnitIterator iter = prog.getListing().getCodeUnits(set, true);
        while (!monitor.isCancelled() && iter.hasNext()) {
            CodeUnit next = iter.next();
            arr.add(next);
            totalLength += next.getLength();
        }
        return new Pair((Object)totalLength, arr);
    }

    protected abstract long hash(TaskMonitor var1, ArrayList<CodeUnit> var2, int var3) throws MemoryAccessException, CancelledException;
}

