/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.prototype.match;

import generic.hash.MessageDigest;
import ghidra.app.plugin.prototype.match.ExactInstructionsFunctionHasher;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;

public class ExactMnemonicsFunctionHasher
extends ExactInstructionsFunctionHasher {
    public static final ExactMnemonicsFunctionHasher INSTANCE = new ExactMnemonicsFunctionHasher();

    private ExactMnemonicsFunctionHasher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long hash(TaskMonitor monitor, ArrayList<CodeUnit> units, int byteCount) throws MemoryAccessException, CancelledException {
        StringBuilder sb = new StringBuilder();
        for (CodeUnit codeUnit : units) {
            if (monitor.isCancelled()) {
                return 0L;
            }
            if (codeUnit instanceof Instruction) {
                Instruction inst = (Instruction)codeUnit;
                String mnemonic = inst.getMnemonicString();
                sb.append(mnemonic);
                sb.append("\n");
                sb.append(inst.getNumOperands());
            } else {
                try {
                    byte[] bytes = codeUnit.getBytes();
                    char[] chars = new char[bytes.length];
                    for (int ii = 0; ii < bytes.length; ++ii) {
                        chars[ii] = (char)bytes[ii];
                    }
                    sb.append(chars);
                }
                catch (Exception e) {
                    sb.append(codeUnit.getAddressString(true, true));
                }
            }
            sb.append("\n");
        }
        MessageDigest messageDigest = this.digest;
        synchronized (messageDigest) {
            this.digest.reset();
            this.digest.update(sb.toString().getBytes(), monitor);
            return this.digest.digestLong();
        }
    }
}

