/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.prototype.match;

import ghidra.program.model.address.Address;

public class SubroutineMatch {
    private Address[] progAAddrs = new Address[0];
    private Address[] progBAddrs = new Address[0];
    private String reason;

    public SubroutineMatch(String reason) {
        this.reason = reason;
    }

    public boolean add(Address addr, boolean isA) {
        if (isA) {
            Address[] newOne = new Address[this.progAAddrs.length + 1];
            for (int i = 0; i < this.progAAddrs.length; ++i) {
                newOne[i] = this.progAAddrs[i];
            }
            newOne[this.progAAddrs.length] = addr;
            this.progAAddrs = newOne;
        } else {
            Address[] newOne = new Address[this.progBAddrs.length + 1];
            for (int i = 0; i < this.progBAddrs.length; ++i) {
                newOne[i] = this.progBAddrs[i];
            }
            newOne[this.progBAddrs.length] = addr;
            this.progBAddrs = newOne;
        }
        return true;
    }

    public boolean remove(Address addr, boolean isA) {
        if (addr == null) {
            return false;
        }
        int cnt = 0;
        if (isA) {
            for (int i = 0; i < this.progAAddrs.length; ++i) {
                if (addr.equals((Object)this.progAAddrs[i])) {
                    this.progAAddrs[i] = null;
                    continue;
                }
                ++cnt;
            }
            Address[] newOne = new Address[cnt];
            cnt = 0;
            for (int i = 0; i < this.progAAddrs.length; ++i) {
                if (this.progAAddrs[i] == null) continue;
                newOne[cnt++] = this.progAAddrs[i];
            }
            this.progAAddrs = newOne;
        } else {
            for (int i = 0; i < this.progBAddrs.length; ++i) {
                if (addr.equals((Object)this.progBAddrs[i])) {
                    this.progBAddrs[i] = null;
                    continue;
                }
                ++cnt;
            }
            Address[] newOne = new Address[cnt];
            cnt = 0;
            for (int i = 0; i < this.progBAddrs.length; ++i) {
                if (this.progBAddrs[i] == null) continue;
                newOne[cnt++] = this.progBAddrs[i];
            }
            this.progBAddrs = newOne;
        }
        return false;
    }

    public String getReason() {
        return this.reason;
    }

    public Address[] getAAddresses() {
        return this.progAAddrs;
    }

    public Address[] getBAddresses() {
        return this.progBAddrs;
    }

    private boolean isOneToOne() {
        return this.progAAddrs.length == 1 && this.progBAddrs.length == 1;
    }

    public String toString() {
        int i;
        String str = this.reason + " ";
        for (i = 0; i < this.progAAddrs.length; ++i) {
            str = str + this.progAAddrs[i] + ",";
        }
        str = str + " --- ";
        for (i = 0; i < this.progBAddrs.length; ++i) {
            str = str + this.progBAddrs[i] + ",";
        }
        return str;
    }
}

