/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import generic.jar.ResourceFile;
import generic.util.Path;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.app.script.GhidraState;
import ghidra.app.script.ScriptInfo;
import ghidra.framework.Application;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.LazyMap;
import org.apache.commons.lang3.StringUtils;

public class GhidraScriptUtil {
    private static final String SCRIPTS_SUBDIR_NAME = "ghidra_scripts";
    private static final String DEV_SCRIPTS_SUBDIR_NAME = "developer_scripts";
    private static final String BIN_DIR_NAME = "bin";
    private static List<GhidraScriptProvider> providers = null;
    public static String USER_SCRIPTS_DIR = GhidraScriptUtil.buildUserScriptsDirectory();
    public static String USER_SCRIPTS_BIN_DIR = StringUtils.joinWith((String)File.separator, (Object[])new Object[]{Application.getUserSettingsDirectory(), "dev", "ghidra_scripts", "bin"});
    private static List<Path> scriptDirectoryPaths = new ArrayList<Path>();
    static Map<ResourceFile, ScriptInfo> scriptFileToInfoMap = new HashMap<ResourceFile, ScriptInfo>();
    static Map<String, List<ResourceFile>> scriptNameToFilesMap = LazyMap.lazyMap(new HashMap(), () -> new ArrayList());
    private static long lastRefreshRequestTimestamp;

    private static void createUserScriptsDirs() {
        File scriptsDir = new File(USER_SCRIPTS_DIR);
        scriptsDir.mkdirs();
        File binDir = new File(USER_SCRIPTS_BIN_DIR);
        binDir.mkdirs();
    }

    private static String buildUserScriptsDirectory() {
        String root = System.getProperty("user.home");
        String override = System.getProperty("ghidra.user.scripts.dir");
        if (override != null) {
            Msg.debug(GhidraScriptUtil.class, (Object)("Using Ghidra script source directory: " + root));
            root = override;
        }
        String sourcePath = StringUtils.joinWith((String)File.separator, (Object[])new Object[]{root, SCRIPTS_SUBDIR_NAME});
        return sourcePath;
    }

    public static void refreshRequested() {
        lastRefreshRequestTimestamp = System.currentTimeMillis();
    }

    public static long getLastRefreshRequestTimestamp() {
        return lastRefreshRequestTimestamp;
    }

    public static List<Path> getDefaultScriptDirectories() {
        ArrayList<Path> pathsList = new ArrayList<Path>();
        GhidraScriptUtil.addScriptPaths(pathsList, SCRIPTS_SUBDIR_NAME);
        GhidraScriptUtil.addScriptPaths(pathsList, DEV_SCRIPTS_SUBDIR_NAME);
        Collections.sort(pathsList);
        pathsList.add(0, new Path(new ResourceFile(USER_SCRIPTS_DIR), true, false, false));
        return pathsList;
    }

    private static void addScriptPaths(List<Path> pathsList, String directoryName) {
        List files = Application.findModuleSubDirectories((String)directoryName);
        for (ResourceFile file : files) {
            pathsList.add(new Path(file, true, false, true));
        }
    }

    public static boolean isSystemScriptPath(ResourceFile file) {
        return GhidraScriptUtil.isSystemFile(file);
    }

    public static boolean isSystemFile(ResourceFile file) {
        try {
            String filePath = file.getCanonicalPath().replace('\\', '/');
            Collection roots = Application.getApplicationRootDirectories();
            for (ResourceFile resourceFile : roots) {
                String installPath = resourceFile.getCanonicalPath().replace('\\', '/');
                if (!filePath.startsWith(installPath)) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            Msg.error(null, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            return true;
        }
    }

    public static List<ResourceFile> getScriptSourceDirectories() {
        ArrayList<ResourceFile> dirs = new ArrayList<ResourceFile>();
        for (Path path : scriptDirectoryPaths) {
            dirs.add(path.getPath());
        }
        return dirs;
    }

    public static void setScriptDirectories(List<Path> newPaths) {
        scriptDirectoryPaths = new ArrayList<Path>(newPaths);
    }

    public static Path getScriptPath(ResourceFile directory) {
        if (directory.isDirectory()) {
            for (Path path : scriptDirectoryPaths) {
                if (!path.getPath().equals((Object)directory)) continue;
                return path;
            }
        }
        return null;
    }

    public static ResourceFile getScriptCompileOutputDirectory(ResourceFile scriptFile) {
        return new ResourceFile(USER_SCRIPTS_BIN_DIR);
    }

    static ResourceFile getClassFile(ResourceFile sourceFile, String rawName) {
        if (sourceFile != null) {
            return GhidraScriptUtil.getClassFileByResourceFile(sourceFile, rawName);
        }
        return GhidraScriptUtil.getClassFileByName(rawName);
    }

    static ResourceFile getClassFileByResourceFile(ResourceFile sourceFile, String rawName) {
        String javaAbsolutePath = sourceFile.getAbsolutePath();
        String classAbsolutePath = javaAbsolutePath.replace(".java", ".class");
        String path = rawName.replace('.', '/');
        String className = path + ".class";
        ResourceFile classFile = GhidraScriptUtil.findClassFile(GhidraScriptUtil.getDevelopmentScriptBinDirectories(), classAbsolutePath, className);
        if (classFile != null) {
            Msg.trace(GhidraScriptUtil.class, (Object)("Resource file " + sourceFile + " class found at " + classFile));
            return classFile;
        }
        ResourceFile defaultCompilerDirectory = GhidraScriptUtil.getScriptCompileOutputDirectory(sourceFile);
        classFile = new ResourceFile(new File(defaultCompilerDirectory.getAbsolutePath(), className));
        if (classFile.exists()) {
            Msg.trace(GhidraScriptUtil.class, (Object)("Resource file " + sourceFile + " class found at " + classFile));
            return classFile;
        }
        classFile = GhidraScriptUtil.findClassFile(GhidraScriptUtil.getScriptBinDirectories(), classAbsolutePath, className);
        if (classFile != null) {
            Msg.trace(GhidraScriptUtil.class, (Object)("Resource file " + sourceFile + " class found at " + classFile));
            return classFile;
        }
        return new ResourceFile(USER_SCRIPTS_BIN_DIR + "/" + className);
    }

    private static ResourceFile getClassFileByName(String rawName) {
        String path = rawName.replace('.', '/');
        String className = path + ".class";
        HashSet<ResourceFile> matchingClassFiles = new HashSet<ResourceFile>();
        List<ResourceFile> userBinDirectories = GhidraScriptUtil.getScriptBinDirectories();
        for (ResourceFile file : userBinDirectories) {
            ResourceFile testFile = new ResourceFile(file, className);
            if (!testFile.exists()) continue;
            matchingClassFiles.add(testFile);
        }
        return GhidraScriptUtil.maybeWarnAboutNameConflict(className, matchingClassFiles);
    }

    private static ResourceFile findClassFile(Collection<ResourceFile> binDirs, String classAbsolutePath, String className) {
        HashSet<ResourceFile> matchingClassFiles = new HashSet<ResourceFile>();
        for (ResourceFile binDir : binDirs) {
            ResourceFile potentialFile;
            ResourceFile binParentFile = binDir.getParentFile();
            String absoluteParentPath = binParentFile.getAbsolutePath();
            if (!classAbsolutePath.startsWith(absoluteParentPath) || !(potentialFile = new ResourceFile(binDir, className)).exists()) continue;
            matchingClassFiles.add(potentialFile);
        }
        return GhidraScriptUtil.maybeWarnAboutNameConflict(className, matchingClassFiles);
    }

    private static ResourceFile maybeWarnAboutNameConflict(String className, Set<ResourceFile> matchingClassFiles) {
        int matchCount = matchingClassFiles.size();
        if (matchCount == 1) {
            return matchingClassFiles.iterator().next();
        }
        if (matchCount > 1) {
            ResourceFile preferredFile = null;
            for (ResourceFile file : matchingClassFiles) {
                if (!file.getParentFile().getAbsolutePath().equals(USER_SCRIPTS_BIN_DIR)) continue;
                preferredFile = file;
                break;
            }
            if (preferredFile == null) {
                preferredFile = matchingClassFiles.iterator().next();
            }
            Msg.warn(GhidraScriptUtil.class, (Object)("Found " + matchCount + " class files named " + className + ".  Using: " + preferredFile));
            return preferredFile;
        }
        return null;
    }

    public static List<ResourceFile> getScriptBinDirectories() {
        return Arrays.asList(new ResourceFile(USER_SCRIPTS_BIN_DIR));
    }

    static Collection<ResourceFile> getDevelopmentScriptBinDirectories() {
        if (!SystemUtilities.isInDevelopmentMode() || SystemUtilities.isInTestingMode()) {
            return Collections.emptyList();
        }
        HashSet<ResourceFile> dirs = new HashSet<ResourceFile>();
        for (Path path : scriptDirectoryPaths) {
            ResourceFile scriptDir = path.getPath();
            ResourceFile moduleDir = scriptDir.getParentFile();
            dirs.add(new ResourceFile(moduleDir, BIN_DIR_NAME));
        }
        return dirs;
    }

    public static void clean() {
        File[] classFiles;
        scriptFileToInfoMap.clear();
        scriptNameToFilesMap.clear();
        File userdir = new File(USER_SCRIPTS_DIR);
        for (File classFile : classFiles = userdir.listFiles(pathname -> pathname.getName().toLowerCase().endsWith(".class"))) {
            classFile.delete();
        }
    }

    public static String getBaseName(ResourceFile script) {
        String name = script.getName();
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return name;
        }
        return name.substring(0, pos);
    }

    public static boolean contains(ResourceFile scriptFile) {
        return scriptFileToInfoMap.containsKey(scriptFile);
    }

    public static void unloadScript(ResourceFile scriptFile) {
        scriptFileToInfoMap.remove(scriptFile);
        Iterator<ResourceFile> iter = scriptNameToFilesMap.get(scriptFile.getName()).iterator();
        while (iter.hasNext()) {
            ResourceFile rFile = iter.next();
            if (!scriptFile.equals((Object)rFile)) continue;
            iter.remove();
            break;
        }
    }

    public static Iterator<ScriptInfo> getScriptInfoIterator() {
        return scriptFileToInfoMap.values().iterator();
    }

    public static ScriptInfo getScriptInfo(ResourceFile scriptFile) {
        ScriptInfo info = scriptFileToInfoMap.get(scriptFile);
        if (info != null) {
            return info;
        }
        GhidraScriptProvider gsp = GhidraScriptUtil.getProvider(scriptFile);
        info = new ScriptInfo(gsp, scriptFile);
        scriptFileToInfoMap.put(scriptFile, info);
        String name = scriptFile.getName();
        List<ResourceFile> matchingFiles = scriptNameToFilesMap.get(name);
        matchingFiles.add(scriptFile);
        GhidraScriptUtil.markAnyDuplicates(matchingFiles);
        return info;
    }

    private static void markAnyDuplicates(List<ResourceFile> files) {
        boolean isDuplicate = files.size() > 1;
        files.forEach(f -> scriptFileToInfoMap.get(f).setDuplicate(isDuplicate));
    }

    public static synchronized List<GhidraScriptProvider> getProviders() {
        if (providers == null) {
            ArrayList<GhidraScriptProvider> newProviders = new ArrayList<GhidraScriptProvider>(ClassSearcher.getInstances(GhidraScriptProvider.class));
            Collections.sort(newProviders);
            providers = newProviders;
        }
        return providers;
    }

    public static GhidraScriptProvider getProvider(ResourceFile scriptFile) {
        String scriptFileName = scriptFile.getName().toLowerCase();
        for (GhidraScriptProvider provider : GhidraScriptUtil.getProviders()) {
            if (!scriptFileName.endsWith(provider.getExtension().toLowerCase())) continue;
            return provider;
        }
        return null;
    }

    public static boolean hasScriptProvider(ResourceFile scriptFile) {
        String scriptFileName = scriptFile.getName().toLowerCase();
        for (GhidraScriptProvider provider : GhidraScriptUtil.getProviders()) {
            if (!scriptFileName.endsWith(provider.getExtension().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static ResourceFile createNewScript(GhidraScriptProvider provider, ResourceFile parentDirectory, List<Path> scriptDirectories) throws IOException {
        String baseName = "NewScript";
        String extension = provider.getExtension();
        return GhidraScriptUtil.createNewScript(baseName, extension, parentDirectory, scriptDirectories);
    }

    private static ResourceFile createNewScript(String scriptName, String extension, ResourceFile parentDirctory, List<Path> scriptDirectories) throws IOException {
        boolean exists;
        Object baseName = scriptName;
        String className = (String)baseName + extension;
        int counter = 1;
        boolean bl = exists = GhidraScriptUtil.findScriptFileInPaths(scriptDirectories, className) != null;
        while (exists) {
            boolean bl2 = exists = GhidraScriptUtil.findScriptFileInPaths(scriptDirectories, className = (String)(baseName = scriptName + counter++) + extension) != null;
            if (counter <= 1000) continue;
            throw new IOException("Unable to create new script file, temporary files exceeded.");
        }
        return new ResourceFile(parentDirctory, className);
    }

    private static ResourceFile findScriptFileInPaths(List<Path> scriptDirectories, String filename) {
        String validatedName = GhidraScriptUtil.fixupName(filename);
        for (Path path : scriptDirectories) {
            ResourceFile file = new ResourceFile(path.getPath(), validatedName);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private static String fixupName(String name) {
        String path;
        int innerClassIndex;
        if (name.endsWith(".java")) {
            name = name.substring(0, name.length() - 5);
        }
        if ((innerClassIndex = (path = name.replace('.', '/')).indexOf(36)) != -1) {
            path = path.substring(0, innerClassIndex);
        }
        return path + ".java";
    }

    public static ScriptInfo findScriptByName(String name) {
        List<ResourceFile> matchingFiles = scriptNameToFilesMap.get(name);
        if (matchingFiles != null && !matchingFiles.isEmpty()) {
            ScriptInfo info = scriptFileToInfoMap.get(matchingFiles.get(0));
            if (matchingFiles.size() > 1) {
                Msg.warn(GhidraScriptUtil.class, (Object)("Found duplicate scripts for name: " + name + ".  Binding to script: " + info.getSourceFile()));
            }
            return info;
        }
        ResourceFile file = GhidraScriptUtil.findScriptFileInPaths(scriptDirectoryPaths, name);
        if (file == null) {
            return null;
        }
        return GhidraScriptUtil.getScriptInfo(file);
    }

    public static List<ResourceFile> getAllScripts() {
        ArrayList<ResourceFile> scriptList = new ArrayList<ResourceFile>();
        for (Path dirPath : scriptDirectoryPaths) {
            GhidraScriptUtil.updateAvailableScriptFilesForDirectory(scriptList, dirPath.getPath());
        }
        return scriptList;
    }

    private static void updateAvailableScriptFilesForDirectory(List<ResourceFile> scriptAccumulator, ResourceFile directory) {
        ResourceFile[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (ResourceFile scriptFile : files) {
            if (!scriptFile.isFile() || !GhidraScriptUtil.hasScriptProvider(scriptFile)) continue;
            scriptAccumulator.add(scriptFile);
        }
    }

    public static boolean alreadyExists(String scriptName) {
        return GhidraScriptUtil.getExistingScriptInfo(scriptName) != null;
    }

    public static ScriptInfo getExistingScriptInfo(String scriptName) {
        List<ResourceFile> matchingFiles = scriptNameToFilesMap.get(scriptName);
        if (matchingFiles.isEmpty()) {
            return null;
        }
        return scriptFileToInfoMap.get(matchingFiles.get(0));
    }

    public static boolean runScript(GhidraState scriptState, GhidraScript script, PrintWriter writer, Object originator, TaskMonitor monitor) {
        ResourceFile srcFile = script.getSourceFile();
        String scriptName = srcFile != null ? srcFile.getAbsolutePath() : script.getClass().getName() + ".class";
        try {
            Msg.info((Object)originator, (Object)("SCRIPT: " + scriptName));
            script.execute(scriptState, monitor, writer);
            writer.flush();
        }
        catch (Exception exc) {
            Program prog = scriptState.getCurrentProgram();
            String path = prog != null ? prog.getExecutablePath() : "Current program is null.";
            String logErrorMsg = path + "\nREPORT SCRIPT ERROR: " + scriptName + " : " + exc.getMessage();
            Msg.error((Object)originator, (Object)logErrorMsg, (Throwable)exc);
            return false;
        }
        return true;
    }

    public static void refreshDuplicates() {
        scriptNameToFilesMap.values().forEach(files -> {
            boolean isDuplicate = files.size() > 1;
            files.forEach(file -> scriptFileToInfoMap.get(file).setDuplicate(isDuplicate));
        });
    }

    static {
        GhidraScriptUtil.createUserScriptsDirs();
        scriptDirectoryPaths = GhidraScriptUtil.getDefaultScriptDirectories();
        lastRefreshRequestTimestamp = System.currentTimeMillis();
    }
}

