/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf4.DIEAggregate;
import ghidra.app.util.bin.format.dwarf4.DWARFAbbreviation;
import ghidra.app.util.bin.format.dwarf4.DWARFCompileUnit;
import ghidra.app.util.bin.format.dwarf4.DWARFException;
import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.dwarf4.DebugInfoEntry;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DWARFCompilationUnit {
    public static final int DWARF_32 = 32;
    public static final int DWARF_64 = 64;
    private final DWARFProgram dwarfProgram;
    private final long startOffset;
    private final long endOffset;
    private final long length;
    private final int format;
    private final short version;
    private final int compUnitNumber;
    private final byte pointerSize;
    private final long abbreviationOffset;
    private final long firstDIEOffset;
    private final Map<Integer, DWARFAbbreviation> codeToAbbreviationMap;
    private DWARFCompileUnit compUnit;

    public static DWARFCompilationUnit readCompilationUnit(DWARFProgram dwarfProgram, BinaryReader debugInfoBR, BinaryReader debugAbbrBR, int cuNumber, TaskMonitor monitor) throws DWARFException, IOException, CancelledException {
        int format;
        long startOffset = debugInfoBR.getPointerIndex();
        long length = debugInfoBR.readNextUnsignedInt();
        if (length == 0xFFFFFFFFL) {
            length = debugInfoBR.readNextLong();
            format = 64;
        } else {
            if (length >= 0xFFFFFFF0L) {
                throw new DWARFException("Reserved DWARF length value: " + Long.toHexString(length) + ". Unknown extension.");
            }
            if (length == 0L) {
                throw new DWARFException("Invalid length 0 for DWARF Compilation Unit at 0x" + Long.toHexString(startOffset));
            }
            format = 32;
        }
        long endOffset = debugInfoBR.getPointerIndex() + length;
        short version = debugInfoBR.readNextShort();
        long abbreviationOffset = DWARFUtil.readOffsetByDWARFformat(debugInfoBR, format);
        byte pointerSize = debugInfoBR.readNextByte();
        long firstDIEOffset = debugInfoBR.getPointerIndex();
        if (version < 2 || version > 4) {
            throw new DWARFException("Only DWARF version 2, 3, or 4 information is currently supported.");
        }
        debugAbbrBR.setPointerIndex(abbreviationOffset);
        Map<Integer, DWARFAbbreviation> abbrMap = DWARFAbbreviation.readAbbreviations(debugAbbrBR, dwarfProgram, monitor);
        DWARFCompilationUnit cu = new DWARFCompilationUnit(dwarfProgram, startOffset, endOffset, length, format, version, abbreviationOffset, pointerSize, cuNumber, firstDIEOffset, abbrMap);
        DebugInfoEntry compileUnitDIE = DebugInfoEntry.read(debugInfoBR, cu, dwarfProgram.getAttributeFactory());
        try {
            DWARFCompileUnit compUnit = DWARFCompileUnit.read(DIEAggregate.createSingle(compileUnitDIE), dwarfProgram.getDebugLine());
            cu.setCompileUnit(compUnit);
            return cu;
        }
        catch (IOException ioe) {
            Msg.error(null, (Object)("Failed to parse the DW_TAG_compile_unit DIE at the start of compilation unit " + cuNumber + " at offset " + startOffset + " (0x" + Long.toHexString(startOffset) + "), skipping entire compilation unit"), (Throwable)ioe);
            debugInfoBR.setPointerIndex(cu.getEndOffset());
            return null;
        }
    }

    public DWARFCompilationUnit(DWARFProgram dwarfProgram, long startOffset, long endOffset, long length, int format, short version, long abbreviationOffset, byte pointerSize, int compUnitNumber, long firstDIEOffset, Map<Integer, DWARFAbbreviation> codeToAbbreviationMap) {
        this.dwarfProgram = dwarfProgram;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.length = length;
        this.format = format;
        this.version = version;
        this.abbreviationOffset = abbreviationOffset;
        this.pointerSize = pointerSize;
        this.compUnitNumber = compUnitNumber;
        this.firstDIEOffset = firstDIEOffset;
        this.codeToAbbreviationMap = codeToAbbreviationMap != null ? codeToAbbreviationMap : new HashMap();
    }

    public DWARFCompileUnit getCompileUnit() {
        return this.compUnit;
    }

    protected void setCompileUnit(DWARFCompileUnit compUnit) {
        this.compUnit = compUnit;
    }

    public DWARFProgram getProgram() {
        return this.dwarfProgram;
    }

    public long getLength() {
        return this.length;
    }

    public byte getPointerSize() {
        return this.pointerSize;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    public int getFormat() {
        return this.format;
    }

    public boolean containsOffset(long offset) {
        return this.firstDIEOffset <= offset && offset < this.endOffset;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Compilation Unit");
        buffer.append(" [Start:0x" + Long.toHexString(this.startOffset) + "]");
        buffer.append(" [Length:0x" + Long.toHexString(this.length) + "]");
        buffer.append(" [AbbreviationOffset:0x" + Long.toHexString(this.abbreviationOffset) + "]");
        buffer.append(" [CompileUnit: " + (this.compUnit != null ? this.compUnit.toString() : "not present") + "]");
        return buffer.toString();
    }

    public Map<Integer, DWARFAbbreviation> getCodeToAbbreviationMap() {
        return this.codeToAbbreviationMap;
    }

    public long getFirstDIEOffset() {
        return this.firstDIEOffset;
    }

    public int getCompUnitNumber() {
        return this.compUnitNumber;
    }

    public void readDIEs(List<DebugInfoEntry> entries, TaskMonitor monitor) throws IOException, DWARFException, CancelledException {
        DebugInfoEntry die;
        BinaryReader br = this.dwarfProgram.getDebugInfo();
        br.setPointerIndex(this.getFirstDIEOffset());
        ArrayDeque<DebugInfoEntry> parentStack = new ArrayDeque<DebugInfoEntry>();
        DebugInfoEntry parent = null;
        DebugInfoEntry unexpectedTerminator = null;
        while (br.getPointerIndex() < this.getEndOffset() && (die = DebugInfoEntry.read(br, this, this.dwarfProgram.getAttributeFactory())) != null) {
            monitor.checkCanceled();
            if (die.isTerminator()) {
                if (parent == null && parentStack.isEmpty()) {
                    unexpectedTerminator = die;
                    continue;
                }
                parent = !parentStack.isEmpty() ? (DebugInfoEntry)parentStack.pop() : null;
                continue;
            }
            if (unexpectedTerminator != null) {
                throw new DWARFException("Unexpected terminator entry at " + Long.toHexString(unexpectedTerminator.getOffset()));
            }
            entries.add(die);
            if (parent != null) {
                parent.addChild(die);
                die.setParent(parent);
            } else if (die.getOffset() != this.getFirstDIEOffset()) {
                throw new DWARFException("Unexpected root level DIE at " + Long.toHexString(die.getOffset()));
            }
            if (!die.getAbbreviation().hasChildren()) continue;
            if (parent != null) {
                parentStack.push(parent);
            }
            parent = die;
        }
    }
}

