/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.debug.DebugSymbol;
import ghidra.util.Conv;
import java.io.IOException;

class S_LDATA32_NEW
extends DebugSymbol {
    private int reserved;
    private byte[] padding;

    static S_LDATA32_NEW createS_LDATA32_NEW(short length, short type, FactoryBundledWithBinaryReader reader, int ptr) throws IOException {
        S_LDATA32_NEW s_ldata32_new = (S_LDATA32_NEW)reader.getFactory().create(S_LDATA32_NEW.class, new Object[0]);
        s_ldata32_new.initS_LDATA32_NEW(length, type, reader, ptr);
        return s_ldata32_new;
    }

    private void initS_LDATA32_NEW(short length, short type, FactoryBundledWithBinaryReader reader, int ptr) throws IOException {
        this.processDebugSymbol(length, type);
        this.reserved = reader.readInt(ptr);
        this.offset = reader.readInt(ptr += 4);
        this.section = reader.readShort(ptr += 4);
        byte nameLen = reader.readByte(ptr += 2);
        this.name = reader.readAsciiString(++ptr, Conv.byteToInt((byte)nameLen));
        int sizeOfPadding = Conv.shortToInt((short)length) - 2 - 4 - 4 - 2 - 1 - Conv.byteToInt((byte)nameLen);
        this.padding = reader.readByteArray(ptr += nameLen, sizeOfPadding);
    }

    public int getReserved() {
        return this.reserved;
    }

    public byte[] getPadding() {
        return this.padding;
    }
}

