/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype.microsoft;

import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.ReadOnlyDataTypeComponent;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnicodeDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.DataConverter;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassTranslator;
import java.util.ArrayList;
import java.util.List;

public class MUIResourceDataType
extends DynamicDataType {
    private static byte[] MAGIC;
    private static String[] names;

    public MUIResourceDataType() {
        this(null, "MUIResource", null);
    }

    public MUIResourceDataType(DataTypeManager dtm) {
        this(null, "MUIResource", dtm);
    }

    protected MUIResourceDataType(CategoryPath path, String name, DataTypeManager dtm) {
        super(path, name, dtm);
    }

    public String getDescription() {
        return "MUI (Multilingual User Interface) Resource Data Type";
    }

    public String getMnemonic(Settings settings) {
        return "MUIRes";
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return "MUI";
    }

    protected DataTypeComponent[] getAllComponents(MemBuffer mbIn) {
        ArrayList<DataTypeComponent> comps = new ArrayList<DataTypeComponent>();
        int tempOffset = 0;
        MemBuffer memBuffer = mbIn;
        int[] offsets = new int[6];
        int[] sizes = new int[6];
        byte[] bytes = new byte[4];
        if (memBuffer.getBytes(bytes, 0) < 4) {
            Msg.debug((Object)((Object)this), (Object)("Can't read bytes for MUI File Header at " + mbIn.getAddress()));
        }
        if (this.checkMagic(memBuffer)) {
            StructureDataType sdt = this.MUIStructureHeader();
            tempOffset = this.addComp((DataType)sdt, sdt.getLength(), "muiResourceHeader", memBuffer.getAddress().add((long)tempOffset), comps, tempOffset);
            sdt = this.MUIStructureData(tempOffset, memBuffer, offsets, sizes);
            tempOffset = this.addComp((DataType)sdt, sdt.getLength(), "muiResourceData", memBuffer.getAddress().add((long)tempOffset), comps, tempOffset);
        } else {
            Msg.debug((Object)((Object)this), (Object)("Not an MUI resource data type at " + mbIn.getAddress()));
        }
        DataTypeComponent[] result = comps.toArray(new DataTypeComponent[comps.size()]);
        return result;
    }

    private StructureDataType MUIStructureHeader() {
        StructureDataType struct = new StructureDataType("FILEMUIINFO", 0);
        struct.add((DataType)DWordDataType.dataType, 4, "signature", "");
        struct.add((DataType)DWordDataType.dataType, 4, "dwSize", "");
        struct.add((DataType)DWordDataType.dataType, 4, "dwVersion", "");
        struct.add((DataType)DWordDataType.dataType, 4, "padding", "");
        struct.add((DataType)DWordDataType.dataType, 4, "dwFileType", "0x11 = normal, 0x12 = .mui");
        struct.add((DataType)DWordDataType.dataType, 4, "systemAttributes", "");
        struct.add((DataType)DWordDataType.dataType, 4, "ultimateFallbackLocation", "0x01 = internal, 0x02 = external");
        ArrayDataType adt16 = new ArrayDataType((DataType)ByteDataType.dataType, 16, 1);
        ArrayDataType adt24 = new ArrayDataType((DataType)ByteDataType.dataType, 16, 1);
        struct.add((DataType)adt16, 16, "serviceChecksum", "");
        struct.add((DataType)adt16, 16, "checksum", "");
        struct.add((DataType)adt24, 24, "padding60", "");
        struct.add((DataType)DWordDataType.dataType, 4, "dwMainNameOffset", "");
        struct.add((DataType)DWordDataType.dataType, 4, "dwMainNameSize", "");
        struct.add((DataType)DWordDataType.dataType, 4, "dwMainIDOffset", "");
        struct.add((DataType)DWordDataType.dataType, 4, "dwMainIDSize", "");
        struct.add((DataType)DWordDataType.dataType, 4, "dwMUINameOffset", "");
        struct.add((DataType)DWordDataType.dataType, 4, "dwMUINameSize", "");
        struct.add((DataType)DWordDataType.dataType, 4, "dwMUIIDOffset", "");
        struct.add((DataType)DWordDataType.dataType, 4, "dwMUIIDSize", "");
        struct.add((DataType)DWordDataType.dataType, 4, "dwLanguageOffset", "");
        struct.add((DataType)DWordDataType.dataType, 4, "dwLanguageSize", "");
        struct.add((DataType)DWordDataType.dataType, 4, "dwFallbackLanguageOffset", "");
        struct.add((DataType)DWordDataType.dataType, 4, "dwFallbackLanguageSize", "");
        return struct;
    }

    private StructureDataType MUIStructureData(int tempOffset, MemBuffer memBuffer, int[] offsets, int[] sizes) {
        StructureDataType struct = new StructureDataType("MUIDATA", 0);
        this.setArrays(memBuffer, offsets, sizes);
        int paddingOrdinal = 0;
        for (int i = 0; i < 6; ++i) {
            int paddingSize = 0;
            while (memBuffer.getAddress().add((long)tempOffset).getOffset() % 8L != 0L) {
                ++tempOffset;
                ++paddingSize;
            }
            if (paddingSize != 0) {
                struct.add((DataType)new ArrayDataType((DataType)ByteDataType.dataType, paddingSize, 1), "padding_" + paddingOrdinal++, "");
            }
            if (sizes[i] == 0) continue;
            if (i == 0 || i == 2 || i == 4 || i == 5) {
                struct.add((DataType)UnicodeDataType.dataType, sizes[i], names[i], "");
                tempOffset += sizes[i];
                continue;
            }
            ArrayDataType array = new ArrayDataType((DataType)ByteDataType.dataType, sizes[i], 1);
            tempOffset += sizes[i];
            struct.add((DataType)array, names[i], "");
        }
        return struct;
    }

    private void setArrays(MemBuffer memBuffer, int[] offsets, int[] sizes) {
        for (int i = 0; i < 6; ++i) {
            byte[] offsetBytes = new byte[4];
            byte[] sizeBytes = new byte[4];
            try {
                for (int j = 0; j < 4; ++j) {
                    offsetBytes[j] = memBuffer.getByte(84 + j + 8 * i);
                    sizeBytes[j] = memBuffer.getByte(88 + j + 8 * i);
                }
            }
            catch (MemoryAccessException e) {
                Msg.debug((Object)((Object)this), (Object)"Unexpected exception building MUI resource");
            }
            DataConverter converter = this.getDataConverter(memBuffer.getMemory().getProgram());
            offsets[i] = converter.getInt(offsetBytes, 0);
            sizes[i] = converter.getInt(sizeBytes, 0);
        }
    }

    private boolean checkMagic(MemBuffer memBuffer) {
        try {
            for (int i = 0; i < MAGIC.length; ++i) {
                if (MAGIC[i] == memBuffer.getByte(i)) continue;
                return false;
            }
        }
        catch (MemoryAccessException e) {
            Msg.debug((Object)((Object)this), (Object)"Unexpected exception building MUI resource");
        }
        return true;
    }

    private int addComp(DataType dataType, int length, String fieldName, Address address, List<DataTypeComponent> comps, int currentOffset) {
        if (length > 0) {
            ReadOnlyDataTypeComponent readOnlyDataTypeComponent = new ReadOnlyDataTypeComponent(dataType, (DynamicDataType)this, length, comps.size(), currentOffset, fieldName, null);
            comps.add((DataTypeComponent)readOnlyDataTypeComponent);
            currentOffset += length;
        }
        return currentOffset;
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "<MUI-Resource>";
    }

    public String getDefaultLabelPrefix() {
        return "MUI";
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new MUIResourceDataType(dtm);
    }

    private DataConverter getDataConverter(Program program) {
        if (program.getMemory().isBigEndian()) {
            return BigEndianDataConverter.INSTANCE;
        }
        return LittleEndianDataConverter.INSTANCE;
    }

    static {
        ClassTranslator.put((String)"ghidra.app.plugin.prototype.data.MUIResourceDataType", (String)MUIResourceDataType.class.getName());
        MAGIC = new byte[]{-51, -2, -51, -2};
        names = new String[]{"dwMainName", "dwMainID", "dwMUIName", "dwMUIID", "dwLanguage", "dwFallbackLanguage"};
    }
}

