/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import generic.continues.ContinuesFactory;
import generic.continues.GenericFactory;
import generic.continues.RethrowContinuesFactory;
import ghidra.app.util.MemoryBlockUtil;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.ne.EntryPoint;
import ghidra.app.util.bin.format.ne.EntryTable;
import ghidra.app.util.bin.format.ne.EntryTableBundle;
import ghidra.app.util.bin.format.ne.ImportedNameTable;
import ghidra.app.util.bin.format.ne.InformationBlock;
import ghidra.app.util.bin.format.ne.LengthStringOrdinalSet;
import ghidra.app.util.bin.format.ne.LengthStringSet;
import ghidra.app.util.bin.format.ne.ModuleReferenceTable;
import ghidra.app.util.bin.format.ne.NewExecutable;
import ghidra.app.util.bin.format.ne.NonResidentNameTable;
import ghidra.app.util.bin.format.ne.ResidentNameTable;
import ghidra.app.util.bin.format.ne.Resource;
import ghidra.app.util.bin.format.ne.ResourceStringTable;
import ghidra.app.util.bin.format.ne.ResourceTable;
import ghidra.app.util.bin.format.ne.ResourceType;
import ghidra.app.util.bin.format.ne.Segment;
import ghidra.app.util.bin.format.ne.SegmentRelocation;
import ghidra.app.util.bin.format.ne.SegmentTable;
import ghidra.app.util.bin.format.ne.WindowsHeader;
import ghidra.app.util.importer.MemoryConflictHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.importer.MessageLogContinuesFactory;
import ghidra.app.util.opinion.AbstractLibrarySupportLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictException;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Conv;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class NeLoader
extends AbstractLibrarySupportLoader {
    public static final String NE_NAME = "New Executable (NE)";
    private static final String TAB = "    ";
    private static final long MIN_BYTE_LENGTH = 4L;
    private ArrayList<Address> entryPointList = new ArrayList();
    private Comparator<String> comparator = new CallNameComparator();

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (provider.length() < 4L) {
            return loadSpecs;
        }
        NewExecutable ne = new NewExecutable((GenericFactory)RethrowContinuesFactory.INSTANCE, provider);
        WindowsHeader wh = ne.getWindowsHeader();
        if (wh != null) {
            List<QueryResult> results = QueryOpinionService.query(this.getName(), "" + wh.getInformationBlock().getMagicNumber(), null);
            for (QueryResult result : results) {
                loadSpecs.add(new LoadSpec((Loader)this, 0L, result));
            }
            if (loadSpecs.isEmpty()) {
                loadSpecs.add(new LoadSpec((Loader)this, 0L, true));
            }
        }
        return loadSpecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program prog, MemoryConflictHandler handler, TaskMonitor monitor, MessageLog log) throws IOException {
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("Processing new executable...");
        this.initVars();
        ContinuesFactory factory = MessageLogContinuesFactory.create((MessageLog)log);
        MemoryBlockUtil mbu = new MemoryBlockUtil(prog, handler);
        try {
            NewExecutable ne = new NewExecutable((GenericFactory)factory, provider);
            WindowsHeader wh = ne.getWindowsHeader();
            InformationBlock ib = wh.getInformationBlock();
            SegmentTable st = wh.getSegmentTable();
            ResourceTable rt = wh.getResourceTable();
            EntryTable et = wh.getEntryTable();
            ResidentNameTable rnt = wh.getResidentNameTable();
            NonResidentNameTable nrnt = wh.getNonResidentNameTable();
            ImportedNameTable imp = wh.getImportedNameTable();
            ModuleReferenceTable mrt = wh.getModuleReferenceTable();
            Listing listing = prog.getListing();
            SymbolTable symbolTable = prog.getSymbolTable();
            Memory memory = prog.getMemory();
            SegmentedAddressSpace space = (SegmentedAddressSpace)prog.getAddressFactory().getDefaultAddressSpace();
            ProgramContext context = prog.getProgramContext();
            RelocationTable relocTable = prog.getRelocationTable();
            if (monitor.isCancelled()) {
                return;
            }
            monitor.setMessage("Processing segment table...");
            this.processSegmentTable(mbu, ib, st, space, listing, memory, context, monitor);
            if (prog.getMemory().isEmpty()) {
                Msg.error((Object)this, (Object)("Empty memory for " + prog));
                return;
            }
            if (monitor.isCancelled()) {
                return;
            }
            monitor.setMessage("Processing resource table...");
            this.processResourceTable(prog, mbu, rt, space, monitor);
            if (monitor.isCancelled()) {
                return;
            }
            monitor.setMessage("Processing module reference table...");
            this.processModuleReferenceTable(mbu, mrt, st, imp, prog, space, log, monitor);
            if (monitor.isCancelled()) {
                return;
            }
            monitor.setMessage("Processing entry table...");
            this.processEntryTable(st, ib, et, symbolTable, space);
            if (monitor.isCancelled()) {
                return;
            }
            monitor.setMessage("Processing non-resident name table...");
            this.processNonResidentNameTable(nrnt, symbolTable);
            if (monitor.isCancelled()) {
                return;
            }
            monitor.setMessage("Processing resident name table...");
            this.processResidentNameTable(rnt, symbolTable);
            if (monitor.isCancelled()) {
                return;
            }
            monitor.setMessage("Processing segment relocations...");
            this.processRelocations(st, imp, mrt, relocTable, prog, memory, space, log, monitor);
            if (monitor.isCancelled()) {
                return;
            }
            monitor.setMessage("Processing information block...");
            this.processInformationBlock(ib, nrnt, memory, listing);
            this.processProperties(ib, prog, monitor);
        }
        finally {
            String messages = mbu.getMessages();
            if (messages.length() != 0) {
                log.appendMsg(messages);
            }
            mbu.dispose();
            mbu = null;
        }
    }

    private void processProperties(InformationBlock ib, Program prog, TaskMonitor monitor) {
        if (monitor.isCancelled()) {
            return;
        }
        Options props = prog.getOptions("Program Information");
        boolean relocatable = (ib.getApplicationFlags() & 0xFFFFFF80) != 0;
        props.setBoolean("Relocatable", relocatable);
    }

    private void processInformationBlock(InformationBlock ib, NonResidentNameTable nrnt, Memory memory, Listing listing) {
        Address addr = memory.getMinAddress();
        CodeUnit firstCU = listing.getCodeUnitAt(addr);
        StringBuffer buffer = new StringBuffer();
        buffer.append("Title:  " + nrnt.getTitle() + "\n");
        buffer.append("Format: New Executable (NE) Windows\n");
        buffer.append("CRC:    " + Conv.toHexString((int)ib.getChecksum()) + "\n");
        buffer.append("\n");
        buffer.append("Program Entry Point (CS:IP):   " + Conv.toHexString((short)ib.getEntryPointSegment()) + ":" + Conv.toHexString((short)ib.getEntryPointOffset()) + "\n");
        buffer.append("Initial Stack Pointer (SS:SP): " + Conv.toHexString((short)ib.getStackPointerSegment()) + ":" + Conv.toHexString((short)ib.getStackPointerOffset()) + "\n");
        buffer.append("Auto Data Segment Index:       " + Conv.toHexString((short)ib.getAutomaticDataSegment()) + "\n");
        buffer.append("Initial Heap Size:             " + Conv.toHexString((short)ib.getInitialHeapSize()) + "\n");
        buffer.append("Initial Stack Size:            " + Conv.toHexString((short)ib.getInitialStackSize()) + "\n");
        buffer.append("Minimum Code Swap Size:        " + Conv.toHexString((short)ib.getMinCodeSwapSize()) + "\n");
        buffer.append("\n");
        buffer.append("Linker Version:  " + ib.getVersion() + "." + ib.getRevision() + "\n");
        buffer.append("Target OS:       " + ib.getTargetOpSysAsString() + "\n");
        buffer.append("Windows Version: " + (ib.getExpectedWindowsVersion() >> 8) + "." + (ib.getExpectedWindowsVersion() & 0xFF) + "\n");
        buffer.append("\n");
        buffer.append("Program Flags:     " + Conv.toHexString((byte)ib.getProgramFlags()) + "\n");
        buffer.append(ib.getProgramFlagsAsString());
        buffer.append("Application Flags: " + Conv.toHexString((byte)ib.getApplicationFlags()) + "\n");
        buffer.append(ib.getApplicationFlagsAsString());
        buffer.append("Other Flags:       " + Conv.toHexString((byte)ib.getOtherFlags()) + "\n");
        buffer.append(ib.getOtherFlagsAsString());
        firstCU.setComment(3, buffer.toString());
    }

    private void processSegmentTable(MemoryBlockUtil mbu, InformationBlock ib, SegmentTable st, SegmentedAddressSpace space, Listing listing, Memory memory, ProgramContext context, TaskMonitor monitor) throws IOException {
        try {
            Segment[] segments = st.getSegments();
            for (int i = 0; i < segments.length; ++i) {
                String name = (segments[i].isCode() ? "Code" : "Data") + (i + 1);
                byte[] bytes = segments[i].getBytes();
                SegmentedAddress addr = space.getAddress(segments[i].getSegmentID(), 0);
                boolean r = true;
                boolean w = segments[i].isData() && !segments[i].isReadOnly();
                boolean x = segments[i].isCode();
                if (bytes.length > 0) {
                    mbu.createInitializedBlock(name, (Address)addr, bytes, "", "", r, w, x, monitor);
                } else {
                    mbu.createUninitializedBlock(false, name, (Address)addr, bytes.length, "", "", r, w, x);
                }
                if (segments[i].is32bit()) {
                    Address end = addr.add((long)(bytes.length - 1));
                    Register opsizeRegister = context.getRegister("opsize");
                    Register addrsizeRegister = context.getRegister("addrsize");
                    try {
                        context.setValue(opsizeRegister, (Address)addr, end, BigInteger.valueOf(1L));
                        context.setValue(addrsizeRegister, (Address)addr, end, BigInteger.valueOf(1L));
                    }
                    catch (ContextChangeException contextChangeException) {
                        // empty catch block
                    }
                }
                StringBuffer buff = new StringBuffer();
                buff.append("Segment:    " + (i + 1) + "\n");
                buff.append("Offset:     " + Conv.toHexString((int)segments[i].getOffsetShiftAligned()) + "\n");
                buff.append("Length:     " + Conv.toHexString((short)segments[i].getLength()) + "\n");
                buff.append("Min Alloc:  " + Conv.toHexString((short)segments[i].getMinAllocSize()) + "\n");
                buff.append("Flags:      " + Conv.toHexString((short)segments[i].getFlagword()) + "\n");
                buff.append(TAB + (segments[i].isCode() ? "Code" : "Data") + "\n");
                buff.append(segments[i].isDiscardable() ? "    Discardable\n" : "");
                buff.append(segments[i].isExecuteOnly() ? "    Execute Only\n" : "");
                buff.append(segments[i].isLoaded() ? "    Loaded\n" : "");
                buff.append(segments[i].isLoaderAllocated() ? "    LoaderAllocated\n" : "");
                buff.append(TAB + (segments[i].isMoveable() ? "Moveable" : "Fixed") + "\n");
                buff.append(TAB + (segments[i].isPreload() ? "Preload" : "LoadOnCall") + "\n");
                buff.append(TAB + (segments[i].isPure() ? "Pure (Shareable)" : "Impure (Non-shareable)") + "\n");
                buff.append(segments[i].isReadOnly() ? "    Read Only\n" : "");
                buff.append(segments[i].is32bit() ? "    Use 32 Bit\n" : "");
                CodeUnit cu = listing.getCodeUnitAt((Address)addr);
                cu.setComment(1, buff.toString());
            }
            for (Segment segment : segments) {
                if (!segment.isCode()) continue;
                SegmentedAddress addr = space.getAddress(segment.getSegmentID(), 0);
                MemoryBlock mb = memory.getBlock((Address)addr);
                this.setRegisterDS(ib, st, context, mb.getStart(), mb.getEnd());
            }
        }
        catch (AddressOverflowException e) {
            throw new RuntimeException(e);
        }
    }

    private int getNextAvailableSegment(Program program) {
        Address addr = program.getMemory().getMaxAddress();
        return ((int)addr.getOffset() >> 4) + 1;
    }

    private void processResourceTable(Program program, MemoryBlockUtil mbu, ResourceTable rt, SegmentedAddressSpace space, TaskMonitor monitor) throws IOException {
        ResourceType[] types;
        Listing listing = program.getListing();
        if (rt == null) {
            return;
        }
        int id = 0;
        for (ResourceType type : types = rt.getResourceTypes()) {
            Resource[] resources;
            for (Resource resource : resources = type.getResources()) {
                LengthStringSet[] strings;
                int segidx = this.getNextAvailableSegment(program);
                SegmentedAddress addr = space.getAddress(segidx, 0);
                try {
                    byte[] bytes = resource.getBytes();
                    if (bytes != null && bytes.length > 0) {
                        mbu.createInitializedBlock("Rsrc" + id++, (Address)addr, bytes, "", "", true, false, false, monitor);
                    }
                }
                catch (AddressOverflowException e) {
                    throw new RuntimeException(e);
                }
                StringBuffer buf = new StringBuffer();
                buf.append("Resource Type:  " + Conv.toHexString((short)type.getTypeID()) + " (" + type + ")\n");
                buf.append("File Length:    " + Conv.toHexString((int)resource.getFileLengthShifted()) + "\n");
                buf.append("File Offset:    " + Conv.toHexString((int)resource.getFileOffsetShifted()) + "\n");
                buf.append("Attributes:     " + Conv.toHexString((short)resource.getFlagword()) + " (");
                if (resource.isMoveable()) {
                    buf.append("Moveable");
                }
                if (resource.isPreload()) {
                    buf.append(",Preload");
                }
                if (resource.isPure()) {
                    buf.append(",Pure");
                }
                buf.append(")\n");
                buf.append("Resource ID:    " + resource + "\n");
                buf.append("Handle:         " + Conv.toHexString((short)resource.getHandle()) + "\n");
                buf.append("Usage:          " + Conv.toHexString((short)resource.getUsage()) + "\n");
                CodeUnit cu = listing.getCodeUnitAt((Address)addr);
                cu.setComment(1, buf.toString());
                if (!(resource instanceof ResourceStringTable)) continue;
                ResourceStringTable rst = (ResourceStringTable)resource;
                for (LengthStringSet string : strings = rst.getStrings()) {
                    try {
                        long dis = string.getIndex() - (long)resource.getFileOffsetShifted();
                        Address straddr = addr.addNoWrap(dis);
                        listing.createData(straddr, (DataType)new ByteDataType(), 1);
                        straddr = straddr.addNoWrap(1L);
                        listing.createData(straddr, (DataType)new StringDataType(), Conv.byteToInt((byte)string.getLength()));
                    }
                    catch (AddressOverflowException addressOverflowException) {
                    }
                    catch (CodeUnitInsertionException codeUnitInsertionException) {
                    }
                    catch (DataTypeConflictException dataTypeConflictException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void processModuleReferenceTable(MemoryBlockUtil mbu, ModuleReferenceTable mrt, SegmentTable st, ImportedNameTable imp, Program program, SegmentedAddressSpace space, MessageLog log, TaskMonitor monitor) throws IOException {
        LengthStringSet[] names;
        int pointerSize = space.getAddress(0, 0).getPointerSize();
        PointerDataType ptr = new PointerDataType();
        String comment = "";
        String source = "";
        Listing listing = program.getListing();
        SymbolTable symbolTable = program.getSymbolTable();
        for (LengthStringSet name : names = mrt.getNames()) {
            String[] callnames = this.getCallNamesForModule(name.getString(), mrt, st, imp);
            int length = callnames.length * pointerSize;
            int segment = this.getNextAvailableSegment(program);
            SegmentedAddress start = space.getAddress(segment, 0);
            if (length > 0) {
                mbu.createUninitializedBlock(false, name.getString(), (Address)start, length, comment, source, true, false, false);
            }
            SegmentedAddress addr = start;
            for (String callname : callnames) {
                try {
                    listing.createData((Address)addr, (DataType)ptr, pointerSize);
                }
                catch (CodeUnitInsertionException e) {
                    log.appendMsg(e.getMessage() + "\n");
                    continue;
                }
                catch (DataTypeConflictException e) {
                    log.appendMsg(e.getMessage() + "\n");
                    continue;
                }
                try {
                    program.getReferenceManager().addExternalReference((Address)addr, name.getString(), callname, null, SourceType.IMPORTED, 0, RefType.EXTERNAL_REF);
                    symbolTable.createLabel((Address)addr, name.getString() + "_" + callname, SourceType.IMPORTED);
                }
                catch (DuplicateNameException e) {
                    log.appendMsg(e.getMessage() + "\n");
                    continue;
                }
                catch (InvalidInputException e) {
                    log.appendMsg(e.getMessage() + "\n");
                    continue;
                }
                addr = addr.addWrap((long)pointerSize);
            }
        }
    }

    private String[] getCallNamesForModule(String moduleName, ModuleReferenceTable mrt, SegmentTable st, ImportedNameTable imp) throws IOException {
        Segment[] segments;
        ArrayList<String> list = new ArrayList<String>();
        for (Segment segment : segments = st.getSegments()) {
            SegmentRelocation[] relocs;
            for (SegmentRelocation reloc : relocs = segment.getRelocations()) {
                String procname;
                if (!moduleName.equals(this.getRelocationModuleName(mrt, reloc)) || list.contains(procname = this.getRelocationProcName(reloc, imp))) continue;
                list.add(procname);
            }
        }
        String[] callnames = new String[list.size()];
        list.toArray(callnames);
        Arrays.sort(callnames, this.comparator);
        return callnames;
    }

    private void processEntryTable(SegmentTable st, InformationBlock ib, EntryTable et, SymbolTable symbolTable, SegmentedAddressSpace space) {
        EntryTableBundle[] bundles;
        short segmentIdx = ib.getEntryPointSegment();
        if (segmentIdx > 0) {
            int segment = st.getSegments()[segmentIdx - 1].getSegmentID();
            short offset = ib.getEntryPointOffset();
            SegmentedAddress entryAddr = space.getAddress(segment, Conv.shortToInt((short)offset));
            symbolTable.addExternalEntryPoint((Address)entryAddr);
            try {
                symbolTable.createLabel((Address)entryAddr, "entry", SourceType.IMPORTED);
            }
            catch (InvalidInputException e) {
                e.printStackTrace();
            }
        }
        for (EntryTableBundle bundle : bundles = et.getBundles()) {
            EntryPoint[] pts;
            if (bundle.getType() == 0) {
                int count = Conv.byteToInt((byte)bundle.getCount());
                for (int i = 0; i < count; ++i) {
                    this.entryPointList.add(null);
                }
                continue;
            }
            for (EntryPoint pt : pts = bundle.getEntryPoints()) {
                int seg = 0;
                if (bundle.isMoveable()) {
                    seg = st.getSegments()[pt.getSegment() - 1].getSegmentID();
                } else if (bundle.isConstant()) {
                    System.out.println("NE - constant entry point...");
                } else {
                    seg = st.getSegments()[bundle.getType() - 1].getSegmentID();
                }
                int off = Conv.shortToInt((short)pt.getOffset());
                SegmentedAddress addr = space.getAddress(seg, off);
                symbolTable.addExternalEntryPoint((Address)addr);
                this.entryPointList.add((Address)addr);
            }
        }
    }

    private void processNonResidentNameTable(NonResidentNameTable nrnt, SymbolTable symbolTable) {
        this.createSymbols(nrnt.getNames(), symbolTable);
    }

    private void processResidentNameTable(ResidentNameTable rnt, SymbolTable symbolTable) {
        this.createSymbols(rnt.getNames(), symbolTable);
    }

    private void processRelocations(SegmentTable st, ImportedNameTable imp, ModuleReferenceTable mrt, RelocationTable relocTable, Program program, Memory memory, SegmentedAddressSpace space, MessageLog log, TaskMonitor monitor) throws IOException {
        Segment[] segments = st.getSegments();
        for (int s = 0; s < segments.length; ++s) {
            SegmentRelocation[] relocs;
            if (monitor.isCancelled()) {
                return;
            }
            block3: for (SegmentRelocation reloc : relocs = segments[s].getRelocations()) {
                Symbol symbol;
                if (monitor.isCancelled()) {
                    return;
                }
                int segment = st.getSegments()[s].getSegmentID();
                int offset = Conv.shortToInt((short)reloc.getOffset());
                SegmentedAddress relocAddr = null;
                if (reloc.isInternalRef()) {
                    if (reloc.getTargetSegment() == 255) {
                        relocAddr = (SegmentedAddress)this.entryPointList.get(reloc.getTargetOffset());
                    } else {
                        int seg = st.getSegments()[reloc.getTargetSegment() - 1].getSegmentID();
                        int off = Conv.shortToInt((short)reloc.getTargetOffset());
                        relocAddr = space.getAddress(seg, off);
                    }
                } else if (reloc.isImportName()) {
                    String procname;
                    String modname = this.getRelocationModuleName(mrt, reloc);
                    symbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)program, (String)(modname + "_" + (procname = imp.getNameAt(reloc.getTargetOffset()).getString())), err -> log.error("NE", err));
                    relocAddr = symbol == null ? null : (SegmentedAddress)symbol.getAddress();
                } else if (reloc.isImportOrdinal()) {
                    int ordinal;
                    String modname = this.getRelocationModuleName(mrt, reloc);
                    symbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)program, (String)(modname + "_Ordinal_" + (ordinal = Conv.shortToInt((short)reloc.getTargetOffset()))), err -> log.error("NE", err));
                    relocAddr = symbol == null ? null : (SegmentedAddress)symbol.getAddress();
                } else if (reloc.isOpSysFixup()) {
                    // empty if block
                }
                if (relocAddr == null) continue;
                byte relocType = reloc.getType();
                do {
                    SegmentedAddress address = space.getAddress(segment, offset);
                    try {
                        byte[] bytes = new byte[SegmentRelocation.TYPE_LENGTHS[relocType]];
                        memory.getBytes((Address)address, bytes);
                        relocTable.add((Address)address, (int)relocType, reloc.getValues(), bytes, null);
                        offset = this.relocate(memory, reloc, address, relocAddr);
                    }
                    catch (MemoryAccessException e) {
                        log.appendMsg("Relocation does not exist in memory: " + relocAddr);
                        continue block3;
                    }
                } while (!reloc.isAdditive() && offset > 0 && offset < 65535 && !monitor.isCancelled());
            }
        }
    }

    private int relocate(Memory memory, SegmentRelocation reloc, SegmentedAddress address, SegmentedAddress relocAddr) throws MemoryAccessException {
        int value = 0;
        switch (reloc.getType()) {
            case 0: {
                value = memory.getByte((Address)address) & 0xFF;
                memory.setByte((Address)address, (byte)relocAddr.getSegmentOffset());
                break;
            }
            case 2: {
                value = memory.getShort((Address)address) & 0xFFFF;
                int relocSeg = relocAddr.getSegment();
                memory.setByte((Address)address, (byte)relocSeg);
                memory.setByte(address.addWrap(1L), (byte)(relocSeg >> 8));
                break;
            }
            case 5: {
                value = memory.getShort((Address)address) & 0xFFFF;
                long relocOff = relocAddr.getSegmentOffset();
                memory.setByte((Address)address, (byte)relocOff);
                memory.setByte(address.addWrap(1L), (byte)(relocOff >> 8));
                break;
            }
            case 3: {
                value = memory.getInt((Address)address);
                int relocSeg = relocAddr.getSegment();
                long relocOff = relocAddr.getSegmentOffset();
                long farAddr = (long)(relocSeg << 16) | relocOff;
                if (reloc.isAdditive()) {
                    farAddr += (long)value;
                }
                memory.setInt((Address)address, (int)farAddr);
                break;
            }
            case 12: {
                break;
            }
        }
        return value;
    }

    private String getRelocationModuleName(ModuleReferenceTable mrt, SegmentRelocation reloc) {
        if (reloc.isImportName() || reloc.isImportOrdinal()) {
            LengthStringSet[] names = mrt.getNames();
            return names[reloc.getTargetSegment() - 1].getString();
        }
        return null;
    }

    private String getRelocationProcName(SegmentRelocation reloc, ImportedNameTable imp) throws IOException {
        if (reloc.isImportName()) {
            return imp.getNameAt(reloc.getTargetOffset()).getString();
        }
        if (reloc.isImportOrdinal()) {
            int ordinal = Conv.shortToInt((short)reloc.getTargetOffset());
            return "Ordinal_" + ordinal;
        }
        return null;
    }

    private void initVars() {
        this.entryPointList.clear();
        this.entryPointList.add(null);
    }

    private void setRegisterDS(InformationBlock ib, SegmentTable segmentTable, ProgramContext context, Address start, Address end) {
        byte progflag = ib.getProgramFlags();
        boolean isSingleData = (progflag & 1) != 0;
        boolean isMultipleData = (progflag & 2) != 0;
        Register ds = context.getRegister("ds");
        try {
            if (isSingleData || isMultipleData) {
                short autoDataSeg = ib.getAutomaticDataSegment();
                long regval = segmentTable.getSegments()[autoDataSeg - 1].getSegmentID();
                context.setValue(ds, start, end, BigInteger.valueOf(regval));
            } else {
                context.remove(start, end, ds);
            }
        }
        catch (ContextChangeException contextChangeException) {
            // empty catch block
        }
    }

    private void createSymbols(LengthStringOrdinalSet[] lengthStringOrdinalSets, SymbolTable symbolTable) {
        for (LengthStringOrdinalSet lengthStringOrdinalSet : lengthStringOrdinalSets) {
            Address addr;
            int ordinal = Conv.shortToInt((short)lengthStringOrdinalSet.getOrdinal());
            if (ordinal >= this.entryPointList.size() || (addr = this.entryPointList.get(ordinal)) == null) continue;
            String name = lengthStringOrdinalSet.getString();
            name = SymbolUtilities.replaceInvalidChars((String)name, (boolean)true);
            try {
                symbolTable.createLabel(addr, name, SourceType.IMPORTED);
                symbolTable.createLabel(addr, "Ordinal_" + ordinal, SourceType.IMPORTED);
            }
            catch (InvalidInputException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getName() {
        return NE_NAME;
    }

    private class CallNameComparator
    implements Comparator<String> {
        private int prefixLength = "Ordinal_".length();

        private CallNameComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1.startsWith("Ordinal_") && s2.startsWith("Ordinal_")) {
                int i2;
                int i1 = Integer.parseInt(s1.substring(this.prefixLength));
                if (i1 < (i2 = Integer.parseInt(s2.substring(this.prefixLength)))) {
                    return -1;
                }
                if (i1 > i2) {
                    return 1;
                }
                return 0;
            }
            return s1.compareTo(s2);
        }
    }
}

