/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldUtils;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.CommentUtils;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class PreCommentFieldFactory
extends FieldFactory {
    private static String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String FIELD_NAME = "Pre-Comment";
    private static final String GROUP_TITLE = "Format Code";
    private static final String FIELD_GROUP_TITLE = "Pre-Comment";
    public static final String ENABLE_WORD_WRAP_MSG = "Pre-Comment.Enable Word Wrapping";
    public static final String ENABLE_ALWAYS_SHOW_AUTOMATIC_MSG = "Pre-Comment.Always Show the Automatic Comment";
    static final String FLAG_FUNCTION_ENTRY_OPTION = "Format Code.Flag Function Entry";
    static final String FLAG_SUBROUTINE_ENTRY_OPTION = "Format Code.Flag Subroutine Entry";
    static String FUNCTION_FLAG_COMMENT;
    static String SUBROUTINE_FLAG_COMMENT;
    private boolean flagFunctionEntry;
    private boolean flagSubroutineEntry;
    private boolean isWordWrap;
    private boolean alwaysShowAutomatic;
    private Color automaticCommentColor;
    private int automaticCommentStyle;

    public PreCommentFieldFactory() {
        super("Pre-Comment");
    }

    private PreCommentFieldFactory(FieldFormatModel model, HighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super("Pre-Comment", model, hlProvider, displayOptions, fieldOptions);
        fieldOptions.registerOption(FLAG_FUNCTION_ENTRY_OPTION, (Object)false, null, null);
        fieldOptions.registerOption(FLAG_SUBROUTINE_ENTRY_OPTION, (Object)false, null, null);
        this.flagFunctionEntry = fieldOptions.getBoolean(FLAG_FUNCTION_ENTRY_OPTION, false);
        this.flagSubroutineEntry = fieldOptions.getBoolean(FLAG_SUBROUTINE_ENTRY_OPTION, false);
        this.automaticCommentColor = displayOptions.getColor(OptionsGui.COMMENT_AUTO.getColorOptionName(), OptionsGui.COMMENT_AUTO.getDefaultColor());
        this.automaticCommentStyle = displayOptions.getInt(OptionsGui.COMMENT_AUTO.getStyleOptionName(), -1);
        this.init(fieldOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof CodeUnit)) {
            return null;
        }
        int x = this.startX + varWidth;
        CodeUnit cu = (CodeUnit)obj;
        String[] autoComment = this.getAutoPreComments(cu);
        String[] comments = this.getDefinedPreComments(cu);
        return this.getTextField(comments, autoComment, proxy, x);
    }

    private String[] getDefinedPreComments(CodeUnit cu) {
        Data data;
        if (cu instanceof Data && (data = (Data)cu).getNumComponents() > 0) {
            return null;
        }
        return cu.getCommentAsArray(1);
    }

    private String[] getAutoPreComments(CodeUnit cu) {
        if (cu instanceof Instruction) {
            return this.getInstructionAutoComments((Instruction)cu);
        }
        return this.getDataAutoComments((Data)cu);
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        String[] comment = cu.getCommentAsArray(1);
        int[] cpath = null;
        if (cu instanceof Data) {
            cpath = ((Data)cu).getComponentPath();
        }
        return new CommentFieldLocation(cu.getProgram(), cu.getMinAddress(), cpath, comment, 1, row, col);
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (!(programLoc instanceof CommentFieldLocation)) {
            return null;
        }
        CommentFieldLocation loc = (CommentFieldLocation)programLoc;
        if (loc.getCommentType() != 1) {
            return null;
        }
        return new FieldLocation(index, fieldNum, loc.getRow(), loc.getCharOffset());
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 4 || category == 5;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, HighlightProvider provider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new PreCommentFieldFactory(formatModel, provider, (Options)displayOptions, (Options)fieldOptions);
    }

    @Override
    public Color getDefaultColor() {
        return OptionsGui.COMMENT_PRE.getDefaultColor();
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals(FLAG_FUNCTION_ENTRY_OPTION)) {
            this.flagFunctionEntry = (Boolean)newValue;
            this.model.update();
        } else if (optionName.equals(FLAG_SUBROUTINE_ENTRY_OPTION)) {
            this.flagSubroutineEntry = (Boolean)newValue;
            this.model.update();
        } else if (optionName.equals(ENABLE_WORD_WRAP_MSG)) {
            this.isWordWrap = (Boolean)newValue;
        } else if (optionName.equals(ENABLE_ALWAYS_SHOW_AUTOMATIC_MSG)) {
            this.alwaysShowAutomatic = (Boolean)newValue;
        }
    }

    private String[] getInstructionAutoComments(Instruction instr) {
        Symbol symbol;
        Function function;
        Program program = instr.getProgram();
        Address addr = instr.getMinAddress();
        if (this.flagFunctionEntry && (function = program.getListing().getFunctionAt(addr)) != null) {
            return new String[]{FUNCTION_FLAG_COMMENT};
        }
        if (this.flagSubroutineEntry && (symbol = program.getSymbolTable().getPrimarySymbol(addr)) != null) {
            boolean isSubroutine = false;
            ReferenceIterator iter = program.getReferenceManager().getReferencesTo(addr);
            while (iter.hasNext()) {
                Reference ref = iter.next();
                RefType refType = ref.getReferenceType();
                if (refType != RefType.CONDITIONAL_CALL && refType != RefType.UNCONDITIONAL_CALL) continue;
                isSubroutine = true;
                break;
            }
            if (isSubroutine) {
                return new String[]{SUBROUTINE_FLAG_COMMENT};
            }
        }
        return null;
    }

    private String[] getDataAutoComments(Data data) {
        Address addr = data.getMinAddress().previous();
        if (addr != null) {
            return this.getFlexArrayComment(data, addr);
        }
        return null;
    }

    private String[] getFlexArrayComment(Data data, Address addr) {
        Data originalParent = data.getParent();
        int levelsToIgnore = 0;
        boolean includeStructureName = true;
        int[] cpath = data.getComponentPath();
        if (cpath != null && cpath.length > 0) {
            if (cpath[cpath.length - 1] <= 0) {
                return null;
            }
            data = data.getParent().getComponent(cpath[cpath.length - 1] - 1);
            levelsToIgnore = cpath.length - 1;
            includeStructureName = false;
        } else {
            data = data.getProgram().getListing().getDefinedDataContaining(addr);
        }
        while (data != null) {
            DataType dt = data.getBaseDataType();
            if (dt instanceof Union || dt instanceof Array || dt instanceof Dynamic) {
                return null;
            }
            int offset = (int)addr.subtract(data.getMinAddress());
            Data component = data.getComponentAt(offset);
            if (component == null) {
                data = data.getParent();
                break;
            }
            data = component;
        }
        if (data == null || originalParent != null && data == originalParent) {
            return null;
        }
        return this.buildFlexArrayComment(data, levelsToIgnore, includeStructureName);
    }

    private String[] buildFlexArrayComment(Data data, int levelsToIgnore, boolean includeStructureName) {
        int cpathIndex;
        DataType dt = data.getBaseDataType();
        if (!(dt instanceof Structure)) {
            return null;
        }
        DataTypeComponent flexComponent = ((Structure)dt).getFlexibleArrayComponent();
        if (flexComponent == null) {
            return null;
        }
        String fieldName = flexComponent.getFieldName();
        if (fieldName == null) {
            fieldName = flexComponent.getDefaultFieldName();
        }
        StringBuilder flexName = new StringBuilder(fieldName);
        int[] cpath = data.getComponentPath();
        int n = cpathIndex = cpath != null ? cpath.length - 1 : -1;
        while (cpathIndex >= levelsToIgnore) {
            Data parent = data.getParent();
            Data component = parent.getComponent(cpath[cpathIndex--]);
            flexName.insert(0, component.getFieldName() + ".");
            data = component;
        }
        if (includeStructureName) {
            flexName.insert(0, data.getDataType().getName() + ".");
        }
        return new String[]{"Flexible Array: " + flexComponent.getDataType().getName() + "[] " + flexName.toString()};
    }

    private ListingTextField getTextField(String[] comments, String[] autoComment, ProxyObj<?> proxy, int xStart) {
        int nLinesAutoComment;
        if (comments == null) {
            comments = EMPTY_STRING_ARRAY;
        }
        if (autoComment == null) {
            autoComment = EMPTY_STRING_ARRAY;
        }
        int n = nLinesAutoComment = comments.length == 0 || this.alwaysShowAutomatic ? autoComment.length : 0;
        if (comments.length == 0 && nLinesAutoComment == 0) {
            return null;
        }
        CodeUnit cu = (CodeUnit)proxy.getObject();
        Program program = cu.getProgram();
        AttributedString prototypeString = new AttributedString("prototype", this.color, this.getMetrics());
        List fields = new ArrayList<Object>();
        for (int i = 0; i < nLinesAutoComment; ++i) {
            AttributedString as = new AttributedString(autoComment[i], this.automaticCommentColor, this.getMetrics(this.automaticCommentStyle), false, null);
            fields.add(new TextFieldElement(as, i, 0));
        }
        for (String comment : comments) {
            fields.add(CommentUtils.parseTextForAnnotations(comment, program, prototypeString, fields.size()));
        }
        if (this.isWordWrap) {
            fields = FieldUtils.wrap(fields, (int)this.width);
        }
        FieldElement[] elements = fields.toArray(new FieldElement[fields.size()]);
        return ListingTextField.createMultilineTextField(this, proxy, elements, xStart, this.width, Integer.MAX_VALUE, this.hlProvider);
    }

    private void init(Options options) {
        int i;
        options.registerOption(ENABLE_WORD_WRAP_MSG, (Object)false, null, "Enables word wrapping in the pre-comments field.  If word wrapping is on, user enter new lines are ignored and the entire comment is displayed in paragraph form.  If word wrapping is off, comments are displayed in line format however the user entered them.  Lines that are too long for the field, are truncated.");
        options.registerOption(ENABLE_ALWAYS_SHOW_AUTOMATIC_MSG, (Object)true, null, null);
        this.isWordWrap = options.getBoolean(ENABLE_WORD_WRAP_MSG, false);
        this.alwaysShowAutomatic = options.getBoolean(ENABLE_ALWAYS_SHOW_AUTOMATIC_MSG, true);
        if (FUNCTION_FLAG_COMMENT != null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        for (i = 0; i < 20; ++i) {
            sb.append("|");
        }
        sb.append(" FUNCTION ");
        for (i = 0; i < 50; ++i) {
            sb.append("|");
        }
        sb.append("\n");
        FUNCTION_FLAG_COMMENT = sb.toString();
        sb.setLength(0);
        sb.append("\n");
        for (i = 0; i < 19; ++i) {
            sb.append("|");
        }
        sb.append(" SUBROUTINE ");
        for (i = 0; i < 49; ++i) {
            sb.append("|");
        }
        sb.append("\n");
        SUBROUTINE_FLAG_COMMENT = sb.toString();
        options.registerOption(FLAG_SUBROUTINE_ENTRY_OPTION, (Object)false, null, "Toggle for whether a pre comment should be displayed at the entry point of a subroutine.");
        options.registerOption(FLAG_FUNCTION_ENTRY_OPTION, (Object)false, null, "Toggle for whether a pre comment should be displayed at the entry point of a function.");
    }
}

