/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.GFile;
import ghidra.util.classfinder.ExtensionPoint;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public interface GFileSystem
extends Closeable,
ExtensionPoint {
    public String getName();

    default public String getType() {
        return FSUtilities.getFilesystemTypeFromClass(this.getClass());
    }

    default public String getDescription() {
        return FSUtilities.getFilesystemDescriptionFromClass(this.getClass());
    }

    public FSRLRoot getFSRL();

    public boolean isClosed();

    default public boolean isStatic() {
        return true;
    }

    public FileSystemRefManager getRefManager();

    default public int getFileCount() {
        return -1;
    }

    public GFile lookup(String var1) throws IOException;

    public InputStream getInputStream(GFile var1, TaskMonitor var2) throws IOException, CancelledException;

    public List<GFile> getListing(GFile var1) throws IOException;

    public String getInfo(GFile var1, TaskMonitor var2) throws IOException;
}

